/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.util.ArrayUtil;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

public final class UnsignedShortArrayList
implements Cloneable {
    private char[] myData;
    private int mySize;

    public UnsignedShortArrayList(int initialCapacity) {
        this.myData = new char[initialCapacity];
    }

    public UnsignedShortArrayList() {
        this(10);
    }

    public void trimToSize() {
        if (this.mySize < this.myData.length) {
            this.myData = ArrayUtil.realloc(this.myData, this.mySize);
        }
    }

    public void ensureCapacity(int minCapacity) {
        int oldCapacity = this.myData.length;
        if (minCapacity > oldCapacity) {
            char[] oldData = this.myData;
            int newCapacity = oldCapacity * 3 / 2 + 1;
            if (newCapacity < minCapacity) {
                newCapacity = minCapacity;
            }
            this.myData = new char[newCapacity];
            System.arraycopy(oldData, 0, this.myData, 0, this.mySize);
        }
    }

    public int size() {
        return this.mySize;
    }

    public Object clone() {
        try {
            UnsignedShortArrayList v2 = (UnsignedShortArrayList)super.clone();
            v2.myData = (char[])this.myData.clone();
            return v2;
        }
        catch (CloneNotSupportedException e2) {
            throw new InternalError();
        }
    }

    public int @NotNull [] toArray() {
        int[] nArray = this.toArray(0, this.mySize);
        if (nArray == null) {
            UnsignedShortArrayList.$$$reportNull$$$0(0);
        }
        return nArray;
    }

    public int @NotNull [] toArray(int startIndex, int length) {
        int[] result2 = new int[length];
        for (int i2 = startIndex; i2 < length; ++i2) {
            int c2;
            result2[i2 - startIndex] = c2 = this.myData[i2];
        }
        if (result2 == null) {
            UnsignedShortArrayList.$$$reportNull$$$0(3);
        }
        return result2;
    }

    public int getQuick(int index) {
        return this.myData[index];
    }

    public void setQuick(int index, int element) {
        UnsignedShortArrayList.assertShort(element);
        this.myData[index] = (char)element;
    }

    private static void assertShort(int element) {
        assert (element >= 0 && element < 65536) : element;
    }

    public void add(int element) {
        this.ensureCapacity(this.mySize + 1);
        this.setQuick(this.mySize++, element);
    }

    public String toString() {
        return Arrays.toString(this.toArray());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 2;
                break;
            }
            case 1: {
                n3 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/containers/UnsignedShortArrayList";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "a";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "toArray";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/containers/UnsignedShortArrayList";
                break;
            }
        }
        switch (n2) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "toArray";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

