
#ifndef KMIME_EXPORT_H
#define KMIME_EXPORT_H

#ifdef KMIME_STATIC_DEFINE
#  define KMIME_EXPORT
#  define KMIME_NO_EXPORT
#else
#  ifndef KMIME_EXPORT
#    ifdef KPim6Mime_EXPORTS
        /* We are building this library */
#      define KMIME_EXPORT __attribute__((visibility("default")))
#    else
        /* We are using this library */
#      define KMIME_EXPORT __attribute__((visibility("default")))
#    endif
#  endif

#  ifndef KMIME_NO_EXPORT
#    define KMIME_NO_EXPORT __attribute__((visibility("hidden")))
#  endif
#endif

#ifndef KMIME_DECL_DEPRECATED
#  define KMIME_DECL_DEPRECATED __attribute__ ((__deprecated__))
#endif

#ifndef KMIME_DECL_DEPRECATED_EXPORT
#  define KMIME_DECL_DEPRECATED_EXPORT KMIME_EXPORT KMIME_DECL_DEPRECATED
#endif

#ifndef KMIME_DECL_DEPRECATED_NO_EXPORT
#  define KMIME_DECL_DEPRECATED_NO_EXPORT KMIME_NO_EXPORT KMIME_DECL_DEPRECATED
#endif

/* NOLINTNEXTLINE(readability-avoid-unconditional-preprocessor-if) */
#if 0 /* DEFINE_NO_DEPRECATED */
#  ifndef KMIME_NO_DEPRECATED
#    define KMIME_NO_DEPRECATED
#  endif
#endif
#include <kmime_version.h>

#define KMIME_DECL_DEPRECATED_TEXT(text) __attribute__ ((__deprecated__(text)))

#if defined(KMIME_NO_DEPRECATED)
#  undef KMIME_DEPRECATED
#  define KMIME_DEPRECATED_EXPORT KMIME_EXPORT
#  define KMIME_DEPRECATED_NO_EXPORT KMIME_NO_EXPORT
#elif defined(KMIME_NO_DEPRECATED_WARNINGS)
#  define KMIME_DEPRECATED
#  define KMIME_DEPRECATED_EXPORT KMIME_EXPORT
#  define KMIME_DEPRECATED_NO_EXPORT KMIME_NO_EXPORT
#else
#  define KMIME_DEPRECATED KMIME_DECL_DEPRECATED
#  define KMIME_DEPRECATED_EXPORT KMIME_DECL_DEPRECATED_EXPORT
#  define KMIME_DEPRECATED_NO_EXPORT KMIME_DECL_DEPRECATED_NO_EXPORT
#endif

/* No deprecated API had been removed from build */
#define KMIME_EXCLUDE_DEPRECATED_BEFORE_AND_AT 0

#define KMIME_BUILD_DEPRECATED_SINCE(major, minor) 1

#ifdef KMIME_NO_DEPRECATED
#  define KMIME_DISABLE_DEPRECATED_BEFORE_AND_AT KMIME_VERSION
#endif
#ifdef KMIME_NO_DEPRECATED_WARNINGS
#  define KMIME_DEPRECATED_WARNINGS_SINCE 0
#endif

#ifndef KMIME_DEPRECATED_WARNINGS_SINCE
#  ifdef KMIME_DISABLE_DEPRECATED_BEFORE_AND_AT
#    define KMIME_DEPRECATED_WARNINGS_SINCE KMIME_DISABLE_DEPRECATED_BEFORE_AND_AT
#  else
#    define KMIME_DEPRECATED_WARNINGS_SINCE KMIME_VERSION
#  endif
#endif

#ifndef KMIME_DISABLE_DEPRECATED_BEFORE_AND_AT
#  define KMIME_DISABLE_DEPRECATED_BEFORE_AND_AT 0
#endif

#ifdef KMIME_DEPRECATED
#  define KMIME_ENABLE_DEPRECATED_SINCE(major, minor) (((major<<16)|(minor<<8)) > KMIME_DISABLE_DEPRECATED_BEFORE_AND_AT)
#else
#  define KMIME_ENABLE_DEPRECATED_SINCE(major, minor) 0
#endif

#endif /* KMIME_EXPORT_H */
