
use builtin;
use str;

set edit:completion:arg-completer[jwt] = {|@words|
    fn spaces {|n|
        builtin:repeat $n ' ' | str:join ''
    }
    fn cand {|text desc|
        edit:complex-candidate $text &display=$text' '(spaces (- 14 (wcswidth $text)))$desc
    }
    var command = 'jwt'
    for word $words[1..-1] {
        if (str:has-prefix $word '-') {
            break
        }
        set command = $command';'$word
    }
    var completions = [
        &'jwt'= {
            cand -h 'Print help'
            cand --help 'Print help'
            cand -V 'Print version'
            cand --version 'Print version'
            cand encode 'Encode new JWTs'
            cand decode 'Decode a JWT'
            cand completion 'Print completion'
            cand help 'Print this message or the help of the given subcommand(s)'
        }
        &'jwt;encode'= {
            cand -A 'the algorithm to use for signing the JWT'
            cand --alg 'the algorithm to use for signing the JWT'
            cand -k 'the kid to place in the header'
            cand --kid 'the kid to place in the header'
            cand -t 'the type of token being encoded'
            cand --typ 'the type of token being encoded'
            cand -P 'a key=value pair to add to the payload'
            cand --payload 'a key=value pair to add to the payload'
            cand -e 'the time the token should expire, in seconds or a systemd.time string'
            cand --exp 'the time the token should expire, in seconds or a systemd.time string'
            cand -i 'the issuer of the token'
            cand --iss 'the issuer of the token'
            cand -s 'the subject of the token'
            cand --sub 'the subject of the token'
            cand -a 'the audience of the token'
            cand --aud 'the audience of the token'
            cand --jti 'the jwt id of the token'
            cand -n 'the time the JWT should become valid, in seconds or a systemd.time string'
            cand --nbf 'the time the JWT should become valid, in seconds or a systemd.time string'
            cand -S 'the secret to sign the JWT with. Prefix with @ to read from a file or b64: to use base-64 encoded bytes'
            cand --secret 'the secret to sign the JWT with. Prefix with @ to read from a file or b64: to use base-64 encoded bytes'
            cand -o 'The path of the file to write the result to (suppresses default standard output)'
            cand --out 'The path of the file to write the result to (suppresses default standard output)'
            cand --no-iat 'prevent an iat claim from being automatically added'
            cand --no-typ 'prevent typ from being added to the header'
            cand --keep-payload-order 'prevent re-ordering of payload keys'
            cand -h 'Print help'
            cand --help 'Print help'
            cand -V 'Print version'
            cand --version 'Print version'
        }
        &'jwt;decode'= {
            cand -A 'The algorithm used to sign the JWT'
            cand --alg 'The algorithm used to sign the JWT'
            cand --date 'Display unix timestamps as ISO 8601 dates [default: UTC] [possible values: UTC, Local, Offset (e.g. -02:00)]'
            cand -S 'The secret to validate the JWT with. Prefix with @ to read from a file or b64: to use base-64 encoded bytes'
            cand --secret 'The secret to validate the JWT with. Prefix with @ to read from a file or b64: to use base-64 encoded bytes'
            cand -o 'The path of the file to write the result to (suppresses default standard output, implies JSON format)'
            cand --out 'The path of the file to write the result to (suppresses default standard output, implies JSON format)'
            cand -j 'Render the decoded JWT as JSON'
            cand --json 'Render the decoded JWT as JSON'
            cand --ignore-exp 'Ignore token expiration date (`exp` claim) during validation'
            cand -h 'Print help'
            cand --help 'Print help'
            cand -V 'Print version'
            cand --version 'Print version'
        }
        &'jwt;completion'= {
            cand -h 'Print help'
            cand --help 'Print help'
            cand -V 'Print version'
            cand --version 'Print version'
        }
        &'jwt;help'= {
            cand encode 'Encode new JWTs'
            cand decode 'Decode a JWT'
            cand completion 'Print completion'
            cand help 'Print this message or the help of the given subcommand(s)'
        }
        &'jwt;help;encode'= {
        }
        &'jwt;help;decode'= {
        }
        &'jwt;help;completion'= {
        }
        &'jwt;help;help'= {
        }
    ]
    $completions[$command]
}
