/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util.io;

import java.io.IOException;
import java.nio.channels.ClosedSelectorException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.spi.SelectorProvider;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.jruby.util.io.SelectorFactory;

public class SelectorPool {
    private final Map<SelectorProvider, Queue<Selector>> pool = new ConcurrentHashMap<SelectorProvider, Queue<Selector>>();

    public Selector get() throws IOException {
        return this.retrieveFromPool(SelectorProvider.provider());
    }

    public Selector get(SelectorProvider provider) throws IOException {
        return this.retrieveFromPool(provider);
    }

    public void put(Selector selector) {
        try {
            for (SelectionKey key2 : selector.keys()) {
                if (key2 == null) continue;
                key2.cancel();
            }
            try {
                selector.selectNow();
            }
            catch (Exception exception2) {
                // empty catch block
            }
            this.returnToPool(selector);
        }
        catch (ClosedSelectorException closedSelectorException) {
            // empty catch block
        }
    }

    public void cleanup() {
        this.pool.forEach(SelectorPool::clearProviderPool);
        this.pool.clear();
    }

    private static void clearProviderPool(SelectorProvider provider, Queue<Selector> providerPool) {
        while (!providerPool.isEmpty()) {
            Selector selector;
            try {
                selector = providerPool.remove();
            }
            catch (NoSuchElementException nsme) {
                break;
            }
            try {
                selector.close();
            }
            catch (IOException iOException) {}
        }
    }

    private Selector retrieveFromPool(SelectorProvider provider) throws IOException {
        Queue<Selector> providerPool = this.pool.get(provider);
        if (providerPool != null && !providerPool.isEmpty()) {
            try {
                return providerPool.remove();
            }
            catch (NoSuchElementException noSuchElementException) {
                // empty catch block
            }
        }
        return SelectorFactory.openWithRetryFrom(null, provider);
    }

    private void returnToPool(Selector selector) {
        if (selector.isOpen()) {
            SelectorProvider provider = selector.provider();
            Queue providerPool = this.pool.computeIfAbsent(provider, p2 -> new ConcurrentLinkedQueue());
            providerPool.add(selector);
        }
    }
}

