/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.ffi.jffi;

import org.jruby.RubyString;
import org.jruby.ext.ffi.ArrayMemoryIO;
import org.jruby.ext.ffi.MemoryIO;
import org.jruby.ext.ffi.jffi.NativeStringHandle;
import org.jruby.ext.ffi.jffi.PointerParameterStrategy;
import org.jruby.ext.ffi.jffi.TransientNativeMemoryIO;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;
import org.jruby.util.StringSupport;

public final class StringParameterStrategy
extends PointerParameterStrategy {
    private final boolean checkStringSafety;

    public StringParameterStrategy(boolean isDirect, boolean checkStringSafety) {
        super(isDirect, isDirect);
        this.checkStringSafety = checkStringSafety;
    }

    @Override
    public long address(Object parameter) {
        return this.getMemoryIO(parameter).address();
    }

    @Override
    public final MemoryIO getMemoryIO(Object parameter) {
        return StringParameterStrategy.getMemoryIO((RubyString)parameter, this.isDirect(), this.checkStringSafety);
    }

    static MemoryIO getMemoryIO(RubyString s2, boolean isDirect, boolean checkStringSafety) {
        MemoryIO memory;
        Object existingHandle = s2.getFFIHandle();
        if (existingHandle instanceof NativeStringHandle) {
            NativeStringHandle sh = (NativeStringHandle)existingHandle;
            if (s2.getByteList() == sh.bl && sh.memory.isDirect() == isDirect) {
                return sh.memory;
            }
        }
        ByteList bl = s2.getByteList();
        if (checkStringSafety) {
            StringSupport.checkStringSafety(s2.getRuntime(), s2);
        }
        if (isDirect) {
            memory = TransientNativeMemoryIO.allocateAligned(s2.getRuntime(), bl.length() + 1, 1, false);
            memory.putZeroTerminatedByteArray(0L, bl.unsafeBytes(), bl.begin(), bl.length());
        } else {
            memory = new ArrayMemoryIO(s2.getRuntime(), bl.unsafeBytes(), bl.begin(), bl.length());
        }
        s2.setByteListShared();
        s2.setFFIHandle(new NativeStringHandle(memory, s2.getByteList()));
        return memory;
    }

    @Override
    public Object object(Object parameter) {
        if (this.checkStringSafety) {
            StringSupport.checkStringSafety(((IRubyObject)parameter).getRuntime(), (IRubyObject)parameter);
        }
        return ((RubyString)parameter).getByteList().unsafeBytes();
    }

    @Override
    public int offset(Object parameter) {
        return ((RubyString)parameter).getByteList().begin();
    }

    @Override
    public int length(Object parameter) {
        return ((RubyString)parameter).getByteList().length();
    }
}

