/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.ffi;

import java.util.Locale;
import java.util.Map;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyModule;
import org.jruby.RubyObject;
import org.jruby.RubySymbol;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.api.Convert;
import org.jruby.api.Create;
import org.jruby.api.Error;
import org.jruby.ext.ffi.Factory;
import org.jruby.ext.ffi.NativeType;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

@JRubyClass(name={"FFI::Type"}, parent="Object")
public abstract class Type
extends RubyObject {
    private static final Locale LOCALE = Locale.ENGLISH;
    protected final NativeType nativeType;
    protected final int size;
    protected final int alignment;

    public static RubyClass createTypeClass(ThreadContext context, RubyModule FFI2, RubyClass Object2) {
        RubyClass Type2 = (RubyClass)((RubyModule)((RubyModule)FFI2.defineClassUnder(context, "Type", Object2, ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR)).defineMethods(context, Type.class)).defineConstants(context, Type.class);
        RubyClass Builtin2 = (RubyClass)((RubyModule)Type2.defineClassUnder(context, "Builtin", Type2, ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR)).defineMethods(context, Builtin.class);
        ((RubyModule)Type2.defineClassUnder(context, "Array", Type2, ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR)).defineMethods(context, Array.class);
        RubyModule nativeType = FFI2.defineModuleUnder(context, "NativeType");
        Type.defineBuiltinType(context, Builtin2, NativeType.CHAR, "char", "schar", "int8", "sint8");
        Type.defineBuiltinType(context, Builtin2, NativeType.UCHAR, "uchar", "uint8");
        Type.defineBuiltinType(context, Builtin2, NativeType.SHORT, "short", "sshort", "int16", "sint16");
        Type.defineBuiltinType(context, Builtin2, NativeType.USHORT, "ushort", "uint16");
        Type.defineBuiltinType(context, Builtin2, NativeType.INT, "int", "sint", "int32", "sint32");
        Type.defineBuiltinType(context, Builtin2, NativeType.UINT, "uint", "uint32");
        Type.defineBuiltinType(context, Builtin2, NativeType.LONG_LONG, "long_long", "slong_long", "int64", "sint64");
        Type.defineBuiltinType(context, Builtin2, NativeType.ULONG_LONG, "ulong_long", "uint64");
        Type.defineBuiltinType(context, Builtin2, NativeType.LONG, "long", "slong");
        Type.defineBuiltinType(context, Builtin2, NativeType.ULONG, "ulong");
        Type.defineBuiltinType(context, Builtin2, NativeType.FLOAT, "float", "float32");
        Type.defineBuiltinType(context, Builtin2, NativeType.DOUBLE, "double", "float64");
        for (NativeType t : NativeType.values()) {
            if (Builtin2.hasConstant(t.name())) continue;
            try {
                Builtin b2 = new Builtin(context, Builtin2, t, t.name().toLowerCase(LOCALE));
                Builtin2.defineConstant(context, t.name().toUpperCase(LOCALE), b2);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
        }
        for (Map.Entry entry : Builtin2.getConstantMap().entrySet()) {
            if (!(((RubyModule.ConstantEntry)entry.getValue()).value instanceof Builtin)) continue;
            Type2.defineConstant(context, (String)entry.getKey(), ((RubyModule.ConstantEntry)entry.getValue()).value);
            nativeType.defineConstant(context, (String)entry.getKey(), ((RubyModule.ConstantEntry)entry.getValue()).value);
            FFI2.defineConstant(context, "TYPE_" + (String)entry.getKey(), ((RubyModule.ConstantEntry)entry.getValue()).value);
        }
        return Type2;
    }

    private static final void defineBuiltinType(ThreadContext context, RubyClass builtinClass, NativeType nativeType, String ... names2) {
        try {
            if (names2.length > 0) {
                for (String n : names2) {
                    builtinClass.defineConstant(context, n.toUpperCase(LOCALE), new Builtin(context, builtinClass, nativeType, n.toLowerCase(LOCALE)));
                }
            } else {
                builtinClass.defineConstant(context, nativeType.name(), new Builtin(context, builtinClass, nativeType, nativeType.name().toLowerCase(LOCALE)));
            }
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    public static final RubyClass getTypeClass(Ruby runtime2) {
        return runtime2.getFFI().typeClass;
    }

    protected Type(Ruby runtime2, RubyClass klass, NativeType type2, int size2, int alignment2) {
        super(runtime2, klass);
        this.nativeType = type2;
        this.size = size2;
        this.alignment = alignment2;
    }

    protected Type(Ruby runtime2, RubyClass klass, NativeType type2) {
        super(runtime2, klass);
        this.nativeType = type2;
        this.size = Type.getNativeSize(type2);
        this.alignment = Type.getNativeAlignment(type2);
    }

    public final NativeType getNativeType() {
        return this.nativeType;
    }

    public final int getNativeSize() {
        return this.size;
    }

    public final int getNativeAlignment() {
        return this.alignment;
    }

    @JRubyMethod(name={"size"})
    public IRubyObject size(ThreadContext context) {
        return Convert.asFixnum(context, this.getNativeSize());
    }

    @JRubyMethod(name={"alignment"})
    public IRubyObject alignment(ThreadContext context) {
        return Convert.asFixnum(context, this.getNativeAlignment());
    }

    private static final boolean isPrimitive(NativeType type2) {
        switch (type2) {
            case VOID: 
            case BOOL: 
            case CHAR: 
            case UCHAR: 
            case SHORT: 
            case USHORT: 
            case INT: 
            case UINT: 
            case LONG_LONG: 
            case ULONG_LONG: 
            case LONG: 
            case ULONG: 
            case FLOAT: 
            case DOUBLE: 
            case BUFFER_IN: 
            case BUFFER_INOUT: 
            case BUFFER_OUT: 
            case POINTER: 
            case STRING: 
            case TRANSIENT_STRING: {
                return true;
            }
        }
        return false;
    }

    static final int getNativeAlignment(NativeType type2) {
        return Type.isPrimitive(type2) ? Factory.getInstance().alignmentOf(type2) : 1;
    }

    static final int getNativeSize(NativeType type2) {
        return Type.isPrimitive(type2) ? Factory.getInstance().sizeOf(type2) : 0;
    }

    @JRubyClass(name={"FFI::Type::Builtin"}, parent="FFI::Type")
    public static final class Builtin
    extends Type {
        private final RubySymbol sym;

        private Builtin(ThreadContext context, RubyClass klass, NativeType nativeType, String symName) {
            super(context.runtime, klass, nativeType, Type.getNativeSize(nativeType), Type.getNativeAlignment(nativeType));
            this.sym = Convert.asSymbol(context, symName);
        }

        @Override
        @JRubyMethod(name={"inspect"})
        public final IRubyObject inspect(ThreadContext context) {
            return Create.newString(context, String.format("#<FFI::Type::Builtin:%s size=%d alignment=%d>", this.nativeType.name(), this.size, this.alignment));
        }

        @Override
        public final String toString() {
            return this.nativeType.name();
        }

        @Override
        public boolean equals(Object obj) {
            return obj instanceof Builtin && ((Builtin)obj).nativeType.equals((Object)this.nativeType);
        }

        @Override
        public int hashCode() {
            int hash2 = 5;
            hash2 = 23 * hash2 + this.nativeType.hashCode();
            return hash2;
        }

        @JRubyMethod
        public final IRubyObject to_sym(ThreadContext context) {
            return this.sym;
        }

        @Override
        @JRubyMethod(name={"=="})
        public IRubyObject op_equal(ThreadContext context, IRubyObject obj) {
            return Convert.asBoolean(context, this.equals(obj));
        }

        @Override
        @JRubyMethod(name={"equal?"})
        public IRubyObject equal_p(ThreadContext context, IRubyObject obj) {
            return Convert.asBoolean(context, this.equals(obj));
        }

        @Override
        @JRubyMethod(name={"eql?"})
        public IRubyObject eql_p(ThreadContext context, IRubyObject obj) {
            return Convert.asBoolean(context, this.equals(obj));
        }
    }

    @JRubyClass(name={"FFI::Type::Array"}, parent="FFI::Type")
    public static final class Array
    extends Type {
        private final Type componentType;
        private final int length;

        public Array(Ruby runtime2, RubyClass klass, Type componentType, int length2) {
            super(runtime2, klass, NativeType.ARRAY, componentType.getNativeSize() * length2, componentType.getNativeAlignment());
            this.componentType = componentType;
            this.length = length2;
        }

        public Array(Ruby runtime2, Type componentType, int length2) {
            this(runtime2, Array.getTypeClass(runtime2).getClass(runtime2.getCurrentContext(), "Array"), componentType, length2);
        }

        public final Type getComponentType() {
            return this.componentType;
        }

        public final int length() {
            return this.length;
        }

        @JRubyMethod(name={"new"}, required=2, meta=true)
        public static final IRubyObject newInstance(ThreadContext context, IRubyObject klass, IRubyObject componentType, IRubyObject length2) {
            if (!(componentType instanceof Type)) {
                throw Error.typeError(context, componentType, Array.getTypeClass(context.runtime));
            }
            return new Array(context.runtime, (RubyClass)klass, (Type)componentType, Convert.toInt(context, length2));
        }

        @JRubyMethod
        public final IRubyObject length(ThreadContext context) {
            return Convert.asFixnum(context, this.length);
        }

        @JRubyMethod
        public final IRubyObject elem_type(ThreadContext context) {
            return this.componentType;
        }
    }
}

