/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ast;

import java.util.List;
import org.jruby.ast.Node;
import org.jruby.ast.NodeType;
import org.jruby.ast.visitor.NodeVisitor;
import org.jruby.parser.StaticScope;

public class SClassNode
extends Node {
    private final Node receiverNode;
    private final StaticScope scope;
    private final Node bodyNode;
    private final int endLine;

    public SClassNode(int line, Node recvNode, StaticScope scope, Node bodyNode, int endLine) {
        super(line, recvNode.containsVariableAssignment() || bodyNode.containsVariableAssignment());
        assert (scope != null) : "scope is not null";
        this.receiverNode = recvNode;
        this.scope = scope;
        this.bodyNode = bodyNode;
        this.endLine = endLine;
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.SCLASSNODE;
    }

    @Override
    public <T> T accept(NodeVisitor<T> iVisitor) {
        return iVisitor.visitSClassNode(this);
    }

    public Node getBodyNode() {
        return this.bodyNode;
    }

    public int getEndLine() {
        return this.endLine;
    }

    public StaticScope getScope() {
        return this.scope;
    }

    public Node getReceiverNode() {
        return this.receiverNode;
    }

    @Override
    public List<Node> childNodes() {
        return Node.createList(this.receiverNode, this.bodyNode);
    }
}

