/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ast;

import java.util.List;
import org.jruby.RubySymbol;
import org.jruby.ast.BlockAcceptingNode;
import org.jruby.ast.CanRaise;
import org.jruby.ast.IArgumentNode;
import org.jruby.ast.Node;
import org.jruby.ast.NodeType;
import org.jruby.ast.types.INameNode;
import org.jruby.ast.visitor.NodeVisitor;

public class FCallNode
extends Node
implements INameNode,
IArgumentNode,
BlockAcceptingNode,
CanRaise {
    private final RubySymbol name;
    protected Node argsNode;
    protected Node iterNode;

    public FCallNode(int line, RubySymbol name2) {
        this(line, name2, null, null);
    }

    public FCallNode(int line, RubySymbol name2, Node argsNode, Node iterNode) {
        super(line, argsNode != null && argsNode.containsVariableAssignment() || iterNode != null && iterNode.containsVariableAssignment());
        this.name = name2;
        this.argsNode = argsNode;
        this.iterNode = iterNode;
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.FCALLNODE;
    }

    @Override
    public <T> T accept(NodeVisitor<T> iVisitor) {
        return iVisitor.visitFCallNode(this);
    }

    @Override
    public Node getIterNode() {
        return this.iterNode;
    }

    @Override
    public Node setIterNode(Node iterNode) {
        this.iterNode = iterNode;
        return this;
    }

    @Override
    public Node getArgsNode() {
        return this.argsNode;
    }

    @Override
    public Node setArgsNode(Node argsNode) {
        this.argsNode = argsNode;
        return argsNode;
    }

    @Override
    public RubySymbol getName() {
        return this.name;
    }

    @Override
    public List<Node> childNodes() {
        return FCallNode.createList(this.argsNode, this.iterNode);
    }
}

