/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import org.jruby.Ruby;
import org.jruby.RubyArgumentError;
import org.jruby.RubyClass;
import org.jruby.RubyString;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.api.Create;
import org.jruby.api.Define;
import org.jruby.exceptions.RaiseException;
import org.jruby.exceptions.UncaughtThrowError;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;

@JRubyClass(name={"UncaughtThrowError"}, parent="ArgumentError")
public class RubyUncaughtThrowError
extends RubyArgumentError {
    private IRubyObject tag;
    private IRubyObject value;

    static RubyClass define(ThreadContext context, RubyClass ArgumentError2) {
        return (RubyClass)Define.defineClass(context, "UncaughtThrowError", ArgumentError2, RubyUncaughtThrowError::new).defineMethods(context, RubyUncaughtThrowError.class);
    }

    @Deprecated(since="10.0")
    protected RubyUncaughtThrowError(Ruby runtime2, RubyClass exceptionClass) {
        this(runtime2.getCurrentContext(), exceptionClass);
    }

    protected RubyUncaughtThrowError(ThreadContext context, RubyClass exceptionClass) {
        super(context.runtime, exceptionClass, exceptionClass.getName(context));
        this.message = context.nil;
    }

    @Deprecated(since="10.0")
    public static RubyUncaughtThrowError newUncaughtThrowError(Ruby runtime2, IRubyObject tag2, IRubyObject value2, RubyString message2) {
        return RubyUncaughtThrowError.newUncaughtThrowError(runtime2.getCurrentContext(), tag2, value2, message2);
    }

    public static RubyUncaughtThrowError newUncaughtThrowError(ThreadContext context, IRubyObject tag2, IRubyObject value2, RubyString message2) {
        RubyUncaughtThrowError error2 = new RubyUncaughtThrowError(context, context.runtime.getUncaughtThrowError());
        error2.tag = tag2;
        error2.value = value2;
        error2.message = message2;
        return error2;
    }

    @Override
    protected RaiseException constructThrowable(String message2) {
        return new UncaughtThrowError(message2, this);
    }

    @Override
    @Deprecated
    public IRubyObject initialize(IRubyObject[] args2, Block block) {
        return this.initialize(this.getRuntime().getCurrentContext(), args2, block);
    }

    @JRubyMethod(required=2, optional=1, checkArity=false, visibility=Visibility.PRIVATE)
    public IRubyObject initialize(ThreadContext context, IRubyObject[] args2, Block block) {
        int argc = Arity.checkArgumentCount(context, args2, 2, 3);
        this.tag = args2[0];
        this.value = args2[1];
        if (argc > 2) {
            this.message = args2[2];
        }
        return this;
    }

    @JRubyMethod
    public IRubyObject tag() {
        return this.tag;
    }

    @JRubyMethod
    public IRubyObject value() {
        return this.value;
    }

    @Override
    public RubyString to_s(ThreadContext context) {
        if (this.message.isNil()) {
            return Create.newEmptyString(context);
        }
        if (this.tag == null) {
            return this.message.asString();
        }
        return this.message.asString().op_format(context, Create.newArray(context, this.tag));
    }

    @Override
    public void copySpecialInstanceVariables(IRubyObject clone2) {
        super.copySpecialInstanceVariables(clone2);
        RubyUncaughtThrowError exception2 = (RubyUncaughtThrowError)clone2;
        exception2.tag = this.tag;
        exception2.value = this.value;
    }
}

