/*
 * Decompiled with CFR 0.152.
 */
package jspecview.export;

import java.io.IOException;
import javajs.util.OC;
import jspecview.common.ExportType;
import jspecview.common.JSViewer;
import jspecview.common.PanelData;
import jspecview.common.Spectrum;
import jspecview.export.XMLExporter;

public class CMLExporter
extends XMLExporter {
    @Override
    public String exportTheSpectrum(JSViewer viewer, ExportType mode, OC out, Spectrum spec, int startIndex, int endIndex, PanelData pd, boolean asBase64) throws IOException {
        if (!this.setup(viewer, spec, out, startIndex, endIndex)) {
            return null;
        }
        if (this.model == null || this.model.equals("")) {
            this.model = "unknown";
        }
        if (this.datatype.contains("MASS")) {
            this.spectypeInitials = "massSpectrum";
        } else if (this.datatype.contains("INFRARED")) {
            this.spectypeInitials = "infrared";
        } else if (this.datatype.contains("UV") || this.datatype.contains("VIS")) {
            this.spectypeInitials = "UV/VIS";
        } else if (this.datatype.contains("NMR")) {
            this.spectypeInitials = "NMR";
        }
        this.ident = this.spectypeInitials + "_" + this.title.substring(0, Math.min(10, this.title.length()));
        if (this.xUnits.toLowerCase().equals("m/z")) {
            this.xUnits = "moverz";
        } else if (this.xUnits.toLowerCase().equals("1/cm")) {
            this.xUnits = "cm-1";
        } else if (this.xUnits.toLowerCase().equals("nanometers")) {
            this.xUnits = "nm";
        }
        this.setContext();
        return this.writeFormType("cml");
    }
}

