/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.pdf.extensions;

import org.apache.fop.render.pdf.extensions.PDFObjectType;
import org.apache.fop.util.XMLUtil;

public class PDFObjectExtension {
    private PDFObjectType type;
    private Object value;

    PDFObjectExtension(PDFObjectType type) {
        this.type = type;
    }

    public PDFObjectType getType() {
        return this.type;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public Object getValue() {
        return this.value;
    }

    public Boolean getValueAsBoolean() {
        Object value = this.getValue();
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof String) {
            return Boolean.valueOf((String)value);
        }
        return false;
    }

    public Number getValueAsNumber() {
        Object value = this.getValue();
        if (value instanceof Number) {
            return (Number)value;
        }
        if (value instanceof String) {
            double d = Double.parseDouble((String)value);
            if (Math.abs(Math.floor(d) - d) < 1.0E-10) {
                return (long)d;
            }
            return d;
        }
        return 0;
    }

    public String getValueAsString() {
        Object value = this.getValue();
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            return (String)value;
        }
        return value.toString();
    }

    public String getValueAsXMLEscapedString() {
        return XMLUtil.escape((String)this.getValueAsString());
    }

    public String getElementName() {
        return this.type.elementName();
    }
}

