/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui.grid;

import com.intellij.util.ObjectUtils;
import java.awt.Color;
import org.jetbrains.annotations.Nullable;

public class CellAttributes {
    @Nullable
    private final Color myBackgroundColor;
    @Nullable
    private final Color myEffectColor;
    private final boolean myUnderlined;

    public CellAttributes(@Nullable Color backgroundColor, @Nullable Color effectColor, boolean underlined) {
        this.myBackgroundColor = backgroundColor;
        this.myEffectColor = effectColor;
        this.myUnderlined = underlined;
    }

    @Nullable
    public Color getBackgroundColor() {
        return this.myBackgroundColor;
    }

    @Nullable
    public Color getEffectColor() {
        return this.myEffectColor;
    }

    public boolean isUnderlined() {
        return this.myUnderlined;
    }

    public static CellAttributes merge(@Nullable CellAttributes under, @Nullable CellAttributes above) {
        if (above == null) {
            return under;
        }
        if (under == null) {
            return above;
        }
        return new CellAttributes((Color)ObjectUtils.chooseNotNull((Object)above.getBackgroundColor(), (Object)under.getBackgroundColor()), (Color)ObjectUtils.chooseNotNull((Object)above.getEffectColor(), (Object)under.getEffectColor()), above.isUnderlined() || under.isUnderlined());
    }
}

