/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.ui.actions.styling;

import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.client.ClientAppSession;
import com.intellij.openapi.client.ClientSessionsUtil;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ExtensionsKt;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.intellij.util.ApplicationKt;
import java.util.function.Supplier;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.intellij.plugins.markdown.MarkdownBundle;
import org.intellij.plugins.markdown.MarkdownIcons;
import org.intellij.plugins.markdown.editor.lists.ListUtils;
import org.intellij.plugins.markdown.lang.MarkdownTokenTypes;
import org.intellij.plugins.markdown.lang.psi.MarkdownPsiElementFactory;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownList;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownListItem;
import org.intellij.plugins.markdown.lang.psi.util.PsiUtilsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u0000 \u000e2\u00020\u0001:\u0005\n\u000b\f\r\u000eB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\u000f"}, d2={"Lorg/intellij/plugins/markdown/ui/actions/styling/CreateOrChangeListActionGroup;", "Lcom/intellij/openapi/actionSystem/DefaultActionGroup;", "<init>", "()V", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "", "event", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "OrderedList", "UnorderedList", "CheckmarkList", "CreateListImpl", "Companion", "intellij.markdown"})
public final class CreateOrChangeListActionGroup
extends DefaultActionGroup {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public CreateOrChangeListActionGroup() {
        AnAction[] anActionArray = new AnAction[]{new UnorderedList(), new OrderedList(), new CheckmarkList()};
        super(anActionArray);
        this.getTemplatePresentation().setPopupGroup(true);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void update(@NotNull AnActionEvent event) {
        ClientAppSession session;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        ClientAppSession clientAppSession = session = ClientSessionsUtil.getCurrentSessionOrNull((Application)ApplicationKt.getApplication());
        boolean bl = clientAppSession != null ? clientAppSession.isRemote() : false;
        if (bl) {
            event.getPresentation().setEnabledAndVisible(false);
            return;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\u000f"}, d2={"Lorg/intellij/plugins/markdown/ui/actions/styling/CreateOrChangeListActionGroup$CheckmarkList;", "Lorg/intellij/plugins/markdown/ui/actions/styling/CreateOrChangeListActionGroup$CreateListImpl;", "<init>", "()V", "isSameMarker", "", "markerElement", "Lcom/intellij/psi/PsiElement;", "createMarkerText", "", "index", "", "processListElement", "originalChild", "Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownListItem;", "intellij.markdown"})
    public static final class CheckmarkList
    extends CreateListImpl {
        public CheckmarkList() {
            Supplier<String> supplier = MarkdownBundle.messagePointer("markdown.create.list.popup.checkmark.action.text", new Object[0]);
            Intrinsics.checkNotNullExpressionValue(supplier, (String)"messagePointer(...)");
            Icon icon = MarkdownIcons.EditorActions.CheckmarkList;
            Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"CheckmarkList");
            super(supplier, null, icon, 2, null);
        }

        @Override
        public boolean isSameMarker(@NotNull PsiElement markerElement) {
            Intrinsics.checkNotNullParameter((Object)markerElement, (String)"markerElement");
            return Companion.hasCheckbox(markerElement);
        }

        @Override
        @NotNull
        public String createMarkerText(int index) {
            return index + 1 + ". [ ]";
        }

        @Override
        @NotNull
        public PsiElement processListElement(@NotNull MarkdownListItem originalChild, int index) {
            Intrinsics.checkNotNullParameter((Object)originalChild, (String)"originalChild");
            Pair<PsiElement, PsiElement> pair = MarkdownPsiElementFactory.createListMarkerWithCheckbox(originalChild.getProject(), index + 1 + ".", true);
            Intrinsics.checkNotNullExpressionValue(pair, (String)"createListMarkerWithCheckbox(...)");
            Pair<PsiElement, PsiElement> pair2 = pair;
            PsiElement marker = (PsiElement)ExtensionsKt.component1(pair2);
            PsiElement checkbox = (PsiElement)ExtensionsKt.component2(pair2);
            PsiElement psiElement = originalChild.getMarkerElement();
            Intrinsics.checkNotNull((Object)psiElement);
            PsiElement addedMarker = psiElement.replace(marker);
            originalChild.addAfter(checkbox, addedMarker);
            return (PsiElement)originalChild;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0007H\u0002\u00a8\u0006\u000b"}, d2={"Lorg/intellij/plugins/markdown/ui/actions/styling/CreateOrChangeListActionGroup$Companion;", "", "<init>", "()V", "obtainMarkerText", "", "markerElement", "Lcom/intellij/psi/PsiElement;", "hasCheckbox", "", "element", "intellij.markdown"})
    public static final class Companion {
        private Companion() {
        }

        private final String obtainMarkerText(PsiElement markerElement) {
            String string;
            String string2 = markerElement.getText();
            if (string2 != null) {
                char[] cArray = new char[]{'.', ')', ' '};
                string = StringsKt.trimEnd((String)string2, (char[])cArray);
            } else {
                string = null;
            }
            return string;
        }

        private final boolean hasCheckbox(PsiElement element2) {
            boolean bl;
            PsiElement psiElement = element2.getNextSibling();
            if (psiElement != null) {
                IElementType iElementType = MarkdownTokenTypes.CHECK_BOX;
                Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"CHECK_BOX");
                bl = PsiUtilsKt.hasType(psiElement, iElementType);
            } else {
                bl = false;
            }
            return bl;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u0000 '2\u00020\u0001:\u0001'B7\u0012\u0011\u0010\u0002\u001a\r\u0012\t\u0012\u00070\u0004\u00a2\u0006\u0002\b\u00050\u0003\u0012\u0013\b\u0002\u0010\u0006\u001a\r\u0012\t\u0012\u00070\u0004\u00a2\u0006\u0002\b\u00050\u0003\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0014H&J\u0010\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u0017H&J\u0018\u0010\u0018\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010\u001b\u001a\u00020\u001cH\u0016J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u001eH\u0002J \u0010 \u001a\u00020\f2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0002\u00a8\u0006("}, d2={"Lorg/intellij/plugins/markdown/ui/actions/styling/CreateOrChangeListActionGroup$CreateListImpl;", "Lcom/intellij/openapi/actionSystem/ToggleAction;", "text", "Ljava/util/function/Supplier;", "", "Lorg/jetbrains/annotations/Nls;", "description", "icon", "Ljavax/swing/Icon;", "<init>", "(Ljava/util/function/Supplier;Ljava/util/function/Supplier;Ljavax/swing/Icon;)V", "setSelected", "", "event", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "state", "", "isSelected", "isSameMarker", "markerElement", "Lcom/intellij/psi/PsiElement;", "createMarkerText", "index", "", "processListElement", "originalChild", "Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownListItem;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "replaceList", "Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownList;", "list", "createListFromText", "project", "Lcom/intellij/openapi/project/Project;", "document", "Lcom/intellij/openapi/editor/Document;", "caret", "Lcom/intellij/openapi/editor/Caret;", "Companion", "intellij.markdown"})
    @SourceDebugExtension(value={"SMAP\nCreateOrChangeListActionGroup.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CreateOrChangeListActionGroup.kt\norg/intellij/plugins/markdown/ui/actions/styling/CreateOrChangeListActionGroup$CreateListImpl\n+ 2 actions.kt\ncom/intellij/openapi/command/ActionsKt\n*L\n1#1,213:1\n7#2,6:214\n*S KotlinDebug\n*F\n+ 1 CreateOrChangeListActionGroup.kt\norg/intellij/plugins/markdown/ui/actions/styling/CreateOrChangeListActionGroup$CreateListImpl\n*L\n117#1:214,6\n*E\n"})
    public static abstract class CreateListImpl
    extends ToggleAction {
        @NotNull
        public static final Companion Companion = new Companion(null);

        public CreateListImpl(@NotNull Supplier<String> text2, @NotNull Supplier<String> description, @NotNull Icon icon) {
            Intrinsics.checkNotNullParameter(text2, (String)"text");
            Intrinsics.checkNotNullParameter(description, (String)"description");
            Intrinsics.checkNotNullParameter((Object)icon, (String)"icon");
            super(text2, description, icon);
        }

        public /* synthetic */ CreateListImpl(Supplier supplier, Supplier supplier2, Icon icon, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                supplier2 = supplier;
            }
            this(supplier, supplier2, icon);
        }

        public void setSelected(@NotNull AnActionEvent event, boolean state) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            Project project = event.getProject();
            if (project == null) {
                return;
            }
            Project project2 = project;
            Editor editor2 = (Editor)event.getData(CommonDataKeys.EDITOR);
            if (editor2 == null) {
                return;
            }
            Editor editor3 = editor2;
            Caret caret = (Caret)event.getData(CommonDataKeys.CARET);
            if (caret == null) {
                return;
            }
            Caret caret2 = caret;
            PsiFile psiFile = (PsiFile)event.getData(CommonDataKeys.PSI_FILE);
            if (psiFile == null) {
                return;
            }
            PsiFile file = psiFile;
            int caretOffset = caret2.getSelectionStart();
            Document document = editor3.getDocument();
            Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
            Document document2 = document;
            MarkdownList list2 = CreateListImpl.Companion.findList(file, document2, caretOffset);
            ActionsKt.runWriteAction(() -> CreateListImpl.setSelected$lambda$0(project2, state, list2, this, document2, caret2));
        }

        public boolean isSelected(@NotNull AnActionEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            PsiFile psiFile = (PsiFile)event.getData(CommonDataKeys.PSI_FILE);
            if (psiFile == null) {
                return false;
            }
            PsiFile file = psiFile;
            Editor editor2 = (Editor)event.getData(CommonDataKeys.EDITOR);
            if (editor2 == null) {
                return false;
            }
            Editor editor3 = editor2;
            Caret caret = (Caret)event.getData(CommonDataKeys.CARET);
            if (caret == null) {
                return false;
            }
            int caretOffset = caret.getOffset();
            Document document = editor3.getDocument();
            Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
            Document document2 = document;
            MarkdownList markdownList = CreateListImpl.Companion.findList(file, document2, caretOffset);
            if (markdownList == null) {
                return false;
            }
            MarkdownList list2 = markdownList;
            MarkdownListItem markdownListItem = (MarkdownListItem)CollectionsKt.firstOrNull(ListUtils.INSTANCE.getItems(list2));
            if (markdownListItem == null || (markdownListItem = markdownListItem.getMarkerElement()) == null) {
                return false;
            }
            MarkdownListItem marker = markdownListItem;
            return this.isSameMarker((PsiElement)marker);
        }

        public abstract boolean isSameMarker(@NotNull PsiElement var1);

        @NotNull
        public abstract String createMarkerText(int var1);

        @NotNull
        public PsiElement processListElement(@NotNull MarkdownListItem originalChild, int index) {
            Intrinsics.checkNotNullParameter((Object)originalChild, (String)"originalChild");
            PsiElement psiElement = MarkdownPsiElementFactory.createListMarker(originalChild.getProject(), this.createMarkerText(index));
            Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"createListMarker(...)");
            PsiElement marker = psiElement;
            PsiElement psiElement2 = originalChild.getMarkerElement();
            if (psiElement2 == null) {
                return (PsiElement)originalChild;
            }
            PsiElement originalMarker = psiElement2;
            if (Companion.hasCheckbox(originalMarker)) {
                PsiElement psiElement3 = originalMarker.getNextSibling();
                if (psiElement3 != null) {
                    psiElement3.delete();
                }
            }
            originalMarker.replace(marker);
            return (PsiElement)originalChild;
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            return ActionUpdateThread.BGT;
        }

        private final MarkdownList replaceList(MarkdownList list2) {
            MarkdownList markdownList = MarkdownPsiElementFactory.createEmptyList(list2.getProject(), true);
            Intrinsics.checkNotNullExpressionValue((Object)markdownList, (String)"createEmptyList(...)");
            MarkdownList resultList = markdownList;
            PsiElement psiElement = list2.getFirstChild();
            if (psiElement == null || (psiElement = PsiTreeUtilKt.siblings((PsiElement)psiElement, (boolean)true, (boolean)true)) == null) {
                return list2;
            }
            PsiElement children2 = psiElement;
            int itemIndex = 0;
            for (PsiElement child : children2) {
                Object object;
                if (child instanceof MarkdownListItem) {
                    resultList.add(this.processListElement((MarkdownListItem)child, itemIndex));
                    object = ++itemIndex;
                    continue;
                }
                object = resultList.add(child);
            }
            PsiElement psiElement2 = list2.replace((PsiElement)resultList);
            Intrinsics.checkNotNull((Object)psiElement2, (String)"null cannot be cast to non-null type org.intellij.plugins.markdown.lang.psi.impl.MarkdownList");
            return (MarkdownList)psiElement2;
        }

        private final void createListFromText(Project project, Document document, Caret caret) {
            int startLine = document.getLineNumber(caret.getSelectionStart());
            int endLine = document.getLineNumber(caret.getSelectionEnd());
            CharSequence charSequence = document.getCharsSequence();
            Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"getCharsSequence(...)");
            CharSequence text2 = charSequence;
            Sequence lines = SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)((Iterable)new IntRange(startLine, endLine))), arg_0 -> CreateListImpl.createListFromText$lambda$0(text2, document, arg_0));
            MarkdownList markdownList = MarkdownPsiElementFactory.createList(project, SequencesKt.asIterable((Sequence)lines), arg_0 -> CreateListImpl.createListFromText$lambda$1((Function1)new Function1<Integer, String>((Object)this){

                public final String invoke(int p0) {
                    return ((CreateListImpl)((Object)this.receiver)).createMarkerText(p0);
                }
            }, arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)markdownList, (String)"createList(...)");
            MarkdownList list2 = markdownList;
            document.replaceString(document.getLineStartOffset(startLine), document.getLineEndOffset(endLine), (CharSequence)list2.getText());
        }

        private static final Unit setSelected$lambda$0(Project $project, boolean $state, MarkdownList $list, CreateListImpl this$0, Document $document, Caret $caret) {
            Project project$iv = $project;
            String name$iv = null;
            Object groupId$iv = null;
            boolean $i$f$executeCommand = false;
            CommandProcessor.getInstance().executeCommand(project$iv, new Runnable($state, $list, this$0, $project, $document, $caret){
                final /* synthetic */ boolean $state$inlined;
                final /* synthetic */ MarkdownList $list$inlined;
                final /* synthetic */ CreateListImpl this$0;
                final /* synthetic */ Project $project$inlined;
                final /* synthetic */ Document $document$inlined;
                final /* synthetic */ Caret $caret$inlined;
                {
                    this.$state$inlined = bl;
                    this.$list$inlined = markdownList;
                    this.this$0 = createListImpl;
                    this.$project$inlined = project;
                    this.$document$inlined = document;
                    this.$caret$inlined = caret;
                }

                public final void run() {
                    boolean bl = false;
                    if (this.$state$inlined && this.$list$inlined == null) {
                        CreateListImpl.access$createListFromText(this.this$0, this.$project$inlined, this.$document$inlined, this.$caret$inlined);
                    } else if (this.$state$inlined && this.$list$inlined != null) {
                        CreateListImpl.access$replaceList(this.this$0, this.$list$inlined);
                    } else if (!this.$state$inlined && this.$list$inlined != null) {
                        Companion.access$replaceListWithText(CreateListImpl.Companion, this.$document$inlined, this.$list$inlined);
                    }
                }
            }, name$iv, groupId$iv);
            return Unit.INSTANCE;
        }

        private static final String createListFromText$lambda$0(CharSequence $text, Document $document, int it) {
            return ((Object)$text.subSequence($document.getLineStartOffset(it), $document.getLineEndOffset(it))).toString();
        }

        private static final String createListFromText$lambda$1(Function1 $tmp0, Object p0) {
            return (String)$tmp0.invoke(p0);
        }

        public static final /* synthetic */ void access$createListFromText(CreateListImpl $this, Project project, Document document, Caret caret) {
            $this.createListFromText(project, document, caret);
        }

        public static final /* synthetic */ MarkdownList access$replaceList(CreateListImpl $this, MarkdownList list2) {
            return $this.replaceList(list2);
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\"\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u0005H\u0002\u00a8\u0006\u000f"}, d2={"Lorg/intellij/plugins/markdown/ui/actions/styling/CreateOrChangeListActionGroup$CreateListImpl$Companion;", "", "<init>", "()V", "findList", "Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownList;", "file", "Lcom/intellij/psi/PsiFile;", "document", "Lcom/intellij/openapi/editor/Document;", "offset", "", "replaceListWithText", "", "list", "intellij.markdown"})
        public static final class Companion {
            private Companion() {
            }

            private final MarkdownList findList(PsiFile file, Document document, int offset) {
                MarkdownListItem markdownListItem = ListUtils.INSTANCE.getListItemAt(file, offset, document);
                return markdownListItem != null ? ListUtils.INSTANCE.getList(markdownListItem) : null;
            }

            private final void replaceListWithText(Document document, MarkdownList list2) {
                MarkdownListItem markdownListItem = (MarkdownListItem)CollectionsKt.firstOrNull(ListUtils.INSTANCE.getItems(list2));
                if (markdownListItem == null) {
                    return;
                }
                MarkdownListItem firstItem = markdownListItem;
                StringBuilder builder = new StringBuilder();
                for (PsiElement element2 : PsiTreeUtilKt.siblings$default((PsiElement)((PsiElement)firstItem), (boolean)true, (boolean)false, (int)2, null)) {
                    String string;
                    if (element2 instanceof MarkdownListItem) {
                        string = ((MarkdownListItem)element2).getItemText();
                        if (string == null) {
                            string = "";
                        }
                    } else {
                        string = element2.getText();
                    }
                    String text2 = string;
                    builder.append(text2);
                }
                TextRange range = list2.getTextRange();
                document.replaceString(range.getStartOffset(), range.getEndOffset(), (CharSequence)builder.toString());
            }

            public static final /* synthetic */ void access$replaceListWithText(Companion $this, Document document, MarkdownList list2) {
                $this.replaceListWithText(document, list2);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lorg/intellij/plugins/markdown/ui/actions/styling/CreateOrChangeListActionGroup$OrderedList;", "Lorg/intellij/plugins/markdown/ui/actions/styling/CreateOrChangeListActionGroup$CreateListImpl;", "<init>", "()V", "isSameMarker", "", "markerElement", "Lcom/intellij/psi/PsiElement;", "createMarkerText", "", "index", "", "intellij.markdown"})
    public static final class OrderedList
    extends CreateListImpl {
        public OrderedList() {
            Supplier<String> supplier = MarkdownBundle.messagePointer("markdown.create.list.popup.ordered.action.text", new Object[0]);
            Intrinsics.checkNotNullExpressionValue(supplier, (String)"messagePointer(...)");
            Icon icon = MarkdownIcons.EditorActions.NumberedList;
            Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"NumberedList");
            super(supplier, null, icon, 2, null);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean isSameMarker(@NotNull PsiElement markerElement) {
            Intrinsics.checkNotNullParameter((Object)markerElement, (String)"markerElement");
            if (Companion.hasCheckbox(markerElement)) return false;
            String string = Companion.obtainMarkerText(markerElement);
            if (string == null) return false;
            Integer n = StringsKt.toIntOrNull((String)string);
            if (n == null) return false;
            return true;
        }

        @Override
        @NotNull
        public String createMarkerText(int index) {
            return index + 1 + ".";
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lorg/intellij/plugins/markdown/ui/actions/styling/CreateOrChangeListActionGroup$UnorderedList;", "Lorg/intellij/plugins/markdown/ui/actions/styling/CreateOrChangeListActionGroup$CreateListImpl;", "<init>", "()V", "isSameMarker", "", "markerElement", "Lcom/intellij/psi/PsiElement;", "createMarkerText", "", "index", "", "intellij.markdown"})
    public static final class UnorderedList
    extends CreateListImpl {
        public UnorderedList() {
            Supplier<String> supplier = MarkdownBundle.messagePointer("markdown.create.list.popup.unordered.action.text", new Object[0]);
            Intrinsics.checkNotNullExpressionValue(supplier, (String)"messagePointer(...)");
            Icon icon = MarkdownIcons.EditorActions.BulletList;
            Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"BulletList");
            super(supplier, null, icon, 2, null);
        }

        @Override
        public boolean isSameMarker(@NotNull PsiElement markerElement) {
            Intrinsics.checkNotNullParameter((Object)markerElement, (String)"markerElement");
            return !Companion.hasCheckbox(markerElement) && Intrinsics.areEqual((Object)Companion.obtainMarkerText(markerElement), (Object)"*");
        }

        @Override
        @NotNull
        public String createMarkerText(int index) {
            return "*";
        }
    }
}

