/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsActions;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.actions.CachedVcsContext;
import com.intellij.openapi.vcs.actions.VcsContext;
import com.intellij.openapi.vcs.actions.VcsContextUtil;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ui.ChangesListView;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Stream;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsContextWrapper
implements VcsContext {
    @NotNull
    protected final DataContext myContext;
    protected final int myModifiers;
    @NotNull
    private final String myPlace;
    @Nullable
    private final @NlsActions.ActionText String myActionName;

    public VcsContextWrapper(@NotNull DataContext context, int modifiers, @NotNull String place, @Nullable @NlsActions.ActionText String actionName) {
        if (context == null) {
            VcsContextWrapper.$$$reportNull$$$0(0);
        }
        if (place == null) {
            VcsContextWrapper.$$$reportNull$$$0(1);
        }
        this.myContext = context;
        this.myModifiers = modifiers;
        this.myPlace = place;
        this.myActionName = actionName;
    }

    @NotNull
    public String getPlace() {
        String string = this.myPlace;
        if (string == null) {
            VcsContextWrapper.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Nullable
    public String getActionName() {
        return this.myActionName;
    }

    @NotNull
    public static VcsContext createCachedInstanceOn(@NotNull AnActionEvent event) {
        if (event == null) {
            VcsContextWrapper.$$$reportNull$$$0(3);
        }
        return new CachedVcsContext(VcsContextWrapper.createInstanceOn(event));
    }

    @NotNull
    public static VcsContextWrapper createInstanceOn(@NotNull AnActionEvent event) {
        if (event == null) {
            VcsContextWrapper.$$$reportNull$$$0(4);
        }
        return new VcsContextWrapper(event.getDataContext(), event.getModifiers(), event.getPlace(), event.getPresentation().getText());
    }

    @Nullable
    public Project getProject() {
        return (Project)CommonDataKeys.PROJECT.getData(this.myContext);
    }

    @Nullable
    public VirtualFile getSelectedFile() {
        return (VirtualFile)VcsContextUtil.selectedFilesIterable(this.myContext).first();
    }

    public VirtualFile @NotNull [] getSelectedFiles() {
        VirtualFile[] virtualFileArray = (VirtualFile[])VcsContextUtil.selectedFilesIterable(this.myContext).toList().toArray(VirtualFile[]::new);
        if (virtualFileArray == null) {
            VcsContextWrapper.$$$reportNull$$$0(5);
        }
        return virtualFileArray;
    }

    @NotNull
    public Stream<VirtualFile> getSelectedFilesStream() {
        StreamEx streamEx = StreamEx.of((Iterator)VcsContextUtil.selectedFilesIterable(this.myContext).iterator());
        if (streamEx == null) {
            VcsContextWrapper.$$$reportNull$$$0(6);
        }
        return streamEx;
    }

    @NotNull
    public List<FilePath> getSelectedUnversionedFilePaths() {
        Iterable result2 = (Iterable)ChangesListView.UNVERSIONED_FILE_PATHS_DATA_KEY.getData(this.myContext);
        List list = JBIterable.from((Iterable)result2).toList();
        if (list == null) {
            VcsContextWrapper.$$$reportNull$$$0(7);
        }
        return list;
    }

    public Editor getEditor() {
        return (Editor)CommonDataKeys.EDITOR.getData(this.myContext);
    }

    public Collection<VirtualFile> getSelectedFilesCollection() {
        return Arrays.asList(this.getSelectedFiles());
    }

    @Nullable
    public File getSelectedIOFile() {
        FilePath filePath = this.getSelectedFilePath();
        return filePath != null ? filePath.getIOFile() : null;
    }

    public File @Nullable [] getSelectedIOFiles() {
        return ContainerUtil.map((Object[])this.getSelectedFilePaths(), path -> path.getIOFile()).toArray(new File[0]);
    }

    public int getModifiers() {
        return this.myModifiers;
    }

    @Nullable
    public FilePath getSelectedFilePath() {
        return (FilePath)VcsContextUtil.selectedFilePathsIterable(this.myContext).first();
    }

    public FilePath @NotNull [] getSelectedFilePaths() {
        FilePath[] filePathArray = (FilePath[])this.getSelectedFilePathsStream().toArray(FilePath[]::new);
        if (filePathArray == null) {
            VcsContextWrapper.$$$reportNull$$$0(8);
        }
        return filePathArray;
    }

    @NotNull
    public Stream<FilePath> getSelectedFilePathsStream() {
        StreamEx streamEx = StreamEx.of((Iterator)VcsContextUtil.selectedFilePathsIterable(this.myContext).iterator());
        if (streamEx == null) {
            VcsContextWrapper.$$$reportNull$$$0(9);
        }
        return streamEx;
    }

    public ChangeList @Nullable [] getSelectedChangeLists() {
        return (ChangeList[])VcsDataKeys.CHANGE_LISTS.getData(this.myContext);
    }

    public Change @Nullable [] getSelectedChanges() {
        return (Change[])VcsDataKeys.CHANGES.getData(this.myContext);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 5, 6, 7, 8, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/actions/VcsContextWrapper";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/actions/VcsContextWrapper";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getPlace";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedFiles";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedFilesStream";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedUnversionedFilePaths";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedFilePaths";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedFilePathsStream";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createCachedInstanceOn";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createInstanceOn";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 5, 6, 7, 8, 9 -> new IllegalStateException(string);
        };
    }
}

