/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.security.dialogs.remember;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import net.sourceforge.jnlp.runtime.Translator;
import net.sourceforge.jnlp.security.dialogs.SecurityDialogPanel;
import net.sourceforge.jnlp.security.dialogs.remember.RemeberActionProvider;
import net.sourceforge.jnlp.security.dialogs.remember.RememberPanelResult;
import net.sourceforge.jnlp.util.logging.OutputController;

public class RememberPanel
extends JPanel
implements RemeberActionProvider {
    protected JCheckBox permanencyCheckBox;
    protected JRadioButton applyToAppletButton;
    protected JRadioButton applyToCodeBaseButton;
    private final URL codebase;

    public RememberPanel(URL codebase) {
        this(codebase == null ? null : codebase.toExternalForm());
    }

    public RememberPanel(String codebase) {
        super(new GridLayout(2, 1));
        this.codebase = this.initCodebase(codebase);
        this.add((Component)this.createCheckBoxPanel(), "West");
        this.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 10));
        this.add(this.createMatchOptionsPanel());
        this.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 10));
        if (this.codebase == null) {
            this.applyToCodeBaseButton.setVisible(false);
        }
    }

    private JPanel createCheckBoxPanel() {
        JPanel checkBoxPanel = new JPanel(new BorderLayout());
        this.permanencyCheckBox = new JCheckBox(SecurityDialogPanel.htmlWrap(Translator.R("SRememberOption")));
        this.permanencyCheckBox.addActionListener(this.permanencyListener());
        checkBoxPanel.add((Component)this.permanencyCheckBox, "South");
        return checkBoxPanel;
    }

    private JPanel createMatchOptionsPanel() {
        JPanel matchOptionsPanel = new JPanel(new FlowLayout(0));
        ButtonGroup group = new ButtonGroup();
        this.applyToAppletButton = new JRadioButton(Translator.R("SRememberAppletOnly"));
        this.applyToAppletButton.setSelected(true);
        this.applyToAppletButton.setEnabled(false);
        this.applyToCodeBaseButton = new JRadioButton(SecurityDialogPanel.htmlWrap(Translator.R("SRememberCodebase", this.codebase)));
        this.applyToCodeBaseButton.setEnabled(false);
        group.add(this.applyToAppletButton);
        group.add(this.applyToCodeBaseButton);
        matchOptionsPanel.add(this.applyToAppletButton);
        matchOptionsPanel.add(this.applyToCodeBaseButton);
        return matchOptionsPanel;
    }

    protected ActionListener permanencyListener() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RememberPanel.this.applyToAppletButton.setEnabled(RememberPanel.this.permanencyCheckBox.isSelected());
                RememberPanel.this.applyToCodeBaseButton.setEnabled(RememberPanel.this.permanencyCheckBox.isSelected());
            }
        };
    }

    public boolean isAlwaysSelected() {
        return this.permanencyCheckBox.isSelected();
    }

    public boolean isCodebaseSelected() {
        return this.applyToCodeBaseButton.isSelected();
    }

    private URL initCodebase(String codebase) {
        if (codebase != null) {
            try {
                return new URL(codebase);
            }
            catch (MalformedURLException ex) {
                OutputController.getLogger().log(ex);
            }
        }
        return null;
    }

    @Override
    public RememberPanelResult getRememberAction() {
        return new RememberPanelResult(this.permanencyCheckBox.isSelected(), this.applyToCodeBaseButton.isSelected());
    }
}

