/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.snapshot;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import org.gradle.internal.snapshot.AbstractInvalidateChildHandler;
import org.gradle.internal.snapshot.AbstractStorePathRelationshipHandler;
import org.gradle.internal.snapshot.CaseSensitivity;
import org.gradle.internal.snapshot.ChildMap;
import org.gradle.internal.snapshot.ChildMapFactory;
import org.gradle.internal.snapshot.SearchUtil;
import org.gradle.internal.snapshot.VfsRelativePath;

public abstract class AbstractListChildMap<T>
implements ChildMap<T> {
    protected final List<ChildMap.Entry<T>> entries;

    protected AbstractListChildMap(List<ChildMap.Entry<T>> entries) {
        this.entries = entries;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public int size() {
        return this.entries.size();
    }

    @Override
    public Stream<ChildMap.Entry<T>> stream() {
        return this.entries.stream();
    }

    protected int findChildIndexWithCommonPrefix(VfsRelativePath targetPath, CaseSensitivity caseSensitivity) {
        return SearchUtil.binarySearch(this.entries, candidate -> targetPath.compareToFirstSegment(candidate.getPath(), caseSensitivity));
    }

    @Override
    public <RESULT> ChildMap<RESULT> invalidate(VfsRelativePath targetPath, CaseSensitivity caseSensitivity, ChildMap.InvalidationHandler<T, RESULT> handler) {
        final int childIndex = this.findChildIndexWithCommonPrefix(targetPath, caseSensitivity);
        if (childIndex >= 0) {
            ChildMap.Entry<T> entry = this.entries.get(childIndex);
            final String childPath = entry.getPath();
            return (ChildMap)entry.withNode(targetPath, caseSensitivity, new AbstractInvalidateChildHandler<T, RESULT>(handler){

                @Override
                public AbstractListChildMap<RESULT> getChildMap() {
                    return AbstractListChildMap.this;
                }

                @Override
                public ChildMap<RESULT> withReplacedChild(RESULT newChild) {
                    return this.withReplacedChild(childPath, newChild);
                }

                @Override
                public ChildMap<RESULT> withReplacedChild(String newChildPath, RESULT newChild) {
                    return ((AbstractListChildMap)this.getChildMap()).withReplacedChild(childIndex, newChildPath, newChild);
                }

                @Override
                public ChildMap<RESULT> withRemovedChild() {
                    return ((AbstractListChildMap)this.getChildMap()).withRemovedChild(childIndex);
                }
            });
        }
        handler.handleUnrelatedToAnyChild();
        AbstractListChildMap castedThis = this;
        return castedThis;
    }

    @Override
    public ChildMap<T> store(VfsRelativePath targetPath, CaseSensitivity caseSensitivity, ChildMap.StoreHandler<T> storeHandler) {
        final int childIndex = this.findChildIndexWithCommonPrefix(targetPath, caseSensitivity);
        if (childIndex >= 0) {
            return (ChildMap)this.entries.get(childIndex).handlePath(targetPath, caseSensitivity, new AbstractStorePathRelationshipHandler<T>(caseSensitivity, storeHandler){

                @Override
                public ChildMap<T> withReplacedChild(T newChild) {
                    return this.withReplacedChild(AbstractListChildMap.this.entries.get(childIndex).getPath(), newChild);
                }

                @Override
                public ChildMap<T> withReplacedChild(String newChildPath, T newChild) {
                    return AbstractListChildMap.this.withReplacedChild(childIndex, newChildPath, newChild);
                }

                @Override
                public ChildMap<T> withNewChild(String newChildPath, T newChild) {
                    return AbstractListChildMap.this.withNewChild(childIndex, newChildPath, newChild);
                }
            });
        }
        T newChild = storeHandler.createChild();
        return this.withNewChild(-childIndex - 1, targetPath.toString(), newChild);
    }

    protected ChildMap<T> withNewChild(int insertBefore, String path, T newChild) {
        ArrayList<ChildMap.Entry<T>> newChildren = new ArrayList<ChildMap.Entry<T>>(this.entries);
        newChildren.add(insertBefore, new ChildMap.Entry<T>(path, newChild));
        return ChildMapFactory.childMapFromSorted(newChildren);
    }

    protected ChildMap<T> withReplacedChild(int childIndex, String newPath, T newChild) {
        ChildMap.Entry<T> oldEntry = this.entries.get(childIndex);
        if (oldEntry.getPath().equals(newPath) && oldEntry.getValue().equals(newChild)) {
            return this;
        }
        ArrayList<ChildMap.Entry<T>> newChildren = new ArrayList<ChildMap.Entry<T>>(this.entries);
        newChildren.set(childIndex, new ChildMap.Entry<T>(newPath, newChild));
        return ChildMapFactory.childMapFromSorted(newChildren);
    }

    protected ChildMap<T> withRemovedChild(int childIndex) {
        ArrayList<ChildMap.Entry<T>> newChildren = new ArrayList<ChildMap.Entry<T>>(this.entries);
        newChildren.remove(childIndex);
        return ChildMapFactory.childMapFromSorted(newChildren);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractListChildMap that = (AbstractListChildMap)o;
        return this.entries.equals(that.entries);
    }

    public int hashCode() {
        return this.entries.hashCode();
    }

    public String toString() {
        return this.entries.toString();
    }
}

