/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.save;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.TableModel;
import tim.prune.App;
import tim.prune.I18nManager;
import tim.prune.UpdateMessageBroker;
import tim.prune.config.Config;
import tim.prune.data.DataPoint;
import tim.prune.data.Field;
import tim.prune.data.FieldList;
import tim.prune.data.Timestamp;
import tim.prune.data.Track;
import tim.prune.data.Unit;
import tim.prune.data.UnitSetLibrary;
import tim.prune.load.GenericFileFilter;
import tim.prune.load.OneCharDocument;
import tim.prune.save.FieldInfo;
import tim.prune.save.FieldSelectionTableModel;
import tim.prune.save.PointTypeSelector;
import tim.prune.save.UpDownToggler;

public class FileSaver {
    private App _app = null;
    private JFrame _parentFrame = null;
    private JDialog _dialog = null;
    private JFileChooser _fileChooser = null;
    private JPanel _cards = null;
    private JButton _nextButton = null;
    private JButton _backButton = null;
    private JTable _table = null;
    private FieldSelectionTableModel _model = null;
    private JButton _moveUpButton = null;
    private JButton _moveDownButton = null;
    private UpDownToggler _toggler = null;
    private JRadioButton[] _delimiterRadios = null;
    private JTextField _otherDelimiterText = null;
    private JCheckBox _headerRowCheckbox = null;
    private PointTypeSelector _pointTypeSelector = null;
    private JRadioButton[] _coordUnitsRadios = null;
    private JRadioButton[] _altitudeUnitsRadios = null;
    private JRadioButton[] _timestampUnitsRadios = null;
    private static final int[] FORMAT_COORDS = new int[]{19, 10, 11, 12};
    private static final Unit[] UNIT_ALTS;
    private static final Timestamp.Format[] FORMAT_TIMES;

    static {
        Unit[] unitArray = new Unit[3];
        unitArray[1] = UnitSetLibrary.UNITS_METRES;
        unitArray[2] = UnitSetLibrary.UNITS_FEET;
        UNIT_ALTS = unitArray;
        FORMAT_TIMES = new Timestamp.Format[]{Timestamp.Format.ORIGINAL, Timestamp.Format.LOCALE, Timestamp.Format.ISO8601};
    }

    public FileSaver(App app, JFrame jFrame) {
        this._app = app;
        this._parentFrame = jFrame;
    }

    public void showDialog(char c) {
        if (this._dialog == null) {
            this._dialog = new JDialog(this._parentFrame, I18nManager.getText("dialog.saveoptions.title"), true);
            this._dialog.setLocationRelativeTo(this._parentFrame);
            this._dialog.getContentPane().add(this.makeDialogComponents());
            this._dialog.pack();
        }
        Track track = this._app.getTrackInfo().getTrack();
        FieldList fieldList = track.getFieldList();
        int n = fieldList.getNumFields();
        ArrayList<FieldInfo> arrayList = new ArrayList<FieldInfo>();
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldList.getField(n2);
            arrayList.add(new FieldInfo(field, track.hasData(field)));
            ++n2;
        }
        if (this._app.getTrackInfo().getPhotoList().hasCorrelatedMedia()) {
            arrayList.add(new FieldInfo(Field.PHOTO, true));
        }
        if (this._app.getTrackInfo().getAudioList().hasCorrelatedMedia()) {
            arrayList.add(new FieldInfo(Field.AUDIO, true));
        }
        this._model = new FieldSelectionTableModel(arrayList);
        this.initDialog(this._model, c);
        this._dialog.setVisible(true);
    }

    private Component makeDialogComponents() {
        JComponent jComponent;
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        this._cards = new JPanel();
        this._cards.setLayout(new CardLayout());
        jPanel.add((Component)this._cards, "Center");
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout());
        this._table = new JTable();
        this._table.setSelectionMode(0);
        JScrollPane jScrollPane = new JScrollPane(this._table);
        this._table.setPreferredScrollableViewportSize(new Dimension(300, 150));
        jPanel3.add((Component)jScrollPane, "Center");
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BorderLayout());
        jPanel4.add((Component)jPanel3, "Center");
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new BoxLayout(jPanel5, 1));
        this._moveUpButton = new JButton(I18nManager.getText("button.moveup"));
        this._moveUpButton.addActionListener(actionEvent -> this.onMoveUp());
        this._moveUpButton.setEnabled(false);
        jPanel5.add(this._moveUpButton);
        this._moveDownButton = new JButton(I18nManager.getText("button.movedown"));
        this._moveDownButton.addActionListener(actionEvent -> this.onMoveDown());
        this._moveDownButton.setEnabled(false);
        jPanel5.add(this._moveDownButton);
        jPanel4.add((Component)jPanel5, "East");
        this._toggler = new UpDownToggler(this._moveUpButton, this._moveDownButton);
        this._table.getSelectionModel().addListSelectionListener(this._toggler);
        JLabel jLabel = new JLabel(I18nManager.getText("dialog.save.fieldstosave"));
        jLabel.setAlignmentX(0.0f);
        jPanel2.add(jLabel);
        jPanel4.setAlignmentX(0.0f);
        jPanel2.add(jPanel4);
        jPanel2.add(Box.createRigidArea(new Dimension(0, 10)));
        JLabel jLabel2 = new JLabel(I18nManager.getText("dialog.delimiter.label"));
        jLabel2.setAlignmentX(0.0f);
        jPanel2.add(jLabel2);
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout(new GridLayout(0, 2));
        jPanel6.setAlignmentX(0.0f);
        this._delimiterRadios = new JRadioButton[5];
        this._delimiterRadios[0] = new JRadioButton(I18nManager.getText("dialog.delimiter.comma"));
        jPanel6.add(this._delimiterRadios[0]);
        this._delimiterRadios[1] = new JRadioButton(I18nManager.getText("dialog.delimiter.tab"));
        jPanel6.add(this._delimiterRadios[1]);
        this._delimiterRadios[2] = new JRadioButton(I18nManager.getText("dialog.delimiter.semicolon"));
        jPanel6.add(this._delimiterRadios[2]);
        this._delimiterRadios[3] = new JRadioButton(I18nManager.getText("dialog.delimiter.space"));
        jPanel6.add(this._delimiterRadios[3]);
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout(new FlowLayout(0, 0, 0));
        this._delimiterRadios[4] = new JRadioButton(I18nManager.getText("dialog.delimiter.other"));
        jPanel7.add(this._delimiterRadios[4]);
        this._otherDelimiterText = new JTextField(new OneCharDocument(), null, 2);
        jPanel7.add(this._otherDelimiterText);
        ButtonGroup buttonGroup = new ButtonGroup();
        Object object = this._delimiterRadios;
        int n = this._delimiterRadios.length;
        int n2 = 0;
        while (n2 < n) {
            jComponent = object[n2];
            buttonGroup.add((AbstractButton)jComponent);
            ++n2;
        }
        jPanel6.add(jPanel7);
        jPanel2.add(jPanel6);
        jPanel2.add(Box.createRigidArea(new Dimension(0, 10)));
        this._headerRowCheckbox = new JCheckBox(I18nManager.getText("dialog.save.headerrow"), true);
        jPanel2.add(this._headerRowCheckbox);
        this._cards.add((Component)jPanel2, "card1");
        jComponent = new JPanel();
        jComponent.setLayout(new BorderLayout());
        JPanel jPanel8 = new JPanel();
        jPanel8.setLayout(new BoxLayout(jPanel8, 1));
        jPanel8.add(Box.createRigidArea(new Dimension(0, 10)));
        this._pointTypeSelector = new PointTypeSelector();
        this._pointTypeSelector.setAlignmentX(0.0f);
        jPanel8.add(this._pointTypeSelector);
        JLabel jLabel3 = new JLabel(I18nManager.getText("dialog.save.coordinateunits"));
        jLabel3.setAlignmentX(0.0f);
        jPanel8.add(jLabel3);
        object = new JPanel();
        ((JComponent)object).setBorder(BorderFactory.createEtchedBorder());
        ((Container)object).setLayout(new GridLayout(0, 2));
        this._coordUnitsRadios = new JRadioButton[4];
        this._coordUnitsRadios[0] = new JRadioButton(I18nManager.getText("units.original"));
        this._coordUnitsRadios[1] = new JRadioButton(I18nManager.getText("units.degminsec"));
        this._coordUnitsRadios[2] = new JRadioButton(I18nManager.getText("units.degmin"));
        this._coordUnitsRadios[3] = new JRadioButton(I18nManager.getText("units.deg"));
        ButtonGroup buttonGroup2 = new ButtonGroup();
        int n3 = 0;
        while (n3 < 4) {
            buttonGroup2.add(this._coordUnitsRadios[n3]);
            ((Container)object).add(this._coordUnitsRadios[n3]);
            this._coordUnitsRadios[n3].setSelected(n3 == 0);
            ++n3;
        }
        ((JComponent)object).setAlignmentX(0.0f);
        jPanel8.add((Component)object);
        jPanel8.add(Box.createRigidArea(new Dimension(0, 7)));
        JLabel jLabel4 = new JLabel(I18nManager.getText("dialog.save.altitudeunits"));
        jLabel4.setAlignmentX(0.0f);
        jPanel8.add(jLabel4);
        JPanel jPanel9 = new JPanel();
        jPanel9.setBorder(BorderFactory.createEtchedBorder());
        jPanel9.setLayout(new GridLayout(0, 2));
        this._altitudeUnitsRadios = new JRadioButton[3];
        this._altitudeUnitsRadios[0] = new JRadioButton(I18nManager.getText("units.original"));
        this._altitudeUnitsRadios[1] = new JRadioButton(I18nManager.getText("units.metres"));
        this._altitudeUnitsRadios[2] = new JRadioButton(I18nManager.getText("units.feet"));
        ButtonGroup buttonGroup3 = new ButtonGroup();
        int n4 = 0;
        while (n4 < 3) {
            buttonGroup3.add(this._altitudeUnitsRadios[n4]);
            jPanel9.add(this._altitudeUnitsRadios[n4]);
            this._altitudeUnitsRadios[n4].setSelected(n4 == 0);
            ++n4;
        }
        jPanel9.setAlignmentX(0.0f);
        jPanel8.add(jPanel9);
        jPanel8.add(Box.createRigidArea(new Dimension(0, 7)));
        JLabel jLabel5 = new JLabel(I18nManager.getText("dialog.save.timestampformat"));
        jLabel5.setAlignmentX(0.0f);
        jPanel8.add(jLabel5);
        JPanel jPanel10 = new JPanel();
        jPanel10.setBorder(BorderFactory.createEtchedBorder());
        jPanel10.setLayout(new GridLayout(0, 2));
        this._timestampUnitsRadios = new JRadioButton[3];
        this._timestampUnitsRadios[0] = new JRadioButton(I18nManager.getText("units.original"));
        this._timestampUnitsRadios[1] = new JRadioButton(I18nManager.getText("units.default"));
        this._timestampUnitsRadios[2] = new JRadioButton(I18nManager.getText("units.iso8601"));
        ButtonGroup buttonGroup4 = new ButtonGroup();
        int n5 = 0;
        while (n5 < 3) {
            buttonGroup4.add(this._timestampUnitsRadios[n5]);
            jPanel10.add(this._timestampUnitsRadios[n5]);
            this._timestampUnitsRadios[n5].setSelected(n5 == 0);
            ++n5;
        }
        jPanel10.setAlignmentX(0.0f);
        jPanel8.add(jPanel10);
        jComponent.add((Component)jPanel8, "North");
        this._cards.add((Component)jComponent, "card2");
        JPanel jPanel11 = new JPanel();
        jPanel11.setLayout(new FlowLayout(2));
        this._backButton = new JButton(I18nManager.getText("button.back"));
        this._backButton.addActionListener(actionEvent -> this.onBackPressed());
        this._backButton.setEnabled(false);
        jPanel11.add(this._backButton);
        this._nextButton = new JButton(I18nManager.getText("button.next"));
        this._nextButton.setEnabled(true);
        this._nextButton.addActionListener(actionEvent -> this.onNextPressed());
        jPanel11.add(this._nextButton);
        JButton jButton = new JButton(I18nManager.getText("button.finish"));
        jButton.addActionListener(actionEvent -> this.saveToFile());
        jPanel11.add(jButton);
        JButton jButton2 = new JButton(I18nManager.getText("button.cancel"));
        jButton2.addActionListener(actionEvent -> this._dialog.dispose());
        jPanel11.add(jButton2);
        jPanel.add((Component)jPanel11, "South");
        return jPanel;
    }

    private void onMoveUp() {
        int n = this._table.getSelectedRow();
        if (n > 0) {
            this._model.swapItems(n, n - 1);
            this._table.setRowSelectionInterval(n - 1, n - 1);
        }
    }

    private void onMoveDown() {
        int n = this._table.getSelectedRow();
        if (n > -1 && n < this._model.getRowCount() - 1) {
            this._model.swapItems(n, n + 1);
            this._table.setRowSelectionInterval(n + 1, n + 1);
        }
    }

    private void onBackPressed() {
        CardLayout cardLayout = (CardLayout)this._cards.getLayout();
        cardLayout.previous(this._cards);
        this._backButton.setEnabled(false);
        this._nextButton.setEnabled(true);
    }

    private void onNextPressed() {
        CardLayout cardLayout = (CardLayout)this._cards.getLayout();
        cardLayout.next(this._cards);
        this._backButton.setEnabled(true);
        this._nextButton.setEnabled(false);
    }

    private void initDialog(TableModel tableModel, char c) {
        this._table.setModel(tableModel);
        this._toggler.setListSize(tableModel.getRowCount());
        switch (c) {
            case ',': {
                this._delimiterRadios[0].setSelected(true);
                break;
            }
            case '\t': {
                this._delimiterRadios[1].setSelected(true);
                break;
            }
            case ';': {
                this._delimiterRadios[2].setSelected(true);
                break;
            }
            case ' ': {
                this._delimiterRadios[3].setSelected(true);
                break;
            }
            default: {
                this._delimiterRadios[4].setSelected(true);
                this._otherDelimiterText.setText("" + c);
            }
        }
        this._pointTypeSelector.init(this._app.getTrackInfo());
        CardLayout cardLayout = (CardLayout)this._cards.getLayout();
        cardLayout.first(this._cards);
        this._nextButton.setEnabled(true);
        this._backButton.setEnabled(false);
    }

    private void saveToFile() {
        if (!this._pointTypeSelector.getAnythingSelected()) {
            JOptionPane.showMessageDialog(this._parentFrame, I18nManager.getText("dialog.save.notypesselected"), I18nManager.getText("dialog.saveoptions.title"), 2);
            return;
        }
        if (this._fileChooser == null) {
            this._fileChooser = new JFileChooser();
            this._fileChooser.setDialogType(1);
            this._fileChooser.addChoosableFileFilter(new GenericFileFilter("filetype.txt", new String[]{"txt", "text"}));
            this._fileChooser.setAcceptAllFileFilterUsed(true);
            String string = Config.getConfigString("prune.trackdirectory");
            if (string == null) {
                string = Config.getConfigString("prune.photodirectory");
            }
            if (string != null) {
                this._fileChooser.setCurrentDirectory(new File(string));
            }
        }
        boolean bl = true;
        if (this._fileChooser.showSaveDialog(this._parentFrame) == 0) {
            bl = this.saveToFile(this._fileChooser.getSelectedFile());
        }
        if (bl) {
            this._dialog.dispose();
        }
    }

    private boolean saveToFile(File file) {
        String string = System.getProperty("line.separator");
        boolean bl = true;
        int n = 19;
        int n2 = 0;
        while (n2 < this._coordUnitsRadios.length) {
            if (this._coordUnitsRadios[n2].isSelected()) {
                n = FORMAT_COORDS[n2];
            }
            ++n2;
        }
        Unit unit = null;
        int n3 = 0;
        while (n3 < this._altitudeUnitsRadios.length) {
            if (this._altitudeUnitsRadios[n3].isSelected()) {
                unit = UNIT_ALTS[n3];
            }
            ++n3;
        }
        Timestamp.Format format = Timestamp.Format.ORIGINAL;
        int n4 = 0;
        while (n4 < this._timestampUnitsRadios.length) {
            if (this._timestampUnitsRadios[n4].isSelected()) {
                format = FORMAT_TIMES[n4];
            }
            ++n4;
        }
        File file2 = FileSaver.isFilenameOk(file) ? file : new File(String.valueOf(file.getAbsolutePath()) + ".txt");
        Object[] objectArray = new Object[]{I18nManager.getText("button.overwrite"), I18nManager.getText("button.cancel")};
        if (!file2.exists() || JOptionPane.showOptionDialog(this._parentFrame, I18nManager.getText("dialog.save.overwrite.text"), I18nManager.getText("dialog.save.overwrite.title"), 0, 2, null, objectArray, objectArray[1]) == 0) {
            try {
                Throwable throwable = null;
                Object var10_15 = null;
                try (FileWriter fileWriter = new FileWriter(file2);){
                    int n5;
                    char c = this.getDelimiter();
                    FieldInfo fieldInfo = null;
                    int n6 = this._model.getRowCount();
                    boolean bl2 = true;
                    if (this._headerRowCheckbox.isSelected()) {
                        StringBuffer stringBuffer = new StringBuffer();
                        n5 = 0;
                        while (n5 < n6) {
                            fieldInfo = this._model.getFieldInfo(n5);
                            if (fieldInfo.isSelected()) {
                                if (!bl2) {
                                    stringBuffer.append(c);
                                }
                                stringBuffer.append(fieldInfo.getField().getName());
                                bl2 = false;
                            }
                            ++n5;
                        }
                        fileWriter.write(stringBuffer.toString());
                        fileWriter.write(string);
                    }
                    int n7 = -1;
                    n5 = -1;
                    if (this._pointTypeSelector.getJustSelection()) {
                        n7 = this._app.getTrackInfo().getSelection().getStart();
                        n5 = this._app.getTrackInfo().getSelection().getEnd();
                    }
                    Track track = this._app.getTrackInfo().getTrack();
                    int n8 = track.getNumPoints();
                    int n9 = 0;
                    int n10 = 0;
                    while (n10 < n8) {
                        boolean bl3;
                        DataPoint dataPoint = track.getPoint(n10);
                        boolean bl4 = bl3 = (dataPoint.isWaypoint() && this._pointTypeSelector.getWaypointsSelected() || !dataPoint.isWaypoint() && !dataPoint.hasMedia() && this._pointTypeSelector.getTrackpointsSelected() || !dataPoint.isWaypoint() && dataPoint.getPhoto() != null && this._pointTypeSelector.getPhotopointsSelected() || !dataPoint.isWaypoint() && dataPoint.getAudio() != null && this._pointTypeSelector.getAudiopointsSelected()) && (!this._pointTypeSelector.getJustSelection() || n10 >= n7 && n10 <= n5);
                        if (bl3) {
                            ++n9;
                            bl2 = true;
                            StringBuffer stringBuffer = new StringBuffer();
                            int n11 = 0;
                            while (n11 < n6) {
                                fieldInfo = this._model.getFieldInfo(n11);
                                if (fieldInfo.isSelected()) {
                                    if (!bl2) {
                                        stringBuffer.append(c);
                                    }
                                    this.saveField(stringBuffer, dataPoint, fieldInfo.getField(), n, unit, format);
                                    bl2 = false;
                                }
                                ++n11;
                            }
                            fileWriter.write(stringBuffer.toString());
                            fileWriter.write(string);
                        }
                        ++n10;
                    }
                    Config.setConfigString("prune.trackdirectory", file2.getParentFile().getAbsolutePath());
                    this._app.addRecentFile(file, true);
                    UpdateMessageBroker.informSubscribers();
                    UpdateMessageBroker.informSubscribers(String.valueOf(I18nManager.getText("confirm.save.ok1")) + " " + n9 + " " + I18nManager.getText("confirm.save.ok2") + " " + file2.getAbsolutePath());
                    this._app.informDataSaved();
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException iOException) {
                bl = false;
                this._app.showErrorMessageNoLookup("error.save.dialogtitle", String.valueOf(I18nManager.getText("error.save.failed")) + " : " + iOException.getMessage());
            }
        } else {
            bl = false;
        }
        return bl;
    }

    private void saveField(StringBuffer stringBuffer, DataPoint dataPoint, Field field, int n, Unit unit, Timestamp.Format format) {
        if (field == Field.LATITUDE) {
            stringBuffer.append(dataPoint.getLatitude().output(n));
        } else if (field == Field.LONGITUDE) {
            stringBuffer.append(dataPoint.getLongitude().output(n));
        } else if (field == Field.ALTITUDE) {
            if (dataPoint.hasAltitude()) {
                stringBuffer.append(dataPoint.getAltitude().getStringValue(unit));
            }
        } else if (field == Field.TIMESTAMP) {
            if (dataPoint.hasTimestamp()) {
                stringBuffer.append(dataPoint.getTimestamp().getText(format, null));
            }
        } else if (field == Field.PHOTO) {
            if (dataPoint.getPhoto() != null) {
                stringBuffer.append(dataPoint.getPhoto().getName());
            }
        } else if (field == Field.AUDIO) {
            if (dataPoint.getAudio() != null) {
                stringBuffer.append(dataPoint.getAudio().getName());
            }
        } else {
            String string = dataPoint.getFieldValue(field);
            if (string != null) {
                stringBuffer.append(string);
            }
        }
    }

    private char getDelimiter() {
        char[] cArray = new char[]{',', '\t', ';', ' '};
        int n = 0;
        while (n < 4) {
            if (this._delimiterRadios[n].isSelected()) {
                return cArray[n];
            }
            ++n;
        }
        return this._otherDelimiterText.getText().charAt(0);
    }

    private static boolean isFilenameOk(File file) {
        String string = file.getName().toLowerCase();
        return string.length() < 4 || !string.endsWith(".gpx") && !string.endsWith(".kml") && !string.endsWith(".kmz") && !string.endsWith(".zip");
    }
}

