/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import tim.prune.I18nManager;
import tim.prune.function.Cancellable;
import tim.prune.gui.ProgressIndicator;

public class ProgressDialog
implements ProgressIndicator {
    private JDialog _dialog = null;
    private final String _titleKey;
    private final String _labelKey;
    private JProgressBar _progressBar = null;
    private final JFrame _parentFrame;
    private final Cancellable _function;
    private boolean _cancelled = false;
    private int _maxValue = -1;

    public ProgressDialog(JFrame jFrame, String string, String string2, Cancellable cancellable) {
        this._titleKey = string;
        this._labelKey = string2 == null ? "confirm.running" : string2;
        this._parentFrame = jFrame;
        this._function = cancellable;
    }

    public ProgressDialog(JFrame jFrame, String string) {
        this(jFrame, string, null, null);
    }

    private JDialog createProgressDialog() {
        JDialog jDialog = new JDialog((Frame)this._parentFrame, I18nManager.getText(this._titleKey));
        jDialog.setLocationRelativeTo(this._parentFrame);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)new JLabel(I18nManager.getText(this._labelKey)), "North");
        JPanel jPanel2 = new JPanel();
        jPanel2.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
        jPanel2.setLayout(new BorderLayout());
        this._progressBar = new JProgressBar();
        this._progressBar.setPreferredSize(new Dimension(300, 30));
        this._progressBar.setValue(0);
        this._progressBar.setStringPainted(true);
        this._progressBar.setString("");
        jPanel2.add((Component)this._progressBar, "Center");
        jPanel.add((Component)jPanel2, "Center");
        if (this._function != null) {
            JPanel jPanel3 = new JPanel();
            jPanel3.setLayout(new FlowLayout(2));
            JButton jButton = new JButton(I18nManager.getText("button.cancel"));
            jButton.addActionListener(actionEvent -> {
                this._cancelled = true;
                this._function.cancel();
            });
            jPanel3.add(jButton);
            jPanel.add((Component)jPanel3, "South");
        }
        jDialog.getContentPane().add(jPanel);
        jDialog.pack();
        return jDialog;
    }

    public void show() {
        this._cancelled = false;
        if (this._dialog == null) {
            this._dialog = this.createProgressDialog();
        }
        this._dialog.setVisible(true);
        this.setMaximumValue(-1);
    }

    public void setMaximumValue(int n) {
        this._maxValue = n;
        this._progressBar.setMaximum(n);
        this._progressBar.setMinimum(0);
        this._progressBar.setIndeterminate(n <= 1);
        this.setValue(0);
    }

    public void setValue(int n) {
        if (this._maxValue > 0) {
            this._progressBar.setString(n + " / " + this._maxValue);
            this._progressBar.setValue(n);
        } else {
            this._progressBar.setString("" + n);
        }
    }

    public void close() {
        if (this._dialog != null) {
            this._dialog.dispose();
        }
    }

    public boolean wasCancelled() {
        return this._cancelled;
    }

    @Override
    public void showProgress(int n, int n2) {
        if (n2 != this._maxValue) {
            this.setMaximumValue(n2);
        }
        this.setValue(n);
    }
}

