/*--------------------------------------------------------------------
 * Symbols referenced in this file:
 * - ScanKeywords
 * - ScanKeywords_kw_string
 * - ScanKeywords_kw_offsets
 * - ScanKeywords_hash_func
 *--------------------------------------------------------------------
 */

/*-------------------------------------------------------------------------
 *
 * kwlist_d.h
 *    List of keywords represented as a ScanKeywordList.
 *
 * Portions Copyright (c) 1996-2024, PostgreSQL Global Development Group
 * Portions Copyright (c) 1994, Regents of the University of California
 *
 * NOTES
 *  ******************************
 *  *** DO NOT EDIT THIS FILE! ***
 *  ******************************
 *
 *  It has been GENERATED by src/tools/gen_keywordlist.pl
 *
 *-------------------------------------------------------------------------
 */

#ifndef KWLIST_D_H
#define KWLIST_D_H

#include "common/kwlookup.h"

static const char ScanKeywords_kw_string[] =
	"abort\0"
	"absent\0"
	"absolute\0"
	"access\0"
	"action\0"
	"add\0"
	"admin\0"
	"after\0"
	"aggregate\0"
	"all\0"
	"also\0"
	"alter\0"
	"always\0"
	"analyse\0"
	"analyze\0"
	"and\0"
	"any\0"
	"array\0"
	"as\0"
	"asc\0"
	"asensitive\0"
	"assertion\0"
	"assignment\0"
	"asymmetric\0"
	"at\0"
	"atomic\0"
	"attach\0"
	"attribute\0"
	"authorization\0"
	"backward\0"
	"before\0"
	"begin\0"
	"between\0"
	"bigint\0"
	"binary\0"
	"bit\0"
	"boolean\0"
	"both\0"
	"breadth\0"
	"by\0"
	"cache\0"
	"call\0"
	"called\0"
	"cascade\0"
	"cascaded\0"
	"case\0"
	"cast\0"
	"catalog\0"
	"chain\0"
	"char\0"
	"character\0"
	"characteristics\0"
	"check\0"
	"checkpoint\0"
	"class\0"
	"close\0"
	"cluster\0"
	"coalesce\0"
	"collate\0"
	"collation\0"
	"column\0"
	"columns\0"
	"comment\0"
	"comments\0"
	"commit\0"
	"committed\0"
	"compression\0"
	"concurrently\0"
	"conditional\0"
	"configuration\0"
	"conflict\0"
	"connection\0"
	"constraint\0"
	"constraints\0"
	"content\0"
	"continue\0"
	"conversion\0"
	"copy\0"
	"cost\0"
	"create\0"
	"cross\0"
	"csv\0"
	"cube\0"
	"current\0"
	"current_catalog\0"
	"current_date\0"
	"current_role\0"
	"current_schema\0"
	"current_time\0"
	"current_timestamp\0"
	"current_user\0"
	"cursor\0"
	"cycle\0"
	"data\0"
	"database\0"
	"day\0"
	"deallocate\0"
	"dec\0"
	"decimal\0"
	"declare\0"
	"default\0"
	"defaults\0"
	"deferrable\0"
	"deferred\0"
	"definer\0"
	"delete\0"
	"delimiter\0"
	"delimiters\0"
	"depends\0"
	"depth\0"
	"desc\0"
	"detach\0"
	"dictionary\0"
	"disable\0"
	"discard\0"
	"distinct\0"
	"do\0"
	"document\0"
	"domain\0"
	"double\0"
	"drop\0"
	"each\0"
	"else\0"
	"empty\0"
	"enable\0"
	"encoding\0"
	"encrypted\0"
	"end\0"
	"enum\0"
	"error\0"
	"escape\0"
	"event\0"
	"except\0"
	"exclude\0"
	"excluding\0"
	"exclusive\0"
	"execute\0"
	"exists\0"
	"explain\0"
	"expression\0"
	"extension\0"
	"external\0"
	"extract\0"
	"false\0"
	"family\0"
	"fetch\0"
	"filter\0"
	"finalize\0"
	"first\0"
	"float\0"
	"following\0"
	"for\0"
	"force\0"
	"foreign\0"
	"format\0"
	"forward\0"
	"freeze\0"
	"from\0"
	"full\0"
	"function\0"
	"functions\0"
	"generated\0"
	"global\0"
	"grant\0"
	"granted\0"
	"greatest\0"
	"group\0"
	"grouping\0"
	"groups\0"
	"handler\0"
	"having\0"
	"header\0"
	"hold\0"
	"hour\0"
	"identity\0"
	"if\0"
	"ilike\0"
	"immediate\0"
	"immutable\0"
	"implicit\0"
	"import\0"
	"in\0"
	"include\0"
	"including\0"
	"increment\0"
	"indent\0"
	"index\0"
	"indexes\0"
	"inherit\0"
	"inherits\0"
	"initially\0"
	"inline\0"
	"inner\0"
	"inout\0"
	"input\0"
	"insensitive\0"
	"insert\0"
	"instead\0"
	"int\0"
	"integer\0"
	"intersect\0"
	"interval\0"
	"into\0"
	"invoker\0"
	"is\0"
	"isnull\0"
	"isolation\0"
	"join\0"
	"json\0"
	"json_array\0"
	"json_arrayagg\0"
	"json_exists\0"
	"json_object\0"
	"json_objectagg\0"
	"json_query\0"
	"json_scalar\0"
	"json_serialize\0"
	"json_table\0"
	"json_value\0"
	"keep\0"
	"key\0"
	"keys\0"
	"label\0"
	"language\0"
	"large\0"
	"last\0"
	"lateral\0"
	"leading\0"
	"leakproof\0"
	"least\0"
	"left\0"
	"level\0"
	"like\0"
	"limit\0"
	"listen\0"
	"load\0"
	"local\0"
	"localtime\0"
	"localtimestamp\0"
	"location\0"
	"lock\0"
	"locked\0"
	"logged\0"
	"mapping\0"
	"match\0"
	"matched\0"
	"materialized\0"
	"maxvalue\0"
	"merge\0"
	"merge_action\0"
	"method\0"
	"minute\0"
	"minvalue\0"
	"mode\0"
	"month\0"
	"move\0"
	"name\0"
	"names\0"
	"national\0"
	"natural\0"
	"nchar\0"
	"nested\0"
	"new\0"
	"next\0"
	"nfc\0"
	"nfd\0"
	"nfkc\0"
	"nfkd\0"
	"no\0"
	"none\0"
	"normalize\0"
	"normalized\0"
	"not\0"
	"nothing\0"
	"notify\0"
	"notnull\0"
	"nowait\0"
	"null\0"
	"nullif\0"
	"nulls\0"
	"numeric\0"
	"object\0"
	"of\0"
	"off\0"
	"offset\0"
	"oids\0"
	"old\0"
	"omit\0"
	"on\0"
	"only\0"
	"operator\0"
	"option\0"
	"options\0"
	"or\0"
	"order\0"
	"ordinality\0"
	"others\0"
	"out\0"
	"outer\0"
	"over\0"
	"overlaps\0"
	"overlay\0"
	"overriding\0"
	"owned\0"
	"owner\0"
	"parallel\0"
	"parameter\0"
	"parser\0"
	"partial\0"
	"partition\0"
	"passing\0"
	"password\0"
	"path\0"
	"placing\0"
	"plan\0"
	"plans\0"
	"policy\0"
	"position\0"
	"preceding\0"
	"precision\0"
	"prepare\0"
	"prepared\0"
	"preserve\0"
	"primary\0"
	"prior\0"
	"privileges\0"
	"procedural\0"
	"procedure\0"
	"procedures\0"
	"program\0"
	"publication\0"
	"quote\0"
	"quotes\0"
	"range\0"
	"read\0"
	"real\0"
	"reassign\0"
	"recheck\0"
	"recursive\0"
	"ref\0"
	"references\0"
	"referencing\0"
	"refresh\0"
	"reindex\0"
	"relative\0"
	"release\0"
	"rename\0"
	"repeatable\0"
	"replace\0"
	"replica\0"
	"reset\0"
	"restart\0"
	"restrict\0"
	"return\0"
	"returning\0"
	"returns\0"
	"revoke\0"
	"right\0"
	"role\0"
	"rollback\0"
	"rollup\0"
	"routine\0"
	"routines\0"
	"row\0"
	"rows\0"
	"rule\0"
	"savepoint\0"
	"scalar\0"
	"schema\0"
	"schemas\0"
	"scroll\0"
	"search\0"
	"second\0"
	"security\0"
	"select\0"
	"sequence\0"
	"sequences\0"
	"serializable\0"
	"server\0"
	"session\0"
	"session_user\0"
	"set\0"
	"setof\0"
	"sets\0"
	"share\0"
	"show\0"
	"similar\0"
	"simple\0"
	"skip\0"
	"smallint\0"
	"snapshot\0"
	"some\0"
	"source\0"
	"sql\0"
	"stable\0"
	"standalone\0"
	"start\0"
	"statement\0"
	"statistics\0"
	"stdin\0"
	"stdout\0"
	"storage\0"
	"stored\0"
	"strict\0"
	"string\0"
	"strip\0"
	"subscription\0"
	"substring\0"
	"support\0"
	"symmetric\0"
	"sysid\0"
	"system\0"
	"system_user\0"
	"table\0"
	"tables\0"
	"tablesample\0"
	"tablespace\0"
	"target\0"
	"temp\0"
	"template\0"
	"temporary\0"
	"text\0"
	"then\0"
	"ties\0"
	"time\0"
	"timestamp\0"
	"to\0"
	"trailing\0"
	"transaction\0"
	"transform\0"
	"treat\0"
	"trigger\0"
	"trim\0"
	"true\0"
	"truncate\0"
	"trusted\0"
	"type\0"
	"types\0"
	"uescape\0"
	"unbounded\0"
	"uncommitted\0"
	"unconditional\0"
	"unencrypted\0"
	"union\0"
	"unique\0"
	"unknown\0"
	"unlisten\0"
	"unlogged\0"
	"until\0"
	"update\0"
	"user\0"
	"using\0"
	"vacuum\0"
	"valid\0"
	"validate\0"
	"validator\0"
	"value\0"
	"values\0"
	"varchar\0"
	"variadic\0"
	"varying\0"
	"verbose\0"
	"version\0"
	"view\0"
	"views\0"
	"volatile\0"
	"when\0"
	"where\0"
	"whitespace\0"
	"window\0"
	"with\0"
	"within\0"
	"without\0"
	"work\0"
	"wrapper\0"
	"write\0"
	"xml\0"
	"xmlattributes\0"
	"xmlconcat\0"
	"xmlelement\0"
	"xmlexists\0"
	"xmlforest\0"
	"xmlnamespaces\0"
	"xmlparse\0"
	"xmlpi\0"
	"xmlroot\0"
	"xmlserialize\0"
	"xmltable\0"
	"year\0"
	"yes\0"
	"zone";

static const uint16 ScanKeywords_kw_offsets[] = {
	0,
	6,
	13,
	22,
	29,
	36,
	40,
	46,
	52,
	62,
	66,
	71,
	77,
	84,
	92,
	100,
	104,
	108,
	114,
	117,
	121,
	132,
	142,
	153,
	164,
	167,
	174,
	181,
	191,
	205,
	214,
	221,
	227,
	235,
	242,
	249,
	253,
	261,
	266,
	274,
	277,
	283,
	288,
	295,
	303,
	312,
	317,
	322,
	330,
	336,
	341,
	351,
	367,
	373,
	384,
	390,
	396,
	404,
	413,
	421,
	431,
	438,
	446,
	454,
	463,
	470,
	480,
	492,
	505,
	517,
	531,
	540,
	551,
	562,
	574,
	582,
	591,
	602,
	607,
	612,
	619,
	625,
	629,
	634,
	642,
	658,
	671,
	684,
	699,
	712,
	730,
	743,
	750,
	756,
	761,
	770,
	774,
	785,
	789,
	797,
	805,
	813,
	822,
	833,
	842,
	850,
	857,
	867,
	878,
	886,
	892,
	897,
	904,
	915,
	923,
	931,
	940,
	943,
	952,
	959,
	966,
	971,
	976,
	981,
	987,
	994,
	1003,
	1013,
	1017,
	1022,
	1028,
	1035,
	1041,
	1048,
	1056,
	1066,
	1076,
	1084,
	1091,
	1099,
	1110,
	1120,
	1129,
	1137,
	1143,
	1150,
	1156,
	1163,
	1172,
	1178,
	1184,
	1194,
	1198,
	1204,
	1212,
	1219,
	1227,
	1234,
	1239,
	1244,
	1253,
	1263,
	1273,
	1280,
	1286,
	1294,
	1303,
	1309,
	1318,
	1325,
	1333,
	1340,
	1347,
	1352,
	1357,
	1366,
	1369,
	1375,
	1385,
	1395,
	1404,
	1411,
	1414,
	1422,
	1432,
	1442,
	1449,
	1455,
	1463,
	1471,
	1480,
	1490,
	1497,
	1503,
	1509,
	1515,
	1527,
	1534,
	1542,
	1546,
	1554,
	1564,
	1573,
	1578,
	1586,
	1589,
	1596,
	1606,
	1611,
	1616,
	1627,
	1641,
	1653,
	1665,
	1680,
	1691,
	1703,
	1718,
	1729,
	1740,
	1745,
	1749,
	1754,
	1760,
	1769,
	1775,
	1780,
	1788,
	1796,
	1806,
	1812,
	1817,
	1823,
	1828,
	1834,
	1841,
	1846,
	1852,
	1862,
	1877,
	1886,
	1891,
	1898,
	1905,
	1913,
	1919,
	1927,
	1940,
	1949,
	1955,
	1968,
	1975,
	1982,
	1991,
	1996,
	2002,
	2007,
	2012,
	2018,
	2027,
	2035,
	2041,
	2048,
	2052,
	2057,
	2061,
	2065,
	2070,
	2075,
	2078,
	2083,
	2093,
	2104,
	2108,
	2116,
	2123,
	2131,
	2138,
	2143,
	2150,
	2156,
	2164,
	2171,
	2174,
	2178,
	2185,
	2190,
	2194,
	2199,
	2202,
	2207,
	2216,
	2223,
	2231,
	2234,
	2240,
	2251,
	2258,
	2262,
	2268,
	2273,
	2282,
	2290,
	2301,
	2307,
	2313,
	2322,
	2332,
	2339,
	2347,
	2357,
	2365,
	2374,
	2379,
	2387,
	2392,
	2398,
	2405,
	2414,
	2424,
	2434,
	2442,
	2451,
	2460,
	2468,
	2474,
	2485,
	2496,
	2506,
	2517,
	2525,
	2537,
	2543,
	2550,
	2556,
	2561,
	2566,
	2575,
	2583,
	2593,
	2597,
	2608,
	2620,
	2628,
	2636,
	2645,
	2653,
	2660,
	2671,
	2679,
	2687,
	2693,
	2701,
	2710,
	2717,
	2727,
	2735,
	2742,
	2748,
	2753,
	2762,
	2769,
	2777,
	2786,
	2790,
	2795,
	2800,
	2810,
	2817,
	2824,
	2832,
	2839,
	2846,
	2853,
	2862,
	2869,
	2878,
	2888,
	2901,
	2908,
	2916,
	2929,
	2933,
	2939,
	2944,
	2950,
	2955,
	2963,
	2970,
	2975,
	2984,
	2993,
	2998,
	3005,
	3009,
	3016,
	3027,
	3033,
	3043,
	3054,
	3060,
	3067,
	3075,
	3082,
	3089,
	3096,
	3102,
	3115,
	3125,
	3133,
	3143,
	3149,
	3156,
	3168,
	3174,
	3181,
	3193,
	3204,
	3211,
	3216,
	3225,
	3235,
	3240,
	3245,
	3250,
	3255,
	3265,
	3268,
	3277,
	3289,
	3299,
	3305,
	3313,
	3318,
	3323,
	3332,
	3340,
	3345,
	3351,
	3359,
	3369,
	3381,
	3395,
	3407,
	3413,
	3420,
	3428,
	3437,
	3446,
	3452,
	3459,
	3464,
	3470,
	3477,
	3483,
	3492,
	3502,
	3508,
	3515,
	3523,
	3532,
	3540,
	3548,
	3556,
	3561,
	3567,
	3576,
	3581,
	3587,
	3598,
	3605,
	3610,
	3617,
	3625,
	3630,
	3638,
	3644,
	3648,
	3662,
	3672,
	3683,
	3693,
	3703,
	3717,
	3726,
	3732,
	3740,
	3753,
	3762,
	3767,
	3771,
};

#define SCANKEYWORDS_NUM_KEYWORDS 491

static int
ScanKeywords_hash_func(const void *key, size_t keylen)
{
	static const int16 h[983] = {
		283,   32767, 500,   226,   291,   32767, 32767, 32767,
		467,   152,   66,    291,   -300,  32767, -427,  -45,
		0,     219,   224,   189,   32767, 195,   0,     -507,
		324,   32767, 300,   32767, 0,     32767, 161,   32767,
		32767, 32767, 32767, 131,   32767, 101,   32767, 391,
		32767, 32767, 32767, 0,     2,     32767, 128,   418,
		-291,  32767, 32767, -631,  32767, 250,   219,   -142,
		133,   334,   32767, 0,     170,   32767, 516,   32767,
		307,   288,   391,   32767, 216,   319,   0,     32767,
		152,   32767, 375,   444,   433,   32767, 242,   32767,
		4,     -119,  481,   -13,   32767, 32767, -94,   0,
		290,   -113,  32767, 137,   122,   120,   32767, 32767,
		32767, 414,   -397,  -45,   -267,  -5,    605,   32767,
		453,   514,   32767, 400,   32767, 32767, 32767, 32767,
		361,   150,   32767, 107,   172,   -32,   81,    -232,
		-15,   830,   -46,   32767, 32767, 32767, 543,   -341,
		0,     32767, 288,   488,   32767, 43,    410,   -99,
		32767, 384,   32767, 32767, 315,   32767, -419,  -458,
		0,     -459,  0,     232,   32767, 32767, 333,   -413,
		32767, 584,   -76,   0,     -6,    125,   32767, 421,
		32767, 32767, -88,   128,   -1,    15,    55,    32767,
		214,   32767, 0,     0,     166,   348,   -337,  32767,
		260,   319,   32767, 180,   158,   0,     32767, 0,
		-226,  0,     129,   0,     378,   517,   -293,  671,
		32767, 32767, 0,     167,   305,   -61,   -229,  97,
		164,   88,    380,   50,    32767, 71,    -637,  106,
		32767, 79,    0,     415,   32767, 0,     32767, 317,
		379,   28,    431,   0,     32767, 32767, 301,   185,
		196,   37,    32767, 142,   200,   32767, -211,  -223,
		-392,  99,    32767, -366,  32767, 287,   32767, 0,
		-309,  0,     32767, -963,  32767, 222,   432,   32767,
		32767, 0,     32767, 32767, 266,   56,    0,     32767,
		391,   606,   32767, 32767, 360,   0,     60,    32767,
		32767, 0,     32767, 0,     325,   32767, 333,   32767,
		-54,   399,   0,     28,    237,   -648,  32767, 108,
		438,   32767, 221,   390,   32767, 32767, 223,   687,
		452,   125,   32767, -913,  186,   0,     32767, 32767,
		32767, 32767, 0,     0,     32767, 32767, 32767, -27,
		1087,  464,   -305,  427,   898,   32767, 0,     32767,
		0,     32767, 104,   32767, 32767, 260,   1065,  0,
		703,   32767, 0,     337,   350,   767,   32767, -330,
		379,   32767, 32767, 32767, 32767, 32767, 32767, 228,
		32767, 32767, 32767, 0,     -87,   -48,   32767, -541,
		415,   32767, 306,   32767, 32767, 32767, -117,  15,
		0,     0,     32767, 412,   -645,  223,   -558,  32767,
		32767, 32767, 32767, 32767, -254,  162,   -372,  0,
		0,     32767, 353,   0,     199,   32767, 664,   32767,
		32767, 0,     32767, -148,  32767, -98,   32767, 449,
		0,     32767, 383,   -495,  -295,  208,   0,     32767,
		511,   17,    32767, 32767, 0,     387,   32767, 32767,
		32767, 0,     32767, 32767, 2,     -2,    -177,  32767,
		0,     32767, 150,   32767, -471,  32767, -282,  32767,
		240,   183,   357,   423,   32767, 435,   32767, 284,
		32767, 358,   298,   195,   72,    0,     421,   535,
		32767, 426,   -206,  222,   32767, 0,     466,   36,
		426,   32767, 32767, 0,     32767, 0,     32767, 70,
		479,   32767, 514,   32767, 32767, 697,   436,   43,
		155,   32767, 32767, 0,     32767, -155,  32767, 11,
		649,   -376,  32767, 0,     -683,  -330,  361,   0,
		57,    263,   -43,   32767, 383,   0,     32767, 217,
		32767, 0,     478,   32767, 0,     32767, 463,   32767,
		501,   32767, 237,   301,   545,   302,   67,    311,
		1135,  152,   0,     342,   32767, 350,   418,   32767,
		0,     428,   0,     0,     -353,  381,   790,   32767,
		32767, -259,  32767, 32767, 32767, 229,   417,   0,
		232,   32767, 0,     980,   32767, 0,     0,     275,
		-314,  0,     0,     32767, 32767, 32767, 32767, 32767,
		0,     0,     -89,   292,   1049,  32767, 32767, -284,
		18,    32767, 175,   0,     732,   111,   32767, 428,
		-167,  92,    -59,   199,   0,     793,   702,   -231,
		32767, 32767, 32767, 32767, 187,   549,   32767, 32767,
		32767, 32767, 69,    480,   0,     490,   430,   32767,
		32767, 32767, 32767, -2,    32767, 240,   32767, 471,
		275,   32767, 524,   17,    0,     32767, 144,   0,
		310,   371,   328,   1016,  -639,  32767, 51,    32767,
		-982,  32767, 0,     -727,  32767, 32767, -117,  -115,
		249,   32767, 32767, -6,    32767, 183,   -350,  32767,
		14,    32767, 32767, 118,   -137,  -321,  32767, 793,
		32767, 32767, 32767, 0,     32767, 77,    204,   71,
		32767, -228,  -516,  32767, 790,   389,   -1,    112,
		366,   245,   32767, 0,     32767, 0,     -625,  154,
		-211,  32767, 32767, 105,   -253,  214,   0,     203,
		392,   0,     32767, 32767, 62,    102,   32767, 32767,
		29,    0,     0,     306,   32767, 32767, -29,   194,
		0,     -120,  32767, 32767, 32767, 376,   32767, 27,
		32767, 356,   32767, 0,     32767, 75,    174,   32767,
		32767, 32767, -37,   32767, 255,   124,   845,   32767,
		0,     32767, 64,    32767, -472,  -648,  32767, 584,
		0,     32767, 19,    201,   32767, 0,     32767, 32767,
		-414,  -171,  -621,  32767, -134,  0,     515,   0,
		767,   32767, 32767, 414,   32767, -88,   -236,  32767,
		-52,   298,   -254,  32767, 39,    0,     65,    118,
		32767, 182,   32767, 134,   0,     32767, 32767, 400,
		0,     32767, 32767, 705,   0,     32767, 32767, 269,
		32767, 32767, 296,   290,   32767, 0,     0,     32767,
		61,    32767, 299,   32767, -227,  240,   32767, 0,
		32767, 32767, 32767, 129,   32767, 0,     252,   32767,
		0,     -487,  32767, 0,     -127,  32767, 32767, 132,
		18,    0,     32767, 32767, -154,  0,     946,   401,
		264,   378,   0,     326,   32767, 0,     465,   233,
		87,    32767, 47,    0,     -357,  32767, 32767, 0,
		0,     -245,  835,   887,   32767, 32767, 32767, 32767,
		32767, 334,   0,     -56,   32767, -196,  0,     32767,
		32767, 32767, 154,   32767, 20,    -175,  63,    537,
		32767, 358,   32767, 121,   32767, 32767, 754,   0,
		32767, 0,     -113,  0,     0,     207,   0,     -256,
		32767, 241,   32767, 257,   32767, 194,   -595,  23,
		19,    268,   666,   231,   0,     211,   32767, 32767,
		32767, 32767, 0,     115,   136,   0,     32767, 32767,
		404,   -252,  -432,  0,     0,     341,   32767, 410,
		32767, -125,  9,     32767, 482,   727,   0,     32767,
		252,   0,     32767, 32767, 147,   124,   270,   10,
		-124,  47,    0,     300,   445,   -246,  32767, 111,
		32767, 32767, 32767, -356,  103,   81,    32767, 32767,
		32767, 32767, 280,   306,   0,     32767, 695,   32767,
		-768,  32767, 32767, 0,     32767, 0,     32767, 145,
		44,    32767, 32767, 32767, 432,   136,   32767, 0,
		-903,  251,   32767, -222,  370,   405,   99,    17,
		32767, 564,   32767, 32767, 32767, 0,     32767, 32767,
		32767, 141,   0,     0,     32767, 32767, 32767, 344,
		0,     464,   0,     0,     32767, 32767, 32767, 0,
		463,   32767, 32767, 329,   32767, 32767, 422,   32767,
		220,   32767, 347,   32767, -17,   253,   18
	};

	const unsigned char *k = (const unsigned char *) key;
	uint32		a = 0;
	uint32		b = 0;

	while (keylen--)
	{
		unsigned char c = *k++ | 0x20;

		a = a * 257 + c;
		b = b * 31 + c;
	}
	return h[a % 983] + h[b % 983];
}

const ScanKeywordList ScanKeywords = {
	ScanKeywords_kw_string,
	ScanKeywords_kw_offsets,
	ScanKeywords_hash_func,
	SCANKEYWORDS_NUM_KEYWORDS,
	17
};

#endif							/* KWLIST_D_H */
