# frozen_string_literal: true

# Copyright 2022 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module StorageTransfer
      module V1
        module StorageTransferService
          # Path helper methods for the StorageTransferService API.
          module Paths
            ##
            # Create a fully-qualified agentPools resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project_id}/agentPools/{agent_pool_id}`
            #
            # @param project_id [String]
            # @param agent_pool_id [String]
            #
            # @return [::String]
            def agent_pools_path project_id:, agent_pool_id:
              raise ::ArgumentError, "project_id cannot contain /" if project_id.to_s.include? "/"

              "projects/#{project_id}/agentPools/#{agent_pool_id}"
            end

            extend self
          end
        end
      end
    end
  end
end
