---
stage: Application Security Testing
group: Dynamic Analysis
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
title: Server-side code injection (NodeJS)
---

## Description

The target application was found vulnerable to code injection. A malicious actor could inject arbitrary
JavaScript code to be executed on the server. This could lead to a full system compromise by accessing
stored secrets, injecting code to take over accounts, or executing OS commands.

## Remediation

Never pass user input directly into functions which evaluate string data as code, such as `eval`, `setTimeout`
or `setInterval`. There is almost no benefit of passing string values to these methods, as such the best
recommendation is to replace the current logic with more safe implementations of dynamically evaluating
logic with user input. One alternative is to store functions or methods in a Map that can be looked
up using a key. If the key exists, the function can be executed.

```javascript
const function_map = new Map();

function_map.set('fn', function() {
    console.log('hello world');
})

const input = 'fn2';

const fn = function_map.get(input)

if (fn) {
    fn();
} else {
    console.log('invalid input');
}
```

## Details

| ID | Aggregated | CWE | Type | Risk |
|:---|:-----------|:----|:-----|:-----|
| 94.4 | false | 94 | Active | high |

## Links

- [CWE](https://cwe.mitre.org/data/definitions/94.html)
