/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.swing.tabcontrol.plaf;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Polygon;
import java.awt.Rectangle;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.UIManager;
import org.netbeans.swing.tabcontrol.TabDisplayer;
import org.netbeans.swing.tabcontrol.plaf.AbstractTabCellRenderer;
import org.netbeans.swing.tabcontrol.plaf.TabPainter;
import org.netbeans.swing.tabcontrol.plaf.WinFlatUtils;

class WinFlatEditorTabCellRenderer
extends AbstractTabCellRenderer {
    private static final Color background = UIManager.getColor("EditorTab.background");
    private static final Color activeBackground = WinFlatUtils.Utils.getUIColor("EditorTab.activeBackground", background);
    private static final Color selectedBackground = WinFlatUtils.Utils.getUIColor("EditorTab.selectedBackground", activeBackground);
    private static final Color selectedBackgroundBottomGradient = WinFlatUtils.Utils.getUIColor("EditorTab.selectedBackgroundBottomGradient", selectedBackground);
    private static final Color hoverBackground = UIManager.getColor("EditorTab.hoverBackground");
    private static final Color unselectedHoverBackground = WinFlatUtils.Utils.getUIColor("EditorTab.unselectedHoverBackground", hoverBackground);
    private static final Color attentionBackground = UIManager.getColor("EditorTab.attentionBackground");
    private static final Color foreground = WinFlatUtils.Utils.getUIColor("EditorTab.foreground", "TabbedPane.foreground");
    private static final Color activeForeground = WinFlatUtils.Utils.getUIColor("EditorTab.activeForeground", foreground);
    private static final Color selectedForeground = WinFlatUtils.Utils.getUIColor("EditorTab.selectedForeground", activeForeground);
    private static final Color hoverForeground = WinFlatUtils.Utils.getUIColor("EditorTab.hoverForeground", foreground);
    private static final Color attentionForeground = WinFlatUtils.Utils.getUIColor("EditorTab.attentionForeground", foreground);
    private static final Color underlineColor = UIManager.getColor("EditorTab.underlineColor");
    private static final Color inactiveUnderlineColor = UIManager.getColor("EditorTab.inactiveUnderlineColor");
    private static final Color tabSeparatorColor = UIManager.getColor("EditorTab.tabSeparatorColor");
    private static final Color contentBorderColor = UIManager.getColor("TabbedContainer.editor.contentBorderColor");
    private static final Insets tabInsets = WinFlatUtils.UIScale.scale(UIManager.getInsets("EditorTab.tabInsets"));
    private static final int underlineHeight = WinFlatUtils.UIScale.scale(UIManager.getInt("EditorTab.underlineHeight"));
    private static final boolean underlineAtTop = UIManager.getBoolean("EditorTab.underlineAtTop");
    private static boolean showTabSeparators = UIManager.getBoolean("EditorTab.showTabSeparators");
    private static final int CLOSE_ICON_RIGHT_PAD = WinFlatEditorTabCellRenderer.tabInsets.left;
    private static final boolean showSelectedTabBorder = WinFlatUtils.Utils.getUIBoolean("EditorTab.showSelectedTabBorder", false);
    private static final boolean unscaledBorders = WinFlatUtils.Utils.getUIBoolean("EditorTab.unscaledBorders", false);
    private static final FlatTabPainter leftClipPainter = new FlatTabPainter(true, false);
    private static final FlatTabPainter noClipPainter = new FlatTabPainter(false, false);
    private static final FlatTabPainter rightClipPainter = new FlatTabPainter(false, true);
    boolean firstTab;
    boolean lastTab;
    boolean nextTabSelected;

    public WinFlatEditorTabCellRenderer() {
        super(leftClipPainter, noClipPainter, rightClipPainter, new Dimension(WinFlatEditorTabCellRenderer.tabInsets.left + WinFlatEditorTabCellRenderer.tabInsets.right, WinFlatEditorTabCellRenderer.tabInsets.top + WinFlatEditorTabCellRenderer.tabInsets.bottom));
    }

    @Override
    public Dimension getPadding() {
        Dimension d = super.getPadding();
        if (this.isShowCloseButton() && !Boolean.getBoolean("nb.tabs.suppressCloseButton")) {
            d.width += this.findCloseIcon().getIconWidth() + WinFlatUtils.UIScale.scale(CLOSE_ICON_RIGHT_PAD);
        }
        return d;
    }

    @Override
    protected int getCaptionYAdjustment() {
        FontMetrics fm = this.getFontMetrics(this.getFont());
        int txtH = fm.getHeight();
        Insets ins = this.getInsets();
        int availH = this.getHeight() - (ins.top + ins.bottom);
        int yAdjustment = -1;
        return (availH <= txtH ? -fm.getDescent() : -1) + yAdjustment;
    }

    @Override
    protected int stateChanged(int oldState, int newState) {
        int result = super.stateChanged(oldState, newState);
        this.setForeground(this.colorForState(foreground, activeForeground, selectedForeground, hoverForeground, hoverForeground, attentionForeground));
        return result;
    }

    private Color colorForState(Color normal, Color active, Color selected, Color selectedHover, Color unselectedHover, Color attention) {
        return this.isAttention() ? attention : (this.isArmed() ? (this.isSelected() ? selectedHover : unselectedHover) : (this.isSelected() ? selected : (this.isActive() ? active : normal)));
    }

    private Icon findCloseIcon() {
        return WinFlatUtils.FlatTabControlIcon.get(1, this.inCloseButton() ? (this.isPressed() ? 1 : 3) : 0);
    }

    private static class FlatTabPainter
    implements TabPainter {
        final boolean leftClip;
        final boolean rightClip;

        public FlatTabPainter(boolean leftClip, boolean rightClip) {
            this.leftClip = leftClip;
            this.rightClip = rightClip;
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return tabInsets;
        }

        @Override
        public void getCloseButtonRectangle(JComponent jc, Rectangle rect, Rectangle bounds) {
            WinFlatEditorTabCellRenderer ren = (WinFlatEditorTabCellRenderer)jc;
            if (!ren.isShowCloseButton()) {
                rect.x = -100;
                rect.y = -100;
                rect.width = 0;
                rect.height = 0;
                return;
            }
            Icon icon = ren.findCloseIcon();
            int iconWidth = icon.getIconWidth();
            int iconHeight = icon.getIconHeight();
            rect.x = bounds.x + bounds.width - iconWidth - WinFlatUtils.UIScale.scale(CLOSE_ICON_RIGHT_PAD);
            int yAdjustment = 2;
            rect.y = bounds.y + Math.max(0, (bounds.height - iconHeight) / 2) - 1 + yAdjustment;
            rect.width = iconWidth;
            rect.height = iconHeight;
        }

        @Override
        public Polygon getInteriorPolygon(Component c) {
            int x = 0;
            int y = 0;
            int width = c.getWidth();
            int height = c.getHeight();
            Polygon p = new Polygon();
            p.addPoint(x, y);
            p.addPoint(x + width, y);
            p.addPoint(x + width, y + height);
            p.addPoint(x, y + height);
            return p;
        }

        @Override
        public boolean isBorderOpaque() {
            return true;
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        }

        @Override
        public void paintInterior(Graphics g, Component c) {
            WinFlatUtils.HiDPIUtils.paintAtScale1x(g, 0, 0, c.getWidth(), c.getHeight(), (gd, width, height, scale) -> this.paintInteriorAtScale1x(gd, c, width, height, scale));
            WinFlatEditorTabCellRenderer ren = (WinFlatEditorTabCellRenderer)c;
            if (!ren.isClipLeft() && !ren.isClipRight()) {
                this.paintCloseButton(g, ren);
            }
        }

        private static void fillGradientRect(Graphics2D g, int x, int y, int width, int height, Color color, Color bottomGradient, int gradientOffset) {
            if (bottomGradient.equals(color)) {
                g.setColor(color);
            } else {
                g.setPaint(new GradientPaint(0.0f, y + gradientOffset, color, 0.0f, y + height - gradientOffset, bottomGradient, false));
            }
            g.fillRect(x, y, width, height);
        }

        private void paintInteriorAtScale1x(Graphics2D g, Component c, int width, int height, double scale) {
            WinFlatEditorTabCellRenderer ren = (WinFlatEditorTabCellRenderer)c;
            boolean selected = ren.isSelected();
            Color bg = ren.colorForState(background, activeBackground, selectedBackground, hoverBackground, unselectedHoverBackground, attentionBackground);
            boolean showSeparator = showTabSeparators && !ren.lastTab && !selected && !ren.nextTabSelected && !this.rightClip;
            int contentBorderWidth = unscaledBorders ? 1 : WinFlatUtils.HiDPIUtils.deviceBorderWidth(scale, 1);
            int tabSeparatorWidth = showSeparator ? contentBorderWidth : 0;
            int underlineHeight = (int)Math.round((double)underlineHeight * scale);
            FlatTabPainter.fillGradientRect(g, 0, 0, width - (bg != background ? tabSeparatorWidth : 0), height, bg, selected && !selectedBackground.equals(selectedBackgroundBottomGradient) ? selectedBackgroundBottomGradient : bg, underlineAtTop ? underlineHeight : 0);
            if (selected) {
                if (showSelectedTabBorder) {
                    g.setColor(contentBorderColor);
                    g.fillRect(0, 0, width - tabSeparatorWidth, contentBorderWidth);
                    if (!this.leftClip) {
                        g.fillRect(0, 0, contentBorderWidth, height);
                    }
                    if (!this.rightClip) {
                        g.fillRect(width - tabSeparatorWidth - contentBorderWidth, 0, contentBorderWidth, height);
                    }
                }
                if (underlineHeight > 0) {
                    g.setColor(ren.isActive() ? underlineColor : inactiveUnderlineColor);
                    if (underlineAtTop) {
                        g.fillRect(0, 0, width - tabSeparatorWidth, underlineHeight);
                    } else {
                        g.fillRect(0, height - underlineHeight, width - tabSeparatorWidth, underlineHeight);
                    }
                }
            } else {
                g.setColor(contentBorderColor);
                g.fillRect(0, height - contentBorderWidth, width, contentBorderWidth);
            }
            if (showSeparator) {
                int offset = (int)(4.0 * scale);
                g.setColor(tabSeparatorColor);
                g.fillRect(width - tabSeparatorWidth, offset, tabSeparatorWidth, height - offset * 2 - 1);
            }
        }

        private void paintCloseButton(Graphics g, WinFlatEditorTabCellRenderer ren) {
            Rectangle r = new Rectangle();
            this.getCloseButtonRectangle(ren, r, new Rectangle(0, 0, ren.getWidth(), ren.getHeight()));
            if (!g.hitClip(r.x, r.y, r.width, r.height)) {
                return;
            }
            Icon icon = ren.findCloseIcon();
            icon.paintIcon(ren, g, r.x, r.y);
        }

        @Override
        public boolean supportsCloseButton(JComponent renderer) {
            return renderer instanceof TabDisplayer ? ((TabDisplayer)renderer).isShowCloseButton() : true;
        }
    }
}

