/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.bridge;

import io.sf.carte.echosvg.bridge.Messages;
import io.sf.carte.echosvg.bridge.ScriptSecurity;
import io.sf.carte.echosvg.util.ParsedURL;
import java.net.URI;
import java.net.URISyntaxException;

public class DefaultScriptSecurity
implements ScriptSecurity {
    public static final String DATA_PROTOCOL = "data";
    public static final String ERROR_CANNOT_ACCESS_DOCUMENT_URL = "DefaultScriptSecurity.error.cannot.access.document.url";
    public static final String ERROR_SCRIPT_FROM_DIFFERENT_URL = "DefaultScriptSecurity.error.script.from.different.url";
    protected SecurityException se;

    @Override
    public void checkLoadScript() {
        if (this.se != null) {
            throw this.se;
        }
    }

    public DefaultScriptSecurity(String string, ParsedURL parsedURL, ParsedURL parsedURL2) {
        if (parsedURL2 == null || "application/java-archive".equals(string)) {
            this.se = new SecurityException(Messages.formatMessage(ERROR_CANNOT_ACCESS_DOCUMENT_URL, new Object[]{parsedURL}));
        } else {
            String string2;
            String string3;
            String string4 = parsedURL2.getHost();
            String string5 = string3 = parsedURL != null ? parsedURL.getHost() : null;
            if (string3 == null && !DATA_PROTOCOL.equals(parsedURL.getProtocol()) && (string2 = parsedURL.getPath()) != null) {
                try {
                    string3 = new URI(string2).getHost();
                }
                catch (URISyntaxException uRISyntaxException) {
                    throw new RuntimeException(uRISyntaxException);
                }
            }
            if (!(string4 == string3 || string4 != null && string4.equals(string3) || parsedURL2.equals((Object)parsedURL) || parsedURL != null && DATA_PROTOCOL.equals(parsedURL.getProtocol()))) {
                this.se = new SecurityException(Messages.formatMessage(ERROR_SCRIPT_FROM_DIFFERENT_URL, new Object[]{parsedURL}));
            }
        }
    }
}

