/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.property;

import io.sf.carte.doc.style.css.CSSColorValue;
import io.sf.carte.doc.style.css.HSLColor;
import io.sf.carte.doc.style.css.RGBAColor;
import io.sf.carte.doc.style.css.nsac.LexicalUnit;
import io.sf.carte.doc.style.css.property.ColorValue;
import io.sf.carte.doc.style.css.property.HSLColorImpl;
import io.sf.carte.doc.style.css.property.PrimitiveValue;
import io.sf.carte.doc.style.css.property.StyleValue;
import io.sf.carte.doc.style.css.property.ValueFactory;
import org.w3c.dom.DOMException;

public class HSLColorValue
extends ColorValue
implements io.sf.carte.doc.style.css.HSLColorValue {
    private static final long serialVersionUID = 1L;
    private final HSLColorImpl hslColor;

    public HSLColorValue() {
        this.hslColor = new ColorValue.MyHSLColorImpl();
    }

    HSLColorValue(HSLColorImpl hSLColorImpl) {
        this.hslColor = hSLColorImpl;
    }

    HSLColorValue(HSLColorValue hSLColorValue) {
        super(hSLColorValue);
        this.hslColor = hSLColorValue.hslColor.clone();
    }

    @Override
    public CSSColorValue.ColorModel getColorModel() {
        return CSSColorValue.ColorModel.HSL;
    }

    @Override
    void set(StyleValue styleValue) {
        super.set(styleValue);
        HSLColorValue hSLColorValue = (HSLColorValue)styleValue;
        this.hslColor.setHue(hSLColorValue.hslColor.getHue());
        this.hslColor.setSaturation(hSLColorValue.hslColor.getSaturation());
        this.hslColor.setLightness(hSLColorValue.hslColor.getLightness());
        this.hslColor.alpha = hSLColorValue.hslColor.alpha;
    }

    @Override
    public String getCssText() {
        return this.hslColor.toString(this.commaSyntax);
    }

    @Override
    public String getMinifiedCssText(String string) {
        String string2;
        String string3 = this.hslColor.toMinifiedString(this.commaSyntax);
        if (!this.hslColor.isNonOpaque() && this.hasConvertibleComponents() && (string2 = ((ColorValue.CSSRGBColor)this.toRGBColor()).toMinifiedString()).length() < string3.length() - 5) {
            string3 = string2;
        }
        return string3;
    }

    @Override
    public PrimitiveValue getComponent(int n) {
        return this.hslColor.item(n);
    }

    @Override
    public void setComponent(int n, StyleValue styleValue) {
        this.hslColor.setComponent(n, (PrimitiveValue)styleValue);
    }

    @Override
    public HSLColorValue toHSLColorValue() throws DOMException {
        return this;
    }

    @Override
    public RGBAColor toRGBColor() throws DOMException {
        double[] dArray = this.hslColor.toSRGB(false);
        ColorValue.CSSRGBColor cSSRGBColor = new ColorValue.CSSRGBColor();
        cSSRGBColor.setColorComponents(dArray);
        cSSRGBColor.setAlpha(this.hslColor.alpha.clone());
        return cSSRGBColor;
    }

    @Override
    boolean hasConvertibleComponents() {
        return this.hslColor.hasConvertibleComponents();
    }

    @Override
    public HSLColor getColor() {
        return this.hslColor;
    }

    HSLColorImpl getHSLColorImpl() {
        return this.hslColor;
    }

    @Override
    PrimitiveValue.LexicalSetter newLexicalSetter() {
        return new MyLexicalSetter();
    }

    @Override
    public int hashCode() {
        int n = 31;
        int n2 = super.hashCode();
        n2 = 31 * n2 + this.hslColor.hashCode();
        return n2;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        if (!(object instanceof HSLColorValue)) {
            return false;
        }
        HSLColorValue hSLColorValue = (HSLColorValue)object;
        return this.hslColor.equals(hSLColorValue.hslColor);
    }

    @Override
    public HSLColorValue clone() {
        return new HSLColorValue(this);
    }

    class MyLexicalSetter
    extends PrimitiveValue.LexicalSetter {
        MyLexicalSetter() {
            super(HSLColorValue.this);
        }

        @Override
        void setLexicalUnit(LexicalUnit lexicalUnit) {
            try {
                if (lexicalUnit.getLexicalUnitType() != LexicalUnit.LexicalType.HSLCOLOR) {
                    throw new DOMException(13, "No hsl() value: " + lexicalUnit.toString());
                }
                this.setLexicalHSL(lexicalUnit);
            }
            catch (DOMException dOMException) {
                throw dOMException;
            }
            catch (RuntimeException runtimeException) {
                throw new DOMException(12, "Bad value: " + lexicalUnit.toString());
            }
            this.nextLexicalUnit = lexicalUnit.getNextLexicalUnit();
        }

        private void setLexicalHSL(LexicalUnit lexicalUnit) {
            LexicalUnit lexicalUnit2 = lexicalUnit.getParameters();
            ValueFactory valueFactory = new ValueFactory();
            PrimitiveValue primitiveValue = valueFactory.createCSSPrimitiveValue(lexicalUnit2, true);
            HSLColorValue.this.commaSyntax = (lexicalUnit2 = lexicalUnit2.getNextLexicalUnit()).getLexicalUnitType() == LexicalUnit.LexicalType.OPERATOR_COMMA;
            if (HSLColorValue.this.commaSyntax) {
                lexicalUnit2 = lexicalUnit2.getNextLexicalUnit();
            }
            PrimitiveValue primitiveValue2 = valueFactory.createCSSPrimitiveValue(lexicalUnit2, true);
            if (HSLColorValue.this.commaSyntax) {
                lexicalUnit2 = lexicalUnit2.getNextLexicalUnit();
            }
            lexicalUnit2 = lexicalUnit2.getNextLexicalUnit();
            PrimitiveValue primitiveValue3 = valueFactory.createCSSPrimitiveValue(lexicalUnit2, true);
            lexicalUnit2 = lexicalUnit2.getNextLexicalUnit();
            PrimitiveValue primitiveValue4 = null;
            if (lexicalUnit2 != null) {
                if (HSLColorValue.this.commaSyntax) {
                    if (lexicalUnit2.getLexicalUnitType() != LexicalUnit.LexicalType.OPERATOR_COMMA) {
                        throw new DOMException(12, "Bad value: " + lexicalUnit.toString());
                    }
                } else if (lexicalUnit2.getLexicalUnitType() != LexicalUnit.LexicalType.OPERATOR_SLASH) {
                    throw new DOMException(12, "Expected slash in: " + lexicalUnit.toString());
                }
                lexicalUnit2 = lexicalUnit2.getNextLexicalUnit();
                primitiveValue4 = valueFactory.createCSSPrimitiveValue(lexicalUnit2, true);
                HSLColorValue.this.hslColor.setAlpha(primitiveValue4);
                lexicalUnit2 = lexicalUnit2.getNextLexicalUnit();
                if (lexicalUnit2 != null) {
                    throw new DOMException(12, "Bad value: " + lexicalUnit.toString());
                }
            }
            HSLColorValue.this.hslColor.setHue(primitiveValue);
            HSLColorValue.this.hslColor.setSaturation(primitiveValue2);
            HSLColorValue.this.hslColor.setLightness(primitiveValue3);
        }
    }
}

