/*
 * Decompiled with CFR 0.152.
 */
package jogamp.graph.font.typecast.ot;

import com.jogamp.opengl.math.geom.AABBox;
import jogamp.graph.font.typecast.ot.Glyph;
import jogamp.graph.font.typecast.ot.Point;
import jogamp.graph.font.typecast.ot.table.GlyphDescription;

public class TTGlyph
extends Glyph {
    private short _leftSideBearing;
    private int _advanceWidth;
    private Point[] _points;

    public TTGlyph(GlyphDescription glyphDescription, short s, int n) {
        super(glyphDescription.getGlyphIndex());
        this._leftSideBearing = s;
        this._advanceWidth = n;
        this.describe(glyphDescription);
    }

    @Override
    public final void clearPointData() {
        this._points = null;
    }

    @Override
    public int getAdvanceWidth() {
        return this._advanceWidth;
    }

    @Override
    public short getLeftSideBearing() {
        return this._leftSideBearing;
    }

    @Override
    public Point getPoint(int n) {
        return this._points[n];
    }

    @Override
    public int getPointCount() {
        return this._points.length;
    }

    public void reset() {
    }

    public void scale(int n) {
        for (Point point : this._points) {
            point.x = (point.x << 10) * n >> 26;
            point.y = (point.y << 10) * n >> 26;
        }
        this._leftSideBearing = (short)(this._leftSideBearing * n >> 6);
        this._advanceWidth = this._advanceWidth * n >> 6;
    }

    private void describe(GlyphDescription glyphDescription) {
        int n = 0;
        int n2 = glyphDescription != null ? glyphDescription.getPointCount() : 0;
        this._points = new Point[n2];
        for (int i = 0; i < n2; ++i) {
            boolean bl;
            boolean bl2 = bl = glyphDescription.getEndPtOfContours(n) == i;
            if (bl) {
                ++n;
            }
            this._points[i] = new Point(glyphDescription.getXCoordinate(i), glyphDescription.getYCoordinate(i), (glyphDescription.getFlags(i) & 1) != 0, bl);
        }
        this._bbox = new AABBox(glyphDescription.getXMinimum(), glyphDescription.getYMinimum(), 0.0f, glyphDescription.getXMaximum(), glyphDescription.getYMaximum(), 0.0f);
    }

    @Override
    public String toString() {
        return "TTGlyph id " + this._glyph_id + ", points " + this._points.length + ", advance " + this.getAdvanceWidth() + ", " + this._bbox;
    }
}

