/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl;

import com.jogamp.common.ExceptionUtils;
import com.jogamp.common.util.PropertyAccess;
import com.jogamp.nativewindow.CapabilitiesImmutable;
import com.jogamp.nativewindow.NativeWindowException;
import com.jogamp.opengl.GLCapabilitiesChooser;
import com.jogamp.opengl.GLCapabilitiesImmutable;
import java.io.PrintStream;
import java.util.List;
import jogamp.opengl.Debug;

public class DefaultGLCapabilitiesChooser
implements GLCapabilitiesChooser {
    private static final boolean DEBUG;
    private static final int NO_SCORE = -9999999;
    private static final int DOUBLE_BUFFER_MISMATCH_PENALTY = 1000;
    private static final int OPAQUE_MISMATCH_PENALTY = 750;
    private static final int STENCIL_MISMATCH_PENALTY = 500;
    private static final int MULTISAMPLE_MISMATCH_PENALTY = 500;
    private static final int MULTISAMPLE_EXTENSION_MISMATCH_PENALTY = 250;
    private static final int COLOR_MISMATCH_PENALTY_SCALE = 36;
    private static final int DEPTH_MISMATCH_PENALTY_SCALE = 6;
    private static final int ACCUM_MISMATCH_PENALTY_SCALE = 1;
    private static final int STENCIL_MISMATCH_PENALTY_SCALE = 3;
    private static final int MULTISAMPLE_MISMATCH_PENALTY_SCALE = 3;

    @Override
    public int chooseCapabilities(CapabilitiesImmutable capabilitiesImmutable, List<? extends CapabilitiesImmutable> list, int n) {
        int n2;
        GLCapabilitiesImmutable gLCapabilitiesImmutable;
        int n3;
        int n4;
        int n5;
        int n6;
        if (null == capabilitiesImmutable) {
            throw new NativeWindowException("Null desired capabilities");
        }
        if (0 == list.size()) {
            throw new NativeWindowException("Empty available capabilities");
        }
        GLCapabilitiesImmutable gLCapabilitiesImmutable2 = (GLCapabilitiesImmutable)capabilitiesImmutable;
        int n7 = list.size();
        if (DEBUG) {
            ExceptionUtils.dumpStack((PrintStream)System.err);
            System.err.println("Desired: " + gLCapabilitiesImmutable2);
            System.err.println("Available: " + n7);
            for (int i = 0; i < list.size(); ++i) {
                System.err.println(i + ": " + list.get(i));
            }
            System.err.println("Window system's recommended choice: " + n);
        }
        if (n >= 0 && n < n7 && null != list.get(n)) {
            if (DEBUG) {
                System.err.println("Choosing window system's recommended choice of " + n);
                System.err.println(list.get(n));
            }
            return n;
        }
        int[] nArray = new int[n7];
        for (n6 = 0; n6 < nArray.length; ++n6) {
            nArray[n6] = -9999999;
        }
        n6 = gLCapabilitiesImmutable2.getNumSamples();
        for (n5 = 0; n5 < n7; ++n5) {
            GLCapabilitiesImmutable gLCapabilitiesImmutable3 = (GLCapabilitiesImmutable)list.get(n5);
            if (gLCapabilitiesImmutable3 == null || gLCapabilitiesImmutable2.isOnscreen() && !gLCapabilitiesImmutable3.isOnscreen() || !gLCapabilitiesImmutable2.isOnscreen() && (gLCapabilitiesImmutable2.isPBuffer() && !gLCapabilitiesImmutable3.isPBuffer() || gLCapabilitiesImmutable2.isBitmap() && !gLCapabilitiesImmutable3.isBitmap()) || gLCapabilitiesImmutable2.getStereo() != gLCapabilitiesImmutable3.getStereo()) continue;
            n4 = gLCapabilitiesImmutable3.getNumSamples();
            n3 = 0;
            n3 += 36 * (gLCapabilitiesImmutable3.getRedBits() + gLCapabilitiesImmutable3.getGreenBits() + gLCapabilitiesImmutable3.getBlueBits() + gLCapabilitiesImmutable3.getAlphaBits() - (gLCapabilitiesImmutable2.getRedBits() + gLCapabilitiesImmutable2.getGreenBits() + gLCapabilitiesImmutable2.getBlueBits() + gLCapabilitiesImmutable2.getAlphaBits()));
            n3 += 6 * DefaultGLCapabilitiesChooser.sign(n3) * Math.abs(gLCapabilitiesImmutable3.getDepthBits() - gLCapabilitiesImmutable2.getDepthBits());
            n3 += 1 * DefaultGLCapabilitiesChooser.sign(n3) * Math.abs(gLCapabilitiesImmutable3.getAccumRedBits() + gLCapabilitiesImmutable3.getAccumGreenBits() + gLCapabilitiesImmutable3.getAccumBlueBits() + gLCapabilitiesImmutable3.getAccumAlphaBits() - (gLCapabilitiesImmutable2.getAccumRedBits() + gLCapabilitiesImmutable2.getAccumGreenBits() + gLCapabilitiesImmutable2.getAccumBlueBits() + gLCapabilitiesImmutable2.getAccumAlphaBits()));
            n3 += 3 * DefaultGLCapabilitiesChooser.sign(n3) * (gLCapabilitiesImmutable3.getStencilBits() - gLCapabilitiesImmutable2.getStencilBits());
            n3 += 3 * DefaultGLCapabilitiesChooser.sign(n3) * (n4 - n6);
            if (gLCapabilitiesImmutable3.getDoubleBuffered() != gLCapabilitiesImmutable2.getDoubleBuffered()) {
                n3 += DefaultGLCapabilitiesChooser.sign(n3) * 1000;
            }
            if (gLCapabilitiesImmutable3.isBackgroundOpaque() != gLCapabilitiesImmutable2.isBackgroundOpaque()) {
                n3 += DefaultGLCapabilitiesChooser.sign(n3) * 750;
            }
            if (gLCapabilitiesImmutable2.getStencilBits() > 0 && gLCapabilitiesImmutable3.getStencilBits() == 0) {
                n3 += DefaultGLCapabilitiesChooser.sign(n3) * 500;
            }
            if (n6 > 0) {
                if (n4 == 0) {
                    n3 += DefaultGLCapabilitiesChooser.sign(n3) * 500;
                }
                if (!gLCapabilitiesImmutable2.getSampleExtension().equals(gLCapabilitiesImmutable3.getSampleExtension())) {
                    n3 += DefaultGLCapabilitiesChooser.sign(n3) * 250;
                }
            }
            nArray[n5] = n3;
        }
        n5 = 0;
        int n8 = 0;
        for (n4 = 0; n4 < n7; ++n4) {
            n3 = nArray[n4];
            if (n3 == -9999999 || !(gLCapabilitiesImmutable = (GLCapabilitiesImmutable)list.get(n4)).getHardwareAccelerated()) continue;
            n2 = Math.abs(n3);
            if (n5 != 0 && n2 <= n8) continue;
            n5 = 1;
            n8 = n2;
        }
        if (n5 != 0) {
            for (n4 = 0; n4 < n7; ++n4) {
                n3 = nArray[n4];
                if (n3 == -9999999 || (gLCapabilitiesImmutable = (GLCapabilitiesImmutable)list.get(n4)).getHardwareAccelerated()) continue;
                if (n3 <= 0) {
                    n3 -= n8;
                } else if (n3 > 0) {
                    n3 += n8;
                }
                nArray[n4] = n3;
            }
        }
        if (DEBUG) {
            System.err.print("Scores: [");
            for (n4 = 0; n4 < n7; ++n4) {
                if (n4 > 0) {
                    System.err.print(",");
                }
                System.err.print(" " + n4 + ": " + nArray[n4]);
            }
            System.err.println(" ]");
        }
        n4 = -9999999;
        n3 = -1;
        for (int i = 0; i < n7; ++i) {
            n2 = nArray[i];
            if (n2 == -9999999 || n4 != -9999999 && (Math.abs(n2) >= Math.abs(n4) || DefaultGLCapabilitiesChooser.sign(n4) >= 0 && DefaultGLCapabilitiesChooser.sign(n2) <= 0)) continue;
            n4 = n2;
            n3 = i;
        }
        if (n3 < 0) {
            throw new NativeWindowException("Unable to select one of the provided GLCapabilities");
        }
        if (DEBUG) {
            System.err.println("Chosen index: " + n3);
            System.err.println("Chosen capabilities:");
            System.err.println(list.get(n3));
        }
        return n3;
    }

    private static int sign(int n) {
        if (n < 0) {
            return -1;
        }
        return 1;
    }

    static {
        Debug.initSingleton();
        DEBUG = PropertyAccess.isPropertyDefined((String)"jogl.debug.CapabilitiesChooser", (boolean)true);
    }
}

