/*
 * Decompiled with CFR 0.152.
 */
package io.sf.jclf.text.format;

import io.sf.jclf.text.format.ObjectFormat;
import io.sf.jclf.text.format.SpecParsingException;

public abstract class NumberFormat
extends ObjectFormat {
    protected char tipo;
    protected boolean signpre = false;
    protected boolean blankpre = false;
    protected boolean zeropadding = false;
    private transient long roundfactor = 1L;

    protected NumberFormat() {
    }

    @Override
    protected char setFormat(String string) throws SpecParsingException {
        this.tipo = super.setFormat(string);
        if (this.precision >= 0) {
            this.setRoundFactor();
        }
        return this.tipo;
    }

    @Override
    protected boolean setFlag(char c, int n) {
        if (!super.setFlag(c, n)) {
            switch (c) {
                case '+': {
                    this.signpre = true;
                    break;
                }
                case ' ': {
                    this.blankpre = true;
                    break;
                }
                case '0': {
                    if (!this.ralign || n != this.flags.length - 1) break;
                    this.zeropadding = true;
                    break;
                }
                default: {
                    return false;
                }
            }
        }
        return true;
    }

    private void setRoundFactor() {
        this.roundfactor = (long)Math.pow(10.0, this.precision);
    }

    protected long getRoundingFactor() {
        return this.roundfactor;
    }

    protected final String roundNumber(Number number) {
        double d = number.doubleValue();
        d = (double)Math.round(d * (double)this.roundfactor) / (double)this.roundfactor;
        String string = Double.toString(d);
        string = this.ralign ? this.expandLeftToWidth(string, ' ') : this.expandRightToWidth(string);
        return string;
    }
}

