'' FreeBASIC binding for mingw-w64-v4.0.4
''
'' based on the C header files:
''   DISCLAIMER
''   This file has no copyright assigned and is placed in the Public Domain.
''   This file is part of the mingw-w64 runtime package.
''
''   The mingw-w64 runtime package and its code is distributed in the hope that it 
''   will be useful but WITHOUT ANY WARRANTY.  ALL WARRANTIES, EXPRESSED OR 
''   IMPLIED ARE HEREBY DISCLAIMED.  This includes but is not limited to 
''   warranties of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
''
'' translated to FreeBASIC by:
''   FreeBASIC development team

#pragma once

#include once "sql.bi"

extern "Windows"

#define __SQLEXT
const SQL_SPEC_MAJOR = 3
const SQL_SPEC_MINOR = 52
#define SQL_SPEC_STRING "03.52"
const SQL_SQLSTATE_SIZE = 5
const SQL_MAX_DSN_LENGTH = 32
const SQL_MAX_OPTION_STRING_LENGTH = 256
const SQL_NO_DATA_FOUND = SQL_NO_DATA
const SQL_HANDLE_SENV = 5
const SQL_ATTR_ODBC_VERSION = 200
const SQL_ATTR_CONNECTION_POOLING = 201
const SQL_ATTR_CP_MATCH = 202
const SQL_CP_OFF = 0u
const SQL_CP_ONE_PER_DRIVER = 1u
const SQL_CP_ONE_PER_HENV = 2u
const SQL_CP_DEFAULT = SQL_CP_OFF
const SQL_CP_STRICT_MATCH = 0u
const SQL_CP_RELAXED_MATCH = 1u
const SQL_CP_MATCH_DEFAULT = SQL_CP_STRICT_MATCH
const SQL_OV_ODBC2 = 2u
const SQL_OV_ODBC3 = 3u
const SQL_ACCESS_MODE = 101
const SQL_AUTOCOMMIT = 102
const SQL_LOGIN_TIMEOUT = 103
const SQL_OPT_TRACE = 104
const SQL_OPT_TRACEFILE = 105
const SQL_TRANSLATE_DLL = 106
const SQL_TRANSLATE_OPTION = 107
const SQL_TXN_ISOLATION = 108
const SQL_CURRENT_QUALIFIER = 109
const SQL_ODBC_CURSORS = 110
const SQL_QUIET_MODE = 111
const SQL_PACKET_SIZE = 112
const SQL_ATTR_ACCESS_MODE = SQL_ACCESS_MODE
const SQL_ATTR_AUTOCOMMIT = SQL_AUTOCOMMIT
const SQL_ATTR_CONNECTION_TIMEOUT = 113
const SQL_ATTR_CURRENT_CATALOG = SQL_CURRENT_QUALIFIER
const SQL_ATTR_DISCONNECT_BEHAVIOR = 114
const SQL_ATTR_ENLIST_IN_DTC = 1207
const SQL_ATTR_ENLIST_IN_XA = 1208
const SQL_ATTR_LOGIN_TIMEOUT = SQL_LOGIN_TIMEOUT
const SQL_ATTR_ODBC_CURSORS = SQL_ODBC_CURSORS
const SQL_ATTR_PACKET_SIZE = SQL_PACKET_SIZE
const SQL_ATTR_QUIET_MODE = SQL_QUIET_MODE
const SQL_ATTR_TRACE = SQL_OPT_TRACE
const SQL_ATTR_TRACEFILE = SQL_OPT_TRACEFILE
const SQL_ATTR_TRANSLATE_LIB = SQL_TRANSLATE_DLL
const SQL_ATTR_TRANSLATE_OPTION = SQL_TRANSLATE_OPTION
const SQL_ATTR_TXN_ISOLATION = SQL_TXN_ISOLATION
const SQL_ATTR_CONNECTION_DEAD = 1209
const SQL_ATTR_ANSI_APP = 115
const SQL_MODE_READ_WRITE = 0u
const SQL_MODE_READ_ONLY = 1u
const SQL_MODE_DEFAULT = SQL_MODE_READ_WRITE
const SQL_AUTOCOMMIT_OFF = 0u
const SQL_AUTOCOMMIT_ON = 1u
const SQL_AUTOCOMMIT_DEFAULT = SQL_AUTOCOMMIT_ON
const SQL_LOGIN_TIMEOUT_DEFAULT = 15u
const SQL_OPT_TRACE_OFF = 0u
const SQL_OPT_TRACE_ON = 1u
const SQL_OPT_TRACE_DEFAULT = SQL_OPT_TRACE_OFF
#define SQL_OPT_TRACE_FILE_DEFAULT !"\\SQL.LOG"
const SQL_CUR_USE_IF_NEEDED = 0u
const SQL_CUR_USE_ODBC = 1u
const SQL_CUR_USE_DRIVER = 2u
const SQL_CUR_DEFAULT = SQL_CUR_USE_DRIVER
const SQL_DB_RETURN_TO_POOL = 0u
const SQL_DB_DISCONNECT = 1u
const SQL_DB_DEFAULT = SQL_DB_RETURN_TO_POOL
const SQL_DTC_DONE = 0
const SQL_CD_TRUE = 1
const SQL_CD_FALSE = 0
const SQL_AA_TRUE = 1
const SQL_AA_FALSE = 0
const SQL_QUERY_TIMEOUT = 0
const SQL_MAX_ROWS = 1
const SQL_NOSCAN = 2
const SQL_MAX_LENGTH = 3
const SQL_ASYNC_ENABLE = 4
const SQL_BIND_TYPE = 5
const SQL_CURSOR_TYPE = 6
const SQL_CONCURRENCY = 7
const SQL_KEYSET_SIZE = 8
const SQL_ROWSET_SIZE = 9
const SQL_SIMULATE_CURSOR = 10
const SQL_RETRIEVE_DATA = 11
const SQL_USE_BOOKMARKS = 12
const SQL_GET_BOOKMARK = 13
const SQL_ROW_NUMBER = 14
const SQL_ATTR_ASYNC_ENABLE = 4
const SQL_ATTR_CONCURRENCY = SQL_CONCURRENCY
const SQL_ATTR_CURSOR_TYPE = SQL_CURSOR_TYPE
const SQL_ATTR_ENABLE_AUTO_IPD = 15
const SQL_ATTR_FETCH_BOOKMARK_PTR = 16
const SQL_ATTR_KEYSET_SIZE = SQL_KEYSET_SIZE
const SQL_ATTR_MAX_LENGTH = SQL_MAX_LENGTH
const SQL_ATTR_MAX_ROWS = SQL_MAX_ROWS
const SQL_ATTR_NOSCAN = SQL_NOSCAN
const SQL_ATTR_PARAM_BIND_OFFSET_PTR = 17
const SQL_ATTR_PARAM_BIND_TYPE = 18
const SQL_ATTR_PARAM_OPERATION_PTR = 19
const SQL_ATTR_PARAM_STATUS_PTR = 20
const SQL_ATTR_PARAMS_PROCESSED_PTR = 21
const SQL_ATTR_PARAMSET_SIZE = 22
const SQL_ATTR_QUERY_TIMEOUT = SQL_QUERY_TIMEOUT
const SQL_ATTR_RETRIEVE_DATA = SQL_RETRIEVE_DATA
const SQL_ATTR_ROW_BIND_OFFSET_PTR = 23
const SQL_ATTR_ROW_BIND_TYPE = SQL_BIND_TYPE
const SQL_ATTR_ROW_NUMBER = SQL_ROW_NUMBER
const SQL_ATTR_ROW_OPERATION_PTR = 24
const SQL_ATTR_ROW_STATUS_PTR = 25
const SQL_ATTR_ROWS_FETCHED_PTR = 26
const SQL_ATTR_ROW_ARRAY_SIZE = 27
const SQL_ATTR_SIMULATE_CURSOR = SQL_SIMULATE_CURSOR
const SQL_ATTR_USE_BOOKMARKS = SQL_USE_BOOKMARKS
const SQL_IS_POINTER = -4
const SQL_IS_UINTEGER = -5
const SQL_IS_INTEGER = -6
const SQL_IS_USMALLINT = -7
const SQL_IS_SMALLINT = -8
const SQL_PARAM_BIND_BY_COLUMN = 0u
const SQL_PARAM_BIND_TYPE_DEFAULT = SQL_PARAM_BIND_BY_COLUMN
const SQL_QUERY_TIMEOUT_DEFAULT = 0u
const SQL_MAX_ROWS_DEFAULT = 0u
const SQL_NOSCAN_OFF = 0u
const SQL_NOSCAN_ON = 1u
const SQL_NOSCAN_DEFAULT = SQL_NOSCAN_OFF
const SQL_MAX_LENGTH_DEFAULT = 0u
const SQL_ASYNC_ENABLE_OFF = 0u
const SQL_ASYNC_ENABLE_ON = 1u
const SQL_ASYNC_ENABLE_DEFAULT = SQL_ASYNC_ENABLE_OFF
const SQL_BIND_BY_COLUMN = 0u
const SQL_BIND_TYPE_DEFAULT = SQL_BIND_BY_COLUMN
const SQL_CONCUR_READ_ONLY = 1
const SQL_CONCUR_LOCK = 2
const SQL_CONCUR_ROWVER = 3
const SQL_CONCUR_VALUES = 4
const SQL_CONCUR_DEFAULT = SQL_CONCUR_READ_ONLY
const SQL_CURSOR_FORWARD_ONLY = 0u
const SQL_CURSOR_KEYSET_DRIVEN = 1u
const SQL_CURSOR_DYNAMIC = 2u
const SQL_CURSOR_STATIC = 3u
const SQL_CURSOR_TYPE_DEFAULT = SQL_CURSOR_FORWARD_ONLY
const SQL_ROWSET_SIZE_DEFAULT = 1u
const SQL_KEYSET_SIZE_DEFAULT = 0u
const SQL_SC_NON_UNIQUE = 0u
const SQL_SC_TRY_UNIQUE = 1u
const SQL_SC_UNIQUE = 2u
const SQL_RD_OFF = 0u
const SQL_RD_ON = 1u
const SQL_RD_DEFAULT = SQL_RD_ON
const SQL_UB_OFF = 0u
const SQL_UB_ON = &o1u
const SQL_UB_DEFAULT = SQL_UB_OFF
const SQL_UB_FIXED = SQL_UB_ON
const SQL_UB_VARIABLE = 2u
const SQL_DESC_ARRAY_SIZE = 20
const SQL_DESC_ARRAY_STATUS_PTR = 21
const SQL_DESC_BASE_COLUMN_NAME = 22
const SQL_DESC_BASE_TABLE_NAME = 23
const SQL_DESC_BIND_OFFSET_PTR = 24
const SQL_DESC_BIND_TYPE = 25
const SQL_DESC_DATETIME_INTERVAL_PRECISION = 26
const SQL_DESC_LITERAL_PREFIX = 27
const SQL_DESC_LITERAL_SUFFIX = 28
const SQL_DESC_LOCAL_TYPE_NAME = 29
const SQL_DESC_MAXIMUM_SCALE = 30
const SQL_DESC_MINIMUM_SCALE = 31
const SQL_DESC_NUM_PREC_RADIX = 32
const SQL_DESC_PARAMETER_TYPE = 33
const SQL_DESC_ROWS_PROCESSED_PTR = 34
const SQL_DESC_ROWVER = 35
const SQL_DIAG_CURSOR_ROW_COUNT = -1249
const SQL_DIAG_ROW_NUMBER = -1248
const SQL_DIAG_COLUMN_NUMBER = -1247
const SQL_DATE = 9
const SQL_INTERVAL = 10
const SQL_TIME = 10
const SQL_TIMESTAMP = 11
const SQL_LONGVARCHAR = -1
const SQL_BINARY = -2
const SQL_VARBINARY = -3
const SQL_LONGVARBINARY = -4
const SQL_BIGINT = -5
const SQL_TINYINT = -6
const SQL_BIT = -7
const SQL_GUID = -11
const SQL_CODE_YEAR = 1
const SQL_CODE_MONTH = 2
const SQL_CODE_DAY = 3
const SQL_CODE_HOUR = 4
const SQL_CODE_MINUTE = 5
const SQL_CODE_SECOND = 6
const SQL_CODE_YEAR_TO_MONTH = 7
const SQL_CODE_DAY_TO_HOUR = 8
const SQL_CODE_DAY_TO_MINUTE = 9
const SQL_CODE_DAY_TO_SECOND = 10
const SQL_CODE_HOUR_TO_MINUTE = 11
const SQL_CODE_HOUR_TO_SECOND = 12
const SQL_CODE_MINUTE_TO_SECOND = 13
const SQL_INTERVAL_YEAR = 100 + SQL_CODE_YEAR
const SQL_INTERVAL_MONTH = 100 + SQL_CODE_MONTH
const SQL_INTERVAL_DAY = 100 + SQL_CODE_DAY
const SQL_INTERVAL_HOUR = 100 + SQL_CODE_HOUR
const SQL_INTERVAL_MINUTE = 100 + SQL_CODE_MINUTE
const SQL_INTERVAL_SECOND = 100 + SQL_CODE_SECOND
const SQL_INTERVAL_YEAR_TO_MONTH = 100 + SQL_CODE_YEAR_TO_MONTH
const SQL_INTERVAL_DAY_TO_HOUR = 100 + SQL_CODE_DAY_TO_HOUR
const SQL_INTERVAL_DAY_TO_MINUTE = 100 + SQL_CODE_DAY_TO_MINUTE
const SQL_INTERVAL_DAY_TO_SECOND = 100 + SQL_CODE_DAY_TO_SECOND
const SQL_INTERVAL_HOUR_TO_MINUTE = 100 + SQL_CODE_HOUR_TO_MINUTE
const SQL_INTERVAL_HOUR_TO_SECOND = 100 + SQL_CODE_HOUR_TO_SECOND
const SQL_INTERVAL_MINUTE_TO_SECOND = 100 + SQL_CODE_MINUTE_TO_SECOND
const SQL_C_CHAR = SQL_CHAR
const SQL_C_LONG = SQL_INTEGER
const SQL_C_SHORT = SQL_SMALLINT
const SQL_C_FLOAT = SQL_REAL
const SQL_C_DOUBLE = SQL_DOUBLE
const SQL_C_NUMERIC = SQL_NUMERIC
const SQL_C_DEFAULT = 99
const SQL_SIGNED_OFFSET = -20
const SQL_UNSIGNED_OFFSET = -22
const SQL_C_DATE = SQL_DATE
const SQL_C_TIME = SQL_TIME
const SQL_C_TIMESTAMP = SQL_TIMESTAMP
const SQL_C_TYPE_DATE = SQL_TYPE_DATE
const SQL_C_TYPE_TIME = SQL_TYPE_TIME
const SQL_C_TYPE_TIMESTAMP = SQL_TYPE_TIMESTAMP
const SQL_C_INTERVAL_YEAR = SQL_INTERVAL_YEAR
const SQL_C_INTERVAL_MONTH = SQL_INTERVAL_MONTH
const SQL_C_INTERVAL_DAY = SQL_INTERVAL_DAY
const SQL_C_INTERVAL_HOUR = SQL_INTERVAL_HOUR
const SQL_C_INTERVAL_MINUTE = SQL_INTERVAL_MINUTE
const SQL_C_INTERVAL_SECOND = SQL_INTERVAL_SECOND
const SQL_C_INTERVAL_YEAR_TO_MONTH = SQL_INTERVAL_YEAR_TO_MONTH
const SQL_C_INTERVAL_DAY_TO_HOUR = SQL_INTERVAL_DAY_TO_HOUR
const SQL_C_INTERVAL_DAY_TO_MINUTE = SQL_INTERVAL_DAY_TO_MINUTE
const SQL_C_INTERVAL_DAY_TO_SECOND = SQL_INTERVAL_DAY_TO_SECOND
const SQL_C_INTERVAL_HOUR_TO_MINUTE = SQL_INTERVAL_HOUR_TO_MINUTE
const SQL_C_INTERVAL_HOUR_TO_SECOND = SQL_INTERVAL_HOUR_TO_SECOND
const SQL_C_INTERVAL_MINUTE_TO_SECOND = SQL_INTERVAL_MINUTE_TO_SECOND
const SQL_C_BINARY = SQL_BINARY
const SQL_C_BIT = SQL_BIT
const SQL_C_SBIGINT = SQL_BIGINT + SQL_SIGNED_OFFSET
const SQL_C_UBIGINT = SQL_BIGINT + SQL_UNSIGNED_OFFSET
const SQL_C_TINYINT = SQL_TINYINT
const SQL_C_SLONG = SQL_C_LONG + SQL_SIGNED_OFFSET
const SQL_C_SSHORT = SQL_C_SHORT + SQL_SIGNED_OFFSET
const SQL_C_STINYINT = SQL_TINYINT + SQL_SIGNED_OFFSET
const SQL_C_ULONG = SQL_C_LONG + SQL_UNSIGNED_OFFSET
const SQL_C_USHORT = SQL_C_SHORT + SQL_UNSIGNED_OFFSET
const SQL_C_UTINYINT = SQL_TINYINT + SQL_UNSIGNED_OFFSET

#ifdef __FB_64BIT__
	const SQL_C_BOOKMARK = SQL_C_UBIGINT
#else
	const SQL_C_BOOKMARK = SQL_C_ULONG
#endif

const SQL_C_GUID = SQL_GUID
const SQL_TYPE_NULL = 0
const SQL_C_VARBOOKMARK = SQL_C_BINARY
const SQL_NO_ROW_NUMBER = -1
const SQL_NO_COLUMN_NUMBER = -1
const SQL_ROW_NUMBER_UNKNOWN = -2
const SQL_COLUMN_NUMBER_UNKNOWN = -2
const SQL_DEFAULT_PARAM = -5
const SQL_IGNORE = -6
const SQL_COLUMN_IGNORE = SQL_IGNORE
const SQL_LEN_DATA_AT_EXEC_OFFSET = -100
#define SQL_LEN_DATA_AT_EXEC(length) ((-(length)) + SQL_LEN_DATA_AT_EXEC_OFFSET)
const SQL_LEN_BINARY_ATTR_OFFSET = -100
#define SQL_LEN_BINARY_ATTR(length) ((-(length)) + SQL_LEN_BINARY_ATTR_OFFSET)
const SQL_SETPARAM_VALUE_MAX = -1
const SQL_COLUMN_COUNT = 0
const SQL_COLUMN_NAME = 1
const SQL_COLUMN_TYPE = 2
const SQL_DESC_CONCISE_TYPE = SQL_COLUMN_TYPE
const SQL_COLUMN_LENGTH = 3
const SQL_COLUMN_PRECISION = 4
const SQL_COLUMN_SCALE = 5
const SQL_COLUMN_DISPLAY_SIZE = 6
const SQL_DESC_DISPLAY_SIZE = SQL_COLUMN_DISPLAY_SIZE
const SQL_COLUMN_NULLABLE = 7
const SQL_COLUMN_UNSIGNED = 8
const SQL_DESC_UNSIGNED = SQL_COLUMN_UNSIGNED
const SQL_COLUMN_MONEY = 9
const SQL_DESC_FIXED_PREC_SCALE = SQL_COLUMN_MONEY
const SQL_COLUMN_UPDATABLE = 10
const SQL_DESC_UPDATABLE = SQL_COLUMN_UPDATABLE
const SQL_COLUMN_AUTO_INCREMENT = 11
const SQL_DESC_AUTO_UNIQUE_VALUE = SQL_COLUMN_AUTO_INCREMENT
const SQL_COLUMN_CASE_SENSITIVE = 12
const SQL_DESC_CASE_SENSITIVE = SQL_COLUMN_CASE_SENSITIVE
const SQL_COLUMN_SEARCHABLE = 13
const SQL_DESC_SEARCHABLE = SQL_COLUMN_SEARCHABLE
const SQL_COLUMN_TYPE_NAME = 14
const SQL_DESC_TYPE_NAME = SQL_COLUMN_TYPE_NAME
const SQL_COLUMN_TABLE_NAME = 15
const SQL_DESC_TABLE_NAME = SQL_COLUMN_TABLE_NAME
const SQL_COLUMN_OWNER_NAME = 16
const SQL_DESC_SCHEMA_NAME = SQL_COLUMN_OWNER_NAME
const SQL_COLUMN_QUALIFIER_NAME = 17
const SQL_DESC_CATALOG_NAME = SQL_COLUMN_QUALIFIER_NAME
const SQL_COLUMN_LABEL = 18
const SQL_DESC_LABEL = SQL_COLUMN_LABEL
const SQL_COLATT_OPT_MAX = SQL_COLUMN_LABEL
const SQL_COLATT_OPT_MIN = SQL_COLUMN_COUNT
const SQL_ATTR_READONLY = 0
const SQL_ATTR_WRITE = 1
const SQL_ATTR_READWRITE_UNKNOWN = 2
const SQL_UNSEARCHABLE = 0
const SQL_LIKE_ONLY = 1
const SQL_COL_PRED_CHAR = SQL_LIKE_ONLY
const SQL_ALL_EXCEPT_LIKE = 2
const SQL_COL_PRED_BASIC = SQL_ALL_EXCEPT_LIKE
const SQL_SEARCHABLE = 3
const SQL_PRED_SEARCHABLE = SQL_SEARCHABLE
const SQL_NO_TOTAL = -4
const SQL_API_SQLALLOCHANDLESTD = 73
const SQL_API_SQLBULKOPERATIONS = 24
const SQL_API_SQLBINDPARAMETER = 72
const SQL_API_SQLBROWSECONNECT = 55
const SQL_API_SQLCOLATTRIBUTES = 6
const SQL_API_SQLCOLUMNPRIVILEGES = 56
const SQL_API_SQLDESCRIBEPARAM = 58
const SQL_API_SQLDRIVERCONNECT = 41
const SQL_API_SQLDRIVERS = 71
const SQL_API_SQLEXTENDEDFETCH = 59
const SQL_API_SQLFOREIGNKEYS = 60
const SQL_API_SQLMORERESULTS = 61
const SQL_API_SQLNATIVESQL = 62
const SQL_API_SQLNUMPARAMS = 63
const SQL_API_SQLPARAMOPTIONS = 64
const SQL_API_SQLPRIMARYKEYS = 65
const SQL_API_SQLPROCEDURECOLUMNS = 66
const SQL_API_SQLPROCEDURES = 67
const SQL_API_SQLSETPOS = 68
const SQL_API_SQLSETSCROLLOPTIONS = 69
const SQL_API_SQLTABLEPRIVILEGES = 70
const SQL_API_ALL_FUNCTIONS = 0
const SQL_API_LOADBYORDINAL = 199
const SQL_API_ODBC3_ALL_FUNCTIONS = 999
const SQL_API_ODBC3_ALL_FUNCTIONS_SIZE = 250
#define SQL_FUNC_EXISTS(pfExists, uwAPI) iif((*(cptr(UWORD ptr, (pfExists)) + ((uwAPI) shr 4))) and (1 shl ((uwAPI) and &h000F)), SQL_TRUE, SQL_FALSE)
const SQL_INFO_FIRST = 0
const SQL_ACTIVE_CONNECTIONS = 0
const SQL_ACTIVE_STATEMENTS = 1
const SQL_DRIVER_HDBC = 3
const SQL_DRIVER_HENV = 4
const SQL_DRIVER_HSTMT = 5
const SQL_DRIVER_NAME = 6
const SQL_DRIVER_VER = 7
const SQL_ODBC_API_CONFORMANCE = 9
const SQL_ODBC_VER = 10
const SQL_ROW_UPDATES = 11
const SQL_ODBC_SAG_CLI_CONFORMANCE = 12
const SQL_ODBC_SQL_CONFORMANCE = 15
const SQL_PROCEDURES = 21
const SQL_CONCAT_NULL_BEHAVIOR = 22
const SQL_CURSOR_ROLLBACK_BEHAVIOR = 24
const SQL_EXPRESSIONS_IN_ORDERBY = 27
const SQL_MAX_OWNER_NAME_LEN = 32
const SQL_MAX_PROCEDURE_NAME_LEN = 33
const SQL_MAX_QUALIFIER_NAME_LEN = 34
const SQL_MULT_RESULT_SETS = 36
const SQL_MULTIPLE_ACTIVE_TXN = 37
const SQL_OUTER_JOINS = 38
const SQL_OWNER_TERM = 39
const SQL_PROCEDURE_TERM = 40
const SQL_QUALIFIER_NAME_SEPARATOR = 41
const SQL_QUALIFIER_TERM = 42
const SQL_SCROLL_OPTIONS = 44
const SQL_TABLE_TERM = 45
const SQL_CONVERT_FUNCTIONS = 48
const SQL_NUMERIC_FUNCTIONS = 49
const SQL_STRING_FUNCTIONS = 50
const SQL_SYSTEM_FUNCTIONS = 51
const SQL_TIMEDATE_FUNCTIONS = 52
const SQL_CONVERT_BIGINT = 53
const SQL_CONVERT_BINARY = 54
const SQL_CONVERT_BIT = 55
const SQL_CONVERT_CHAR = 56
const SQL_CONVERT_DATE = 57
const SQL_CONVERT_DECIMAL = 58
const SQL_CONVERT_DOUBLE = 59
const SQL_CONVERT_FLOAT = 60
const SQL_CONVERT_INTEGER = 61
const SQL_CONVERT_LONGVARCHAR = 62
const SQL_CONVERT_NUMERIC = 63
const SQL_CONVERT_REAL = 64
const SQL_CONVERT_SMALLINT = 65
const SQL_CONVERT_TIME = 66
const SQL_CONVERT_TIMESTAMP = 67
const SQL_CONVERT_TINYINT = 68
const SQL_CONVERT_VARBINARY = 69
const SQL_CONVERT_VARCHAR = 70
const SQL_CONVERT_LONGVARBINARY = 71
const SQL_ODBC_SQL_OPT_IEF = 73
const SQL_CORRELATION_NAME = 74
const SQL_NON_NULLABLE_COLUMNS = 75
const SQL_DRIVER_HLIB = 76
const SQL_DRIVER_ODBC_VER = 77
const SQL_LOCK_TYPES = 78
const SQL_POS_OPERATIONS = 79
const SQL_POSITIONED_STATEMENTS = 80
const SQL_BOOKMARK_PERSISTENCE = 82
const SQL_STATIC_SENSITIVITY = 83
const SQL_FILE_USAGE = 84
const SQL_COLUMN_ALIAS = 87
const SQL_GROUP_BY = 88
const SQL_KEYWORDS = 89
const SQL_OWNER_USAGE = 91
const SQL_QUALIFIER_USAGE = 92
const SQL_QUOTED_IDENTIFIER_CASE = 93
const SQL_SUBQUERIES = 95
const SQL_UNION = 96
const SQL_MAX_ROW_SIZE_INCLUDES_LONG = 103
const SQL_MAX_CHAR_LITERAL_LEN = 108
const SQL_TIMEDATE_ADD_INTERVALS = 109
const SQL_TIMEDATE_DIFF_INTERVALS = 110
const SQL_NEED_LONG_DATA_LEN = 111
const SQL_MAX_BINARY_LITERAL_LEN = 112
const SQL_LIKE_ESCAPE_CLAUSE = 113
const SQL_QUALIFIER_LOCATION = 114
const SQL_ACTIVE_ENVIRONMENTS = 116
const SQL_ALTER_DOMAIN = 117
const SQL_SQL_CONFORMANCE = 118
const SQL_DATETIME_LITERALS = 119
const SQL_ASYNC_MODE = 10021
const SQL_BATCH_ROW_COUNT = 120
const SQL_BATCH_SUPPORT = 121
const SQL_CATALOG_LOCATION = SQL_QUALIFIER_LOCATION
const SQL_CATALOG_NAME_SEPARATOR = SQL_QUALIFIER_NAME_SEPARATOR
const SQL_CATALOG_TERM = SQL_QUALIFIER_TERM
const SQL_CATALOG_USAGE = SQL_QUALIFIER_USAGE
const SQL_CONVERT_WCHAR = 122
const SQL_CONVERT_INTERVAL_DAY_TIME = 123
const SQL_CONVERT_INTERVAL_YEAR_MONTH = 124
const SQL_CONVERT_WLONGVARCHAR = 125
const SQL_CONVERT_WVARCHAR = 126
const SQL_CREATE_ASSERTION = 127
const SQL_CREATE_CHARACTER_SET = 128
const SQL_CREATE_COLLATION = 129
const SQL_CREATE_DOMAIN = 130
const SQL_CREATE_SCHEMA = 131
const SQL_CREATE_TABLE = 132
const SQL_CREATE_TRANSLATION = 133
const SQL_CREATE_VIEW = 134
const SQL_DRIVER_HDESC = 135
const SQL_DROP_ASSERTION = 136
const SQL_DROP_CHARACTER_SET = 137
const SQL_DROP_COLLATION = 138
const SQL_DROP_DOMAIN = 139
const SQL_DROP_SCHEMA = 140
const SQL_DROP_TABLE = 141
const SQL_DROP_TRANSLATION = 142
const SQL_DROP_VIEW = 143
const SQL_DYNAMIC_CURSOR_ATTRIBUTES1 = 144
const SQL_DYNAMIC_CURSOR_ATTRIBUTES2 = 145
const SQL_FORWARD_ONLY_CURSOR_ATTRIBUTES1 = 146
const SQL_FORWARD_ONLY_CURSOR_ATTRIBUTES2 = 147
const SQL_INDEX_KEYWORDS = 148
const SQL_INFO_SCHEMA_VIEWS = 149
const SQL_KEYSET_CURSOR_ATTRIBUTES1 = 150
const SQL_KEYSET_CURSOR_ATTRIBUTES2 = 151
const SQL_MAX_ASYNC_CONCURRENT_STATEMENTS = 10022
const SQL_ODBC_INTERFACE_CONFORMANCE = 152
const SQL_PARAM_ARRAY_ROW_COUNTS = 153
const SQL_PARAM_ARRAY_SELECTS = 154
const SQL_SCHEMA_TERM = SQL_OWNER_TERM
const SQL_SCHEMA_USAGE = SQL_OWNER_USAGE
const SQL_SQL92_DATETIME_FUNCTIONS = 155
const SQL_SQL92_FOREIGN_KEY_DELETE_RULE = 156
const SQL_SQL92_FOREIGN_KEY_UPDATE_RULE = 157
const SQL_SQL92_GRANT = 158
const SQL_SQL92_NUMERIC_VALUE_FUNCTIONS = 159
const SQL_SQL92_PREDICATES = 160
const SQL_SQL92_RELATIONAL_JOIN_OPERATORS = 161
const SQL_SQL92_REVOKE = 162
const SQL_SQL92_ROW_VALUE_CONSTRUCTOR = 163
const SQL_SQL92_STRING_FUNCTIONS = 164
const SQL_SQL92_VALUE_EXPRESSIONS = 165
const SQL_STANDARD_CLI_CONFORMANCE = 166
const SQL_STATIC_CURSOR_ATTRIBUTES1 = 167
const SQL_STATIC_CURSOR_ATTRIBUTES2 = 168
const SQL_AGGREGATE_FUNCTIONS = 169
const SQL_DDL_INDEX = 170
const SQL_DM_VER = 171
const SQL_INSERT_STATEMENT = 172
const SQL_CONVERT_GUID = 173
const SQL_UNION_STATEMENT = SQL_UNION
const SQL_DTC_TRANSITION_COST = 1750
const SQL_AT_ADD_COLUMN_SINGLE = &h00000020
const SQL_AT_ADD_COLUMN_DEFAULT = &h00000040
const SQL_AT_ADD_COLUMN_COLLATION = &h00000080
const SQL_AT_SET_COLUMN_DEFAULT = &h00000100
const SQL_AT_DROP_COLUMN_DEFAULT = &h00000200
const SQL_AT_DROP_COLUMN_CASCADE = &h00000400
const SQL_AT_DROP_COLUMN_RESTRICT = &h00000800
const SQL_AT_ADD_TABLE_CONSTRAINT = &h00001000
const SQL_AT_DROP_TABLE_CONSTRAINT_CASCADE = &h00002000
const SQL_AT_DROP_TABLE_CONSTRAINT_RESTRICT = &h00004000
const SQL_AT_CONSTRAINT_NAME_DEFINITION = &h00008000
const SQL_AT_CONSTRAINT_INITIALLY_DEFERRED = &h00010000
const SQL_AT_CONSTRAINT_INITIALLY_IMMEDIATE = &h00020000
const SQL_AT_CONSTRAINT_DEFERRABLE = &h00040000
const SQL_AT_CONSTRAINT_NON_DEFERRABLE = &h00080000
const SQL_CVT_CHAR = &h00000001
const SQL_CVT_NUMERIC = &h00000002
const SQL_CVT_DECIMAL = &h00000004
const SQL_CVT_INTEGER = &h00000008
const SQL_CVT_SMALLINT = &h00000010
const SQL_CVT_FLOAT = &h00000020
const SQL_CVT_REAL = &h00000040
const SQL_CVT_DOUBLE = &h00000080
const SQL_CVT_VARCHAR = &h00000100
const SQL_CVT_LONGVARCHAR = &h00000200
const SQL_CVT_BINARY = &h00000400
const SQL_CVT_VARBINARY = &h00000800
const SQL_CVT_BIT = &h00001000
const SQL_CVT_TINYINT = &h00002000
const SQL_CVT_BIGINT = &h00004000
const SQL_CVT_DATE = &h00008000
const SQL_CVT_TIME = &h00010000
const SQL_CVT_TIMESTAMP = &h00020000
const SQL_CVT_LONGVARBINARY = &h00040000
const SQL_CVT_INTERVAL_YEAR_MONTH = &h00080000
const SQL_CVT_INTERVAL_DAY_TIME = &h00100000
const SQL_CVT_WCHAR = &h00200000
const SQL_CVT_WLONGVARCHAR = &h00400000
const SQL_CVT_WVARCHAR = &h00800000
const SQL_CVT_GUID = &h01000000
const SQL_FN_CVT_CONVERT = &h00000001
const SQL_FN_CVT_CAST = &h00000002
const SQL_FN_STR_CONCAT = &h00000001
const SQL_FN_STR_INSERT = &h00000002
const SQL_FN_STR_LEFT = &h00000004
const SQL_FN_STR_LTRIM = &h00000008
const SQL_FN_STR_LENGTH = &h00000010
const SQL_FN_STR_LOCATE = &h00000020
const SQL_FN_STR_LCASE = &h00000040
const SQL_FN_STR_REPEAT = &h00000080
const SQL_FN_STR_REPLACE = &h00000100
const SQL_FN_STR_RIGHT = &h00000200
const SQL_FN_STR_RTRIM = &h00000400
const SQL_FN_STR_SUBSTRING = &h00000800
const SQL_FN_STR_UCASE = &h00001000
const SQL_FN_STR_ASCII = &h00002000
const SQL_FN_STR_CHAR = &h00004000
const SQL_FN_STR_DIFFERENCE = &h00008000
const SQL_FN_STR_LOCATE_2 = &h00010000
const SQL_FN_STR_SOUNDEX = &h00020000
const SQL_FN_STR_SPACE = &h00040000
const SQL_FN_STR_BIT_LENGTH = &h00080000
const SQL_FN_STR_CHAR_LENGTH = &h00100000
const SQL_FN_STR_CHARACTER_LENGTH = &h00200000
const SQL_FN_STR_OCTET_LENGTH = &h00400000
const SQL_FN_STR_POSITION = &h00800000
const SQL_SSF_CONVERT = &h00000001
const SQL_SSF_LOWER = &h00000002
const SQL_SSF_UPPER = &h00000004
const SQL_SSF_SUBSTRING = &h00000008
const SQL_SSF_TRANSLATE = &h00000010
const SQL_SSF_TRIM_BOTH = &h00000020
const SQL_SSF_TRIM_LEADING = &h00000040
const SQL_SSF_TRIM_TRAILING = &h00000080
const SQL_FN_NUM_ABS = &h00000001
const SQL_FN_NUM_ACOS = &h00000002
const SQL_FN_NUM_ASIN = &h00000004
const SQL_FN_NUM_ATAN = &h00000008
const SQL_FN_NUM_ATAN2 = &h00000010
const SQL_FN_NUM_CEILING = &h00000020
const SQL_FN_NUM_COS = &h00000040
const SQL_FN_NUM_COT = &h00000080
const SQL_FN_NUM_EXP = &h00000100
const SQL_FN_NUM_FLOOR = &h00000200
const SQL_FN_NUM_LOG = &h00000400
const SQL_FN_NUM_MOD = &h00000800
const SQL_FN_NUM_SIGN = &h00001000
const SQL_FN_NUM_SIN = &h00002000
const SQL_FN_NUM_SQRT = &h00004000
const SQL_FN_NUM_TAN = &h00008000
const SQL_FN_NUM_PI = &h00010000
const SQL_FN_NUM_RAND = &h00020000
const SQL_FN_NUM_DEGREES = &h00040000
const SQL_FN_NUM_LOG10 = &h00080000
const SQL_FN_NUM_POWER = &h00100000
const SQL_FN_NUM_RADIANS = &h00200000
const SQL_FN_NUM_ROUND = &h00400000
const SQL_FN_NUM_TRUNCATE = &h00800000
const SQL_SNVF_BIT_LENGTH = &h00000001
const SQL_SNVF_CHAR_LENGTH = &h00000002
const SQL_SNVF_CHARACTER_LENGTH = &h00000004
const SQL_SNVF_EXTRACT = &h00000008
const SQL_SNVF_OCTET_LENGTH = &h00000010
const SQL_SNVF_POSITION = &h00000020
const SQL_FN_TD_NOW = &h00000001
const SQL_FN_TD_CURDATE = &h00000002
const SQL_FN_TD_DAYOFMONTH = &h00000004
const SQL_FN_TD_DAYOFWEEK = &h00000008
const SQL_FN_TD_DAYOFYEAR = &h00000010
const SQL_FN_TD_MONTH = &h00000020
const SQL_FN_TD_QUARTER = &h00000040
const SQL_FN_TD_WEEK = &h00000080
const SQL_FN_TD_YEAR = &h00000100
const SQL_FN_TD_CURTIME = &h00000200
const SQL_FN_TD_HOUR = &h00000400
const SQL_FN_TD_MINUTE = &h00000800
const SQL_FN_TD_SECOND = &h00001000
const SQL_FN_TD_TIMESTAMPADD = &h00002000
const SQL_FN_TD_TIMESTAMPDIFF = &h00004000
const SQL_FN_TD_DAYNAME = &h00008000
const SQL_FN_TD_MONTHNAME = &h00010000
const SQL_FN_TD_CURRENT_DATE = &h00020000
const SQL_FN_TD_CURRENT_TIME = &h00040000
const SQL_FN_TD_CURRENT_TIMESTAMP = &h00080000
const SQL_FN_TD_EXTRACT = &h00100000
const SQL_SDF_CURRENT_DATE = &h00000001
const SQL_SDF_CURRENT_TIME = &h00000002
const SQL_SDF_CURRENT_TIMESTAMP = &h00000004
const SQL_FN_SYS_USERNAME = &h00000001
const SQL_FN_SYS_DBNAME = &h00000002
const SQL_FN_SYS_IFNULL = &h00000004
const SQL_FN_TSI_FRAC_SECOND = &h00000001
const SQL_FN_TSI_SECOND = &h00000002
const SQL_FN_TSI_MINUTE = &h00000004
const SQL_FN_TSI_HOUR = &h00000008
const SQL_FN_TSI_DAY = &h00000010
const SQL_FN_TSI_WEEK = &h00000020
const SQL_FN_TSI_MONTH = &h00000040
const SQL_FN_TSI_QUARTER = &h00000080
const SQL_FN_TSI_YEAR = &h00000100
const SQL_CA1_NEXT = &h00000001
const SQL_CA1_ABSOLUTE = &h00000002
const SQL_CA1_RELATIVE = &h00000004
const SQL_CA1_BOOKMARK = &h00000008
const SQL_CA1_LOCK_NO_CHANGE = &h00000040
const SQL_CA1_LOCK_EXCLUSIVE = &h00000080
const SQL_CA1_LOCK_UNLOCK = &h00000100
const SQL_CA1_POS_POSITION = &h00000200
const SQL_CA1_POS_UPDATE = &h00000400
const SQL_CA1_POS_DELETE = &h00000800
const SQL_CA1_POS_REFRESH = &h00001000
const SQL_CA1_POSITIONED_UPDATE = &h00002000
const SQL_CA1_POSITIONED_DELETE = &h00004000
const SQL_CA1_SELECT_FOR_UPDATE = &h00008000
const SQL_CA1_BULK_ADD = &h00010000
const SQL_CA1_BULK_UPDATE_BY_BOOKMARK = &h00020000
const SQL_CA1_BULK_DELETE_BY_BOOKMARK = &h00040000
const SQL_CA1_BULK_FETCH_BY_BOOKMARK = &h00080000
const SQL_CA2_READ_ONLY_CONCURRENCY = &h00000001
const SQL_CA2_LOCK_CONCURRENCY = &h00000002
const SQL_CA2_OPT_ROWVER_CONCURRENCY = &h00000004
const SQL_CA2_OPT_VALUES_CONCURRENCY = &h00000008
const SQL_CA2_SENSITIVITY_ADDITIONS = &h00000010
const SQL_CA2_SENSITIVITY_DELETIONS = &h00000020
const SQL_CA2_SENSITIVITY_UPDATES = &h00000040
const SQL_CA2_MAX_ROWS_SELECT = &h00000080
const SQL_CA2_MAX_ROWS_INSERT = &h00000100
const SQL_CA2_MAX_ROWS_DELETE = &h00000200
const SQL_CA2_MAX_ROWS_UPDATE = &h00000400
const SQL_CA2_MAX_ROWS_CATALOG = &h00000800
const SQL_CA2_MAX_ROWS_AFFECTS_ALL = (((SQL_CA2_MAX_ROWS_SELECT or SQL_CA2_MAX_ROWS_INSERT) or SQL_CA2_MAX_ROWS_DELETE) or SQL_CA2_MAX_ROWS_UPDATE) or SQL_CA2_MAX_ROWS_CATALOG
const SQL_CA2_CRC_EXACT = &h00001000
const SQL_CA2_CRC_APPROXIMATE = &h00002000
const SQL_CA2_SIMULATE_NON_UNIQUE = &h00004000
const SQL_CA2_SIMULATE_TRY_UNIQUE = &h00008000
const SQL_CA2_SIMULATE_UNIQUE = &h00010000
const SQL_OAC_NONE = &h0000
const SQL_OAC_LEVEL1 = &h0001
const SQL_OAC_LEVEL2 = &h0002
const SQL_OSCC_NOT_COMPLIANT = &h0000
const SQL_OSCC_COMPLIANT = &h0001
const SQL_OSC_MINIMUM = &h0000
const SQL_OSC_CORE = &h0001
const SQL_OSC_EXTENDED = &h0002
const SQL_CB_NULL = &h0000
const SQL_CB_NON_NULL = &h0001
const SQL_SO_FORWARD_ONLY = &h00000001
const SQL_SO_KEYSET_DRIVEN = &h00000002
const SQL_SO_DYNAMIC = &h00000004
const SQL_SO_MIXED = &h00000008
const SQL_SO_STATIC = &h00000010
const SQL_FD_FETCH_BOOKMARK = &h00000080
const SQL_CN_NONE = &h0000
const SQL_CN_DIFFERENT = &h0001
const SQL_CN_ANY = &h0002
const SQL_NNC_NULL = &h0000
const SQL_NNC_NON_NULL = &h0001
const SQL_NC_START = &h0002
const SQL_NC_END = &h0004
const SQL_FILE_NOT_SUPPORTED = &h0000
const SQL_FILE_TABLE = &h0001
const SQL_FILE_QUALIFIER = &h0002
const SQL_FILE_CATALOG = SQL_FILE_QUALIFIER
const SQL_GD_BLOCK = &h00000004
const SQL_GD_BOUND = &h00000008
const SQL_PS_POSITIONED_DELETE = &h00000001
const SQL_PS_POSITIONED_UPDATE = &h00000002
const SQL_PS_SELECT_FOR_UPDATE = &h00000004
const SQL_GB_NOT_SUPPORTED = &h0000
const SQL_GB_GROUP_BY_EQUALS_SELECT = &h0001
const SQL_GB_GROUP_BY_CONTAINS_SELECT = &h0002
const SQL_GB_NO_RELATION = &h0003
const SQL_GB_COLLATE = &h0004
const SQL_OU_DML_STATEMENTS = &h00000001
const SQL_OU_PROCEDURE_INVOCATION = &h00000002
const SQL_OU_TABLE_DEFINITION = &h00000004
const SQL_OU_INDEX_DEFINITION = &h00000008
const SQL_OU_PRIVILEGE_DEFINITION = &h00000010
const SQL_SU_DML_STATEMENTS = SQL_OU_DML_STATEMENTS
const SQL_SU_PROCEDURE_INVOCATION = SQL_OU_PROCEDURE_INVOCATION
const SQL_SU_TABLE_DEFINITION = SQL_OU_TABLE_DEFINITION
const SQL_SU_INDEX_DEFINITION = SQL_OU_INDEX_DEFINITION
const SQL_SU_PRIVILEGE_DEFINITION = SQL_OU_PRIVILEGE_DEFINITION
const SQL_QU_DML_STATEMENTS = &h00000001
const SQL_QU_PROCEDURE_INVOCATION = &h00000002
const SQL_QU_TABLE_DEFINITION = &h00000004
const SQL_QU_INDEX_DEFINITION = &h00000008
const SQL_QU_PRIVILEGE_DEFINITION = &h00000010
const SQL_CU_DML_STATEMENTS = SQL_QU_DML_STATEMENTS
const SQL_CU_PROCEDURE_INVOCATION = SQL_QU_PROCEDURE_INVOCATION
const SQL_CU_TABLE_DEFINITION = SQL_QU_TABLE_DEFINITION
const SQL_CU_INDEX_DEFINITION = SQL_QU_INDEX_DEFINITION
const SQL_CU_PRIVILEGE_DEFINITION = SQL_QU_PRIVILEGE_DEFINITION
const SQL_SQ_COMPARISON = &h00000001
const SQL_SQ_EXISTS = &h00000002
const SQL_SQ_IN = &h00000004
const SQL_SQ_QUANTIFIED = &h00000008
const SQL_SQ_CORRELATED_SUBQUERIES = &h00000010
const SQL_U_UNION = &h00000001
const SQL_U_UNION_ALL = &h00000002
const SQL_BP_CLOSE = &h00000001
const SQL_BP_DELETE = &h00000002
const SQL_BP_DROP = &h00000004
const SQL_BP_TRANSACTION = &h00000008
const SQL_BP_UPDATE = &h00000010
const SQL_BP_OTHER_HSTMT = &h00000020
const SQL_BP_SCROLL = &h00000040
const SQL_SS_ADDITIONS = &h00000001
const SQL_SS_DELETIONS = &h00000002
const SQL_SS_UPDATES = &h00000004
const SQL_CV_CREATE_VIEW = &h00000001
const SQL_CV_CHECK_OPTION = &h00000002
const SQL_CV_CASCADED = &h00000004
const SQL_CV_LOCAL = &h00000008
const SQL_LCK_NO_CHANGE = &h00000001
const SQL_LCK_EXCLUSIVE = &h00000002
const SQL_LCK_UNLOCK = &h00000004
const SQL_POS_POSITION = &h00000001
const SQL_POS_REFRESH = &h00000002
const SQL_POS_UPDATE = &h00000004
const SQL_POS_DELETE = &h00000008
const SQL_POS_ADD = &h00000010
const SQL_QL_START = &h0001
const SQL_QL_END = &h0002
const SQL_AF_AVG = &h00000001
const SQL_AF_COUNT = &h00000002
const SQL_AF_MAX = &h00000004
const SQL_AF_MIN = &h00000008
const SQL_AF_SUM = &h00000010
const SQL_AF_DISTINCT = &h00000020
const SQL_AF_ALL = &h00000040
const SQL_SC_SQL92_ENTRY = &h00000001
const SQL_SC_FIPS127_2_TRANSITIONAL = &h00000002
const SQL_SC_SQL92_INTERMEDIATE = &h00000004
const SQL_SC_SQL92_FULL = &h00000008
const SQL_DL_SQL92_DATE = &h00000001
const SQL_DL_SQL92_TIME = &h00000002
const SQL_DL_SQL92_TIMESTAMP = &h00000004
const SQL_DL_SQL92_INTERVAL_YEAR = &h00000008
const SQL_DL_SQL92_INTERVAL_MONTH = &h00000010
const SQL_DL_SQL92_INTERVAL_DAY = &h00000020
const SQL_DL_SQL92_INTERVAL_HOUR = &h00000040
const SQL_DL_SQL92_INTERVAL_MINUTE = &h00000080
const SQL_DL_SQL92_INTERVAL_SECOND = &h00000100
const SQL_DL_SQL92_INTERVAL_YEAR_TO_MONTH = &h00000200
const SQL_DL_SQL92_INTERVAL_DAY_TO_HOUR = &h00000400
const SQL_DL_SQL92_INTERVAL_DAY_TO_MINUTE = &h00000800
const SQL_DL_SQL92_INTERVAL_DAY_TO_SECOND = &h00001000
const SQL_DL_SQL92_INTERVAL_HOUR_TO_MINUTE = &h00002000
const SQL_DL_SQL92_INTERVAL_HOUR_TO_SECOND = &h00004000
const SQL_DL_SQL92_INTERVAL_MINUTE_TO_SECOND = &h00008000
const SQL_CL_START = SQL_QL_START
const SQL_CL_END = SQL_QL_END
const SQL_BRC_PROCEDURES = &h0000001
const SQL_BRC_EXPLICIT = &h0000002
const SQL_BRC_ROLLED_UP = &h0000004
const SQL_BS_SELECT_EXPLICIT = &h00000001
const SQL_BS_ROW_COUNT_EXPLICIT = &h00000002
const SQL_BS_SELECT_PROC = &h00000004
const SQL_BS_ROW_COUNT_PROC = &h00000008
const SQL_PARC_BATCH = 1
const SQL_PARC_NO_BATCH = 2
const SQL_PAS_BATCH = 1
const SQL_PAS_NO_BATCH = 2
const SQL_PAS_NO_SELECT = 3
const SQL_IK_NONE = &h00000000
const SQL_IK_ASC = &h00000001
const SQL_IK_DESC = &h00000002
const SQL_IK_ALL = SQL_IK_ASC or SQL_IK_DESC
const SQL_ISV_ASSERTIONS = &h00000001
const SQL_ISV_CHARACTER_SETS = &h00000002
const SQL_ISV_CHECK_CONSTRAINTS = &h00000004
const SQL_ISV_COLLATIONS = &h00000008
const SQL_ISV_COLUMN_DOMAIN_USAGE = &h00000010
const SQL_ISV_COLUMN_PRIVILEGES = &h00000020
const SQL_ISV_COLUMNS = &h00000040
const SQL_ISV_CONSTRAINT_COLUMN_USAGE = &h00000080
const SQL_ISV_CONSTRAINT_TABLE_USAGE = &h00000100
const SQL_ISV_DOMAIN_CONSTRAINTS = &h00000200
const SQL_ISV_DOMAINS = &h00000400
const SQL_ISV_KEY_COLUMN_USAGE = &h00000800
const SQL_ISV_REFERENTIAL_CONSTRAINTS = &h00001000
const SQL_ISV_SCHEMATA = &h00002000
const SQL_ISV_SQL_LANGUAGES = &h00004000
const SQL_ISV_TABLE_CONSTRAINTS = &h00008000
const SQL_ISV_TABLE_PRIVILEGES = &h00010000
const SQL_ISV_TABLES = &h00020000
const SQL_ISV_TRANSLATIONS = &h00040000
const SQL_ISV_USAGE_PRIVILEGES = &h00080000
const SQL_ISV_VIEW_COLUMN_USAGE = &h00100000
const SQL_ISV_VIEW_TABLE_USAGE = &h00200000
const SQL_ISV_VIEWS = &h00400000
const SQL_AM_NONE = 0
const SQL_AM_CONNECTION = 1
const SQL_AM_STATEMENT = 2
const SQL_AD_CONSTRAINT_NAME_DEFINITION = &h00000001
const SQL_AD_ADD_DOMAIN_CONSTRAINT = &h00000002
const SQL_AD_DROP_DOMAIN_CONSTRAINT = &h00000004
const SQL_AD_ADD_DOMAIN_DEFAULT = &h00000008
const SQL_AD_DROP_DOMAIN_DEFAULT = &h00000010
const SQL_AD_ADD_CONSTRAINT_INITIALLY_DEFERRED = &h00000020
const SQL_AD_ADD_CONSTRAINT_INITIALLY_IMMEDIATE = &h00000040
const SQL_AD_ADD_CONSTRAINT_DEFERRABLE = &h00000080
const SQL_AD_ADD_CONSTRAINT_NON_DEFERRABLE = &h00000100
const SQL_CS_CREATE_SCHEMA = &h00000001
const SQL_CS_AUTHORIZATION = &h00000002
const SQL_CS_DEFAULT_CHARACTER_SET = &h00000004
const SQL_CTR_CREATE_TRANSLATION = &h00000001
const SQL_CA_CREATE_ASSERTION = &h00000001
const SQL_CA_CONSTRAINT_INITIALLY_DEFERRED = &h00000010
const SQL_CA_CONSTRAINT_INITIALLY_IMMEDIATE = &h00000020
const SQL_CA_CONSTRAINT_DEFERRABLE = &h00000040
const SQL_CA_CONSTRAINT_NON_DEFERRABLE = &h00000080
const SQL_CCS_CREATE_CHARACTER_SET = &h00000001
const SQL_CCS_COLLATE_CLAUSE = &h00000002
const SQL_CCS_LIMITED_COLLATION = &h00000004
const SQL_CCOL_CREATE_COLLATION = &h00000001
const SQL_CDO_CREATE_DOMAIN = &h00000001
const SQL_CDO_DEFAULT = &h00000002
const SQL_CDO_CONSTRAINT = &h00000004
const SQL_CDO_COLLATION = &h00000008
const SQL_CDO_CONSTRAINT_NAME_DEFINITION = &h00000010
const SQL_CDO_CONSTRAINT_INITIALLY_DEFERRED = &h00000020
const SQL_CDO_CONSTRAINT_INITIALLY_IMMEDIATE = &h00000040
const SQL_CDO_CONSTRAINT_DEFERRABLE = &h00000080
const SQL_CDO_CONSTRAINT_NON_DEFERRABLE = &h00000100
const SQL_CT_CREATE_TABLE = &h00000001
const SQL_CT_COMMIT_PRESERVE = &h00000002
const SQL_CT_COMMIT_DELETE = &h00000004
const SQL_CT_GLOBAL_TEMPORARY = &h00000008
const SQL_CT_LOCAL_TEMPORARY = &h00000010
const SQL_CT_CONSTRAINT_INITIALLY_DEFERRED = &h00000020
const SQL_CT_CONSTRAINT_INITIALLY_IMMEDIATE = &h00000040
const SQL_CT_CONSTRAINT_DEFERRABLE = &h00000080
const SQL_CT_CONSTRAINT_NON_DEFERRABLE = &h00000100
const SQL_CT_COLUMN_CONSTRAINT = &h00000200
const SQL_CT_COLUMN_DEFAULT = &h00000400
const SQL_CT_COLUMN_COLLATION = &h00000800
const SQL_CT_TABLE_CONSTRAINT = &h00001000
const SQL_CT_CONSTRAINT_NAME_DEFINITION = &h00002000
const SQL_DI_CREATE_INDEX = &h00000001
const SQL_DI_DROP_INDEX = &h00000002
const SQL_DC_DROP_COLLATION = &h00000001
const SQL_DD_DROP_DOMAIN = &h00000001
const SQL_DD_RESTRICT = &h00000002
const SQL_DD_CASCADE = &h00000004
const SQL_DS_DROP_SCHEMA = &h00000001
const SQL_DS_RESTRICT = &h00000002
const SQL_DS_CASCADE = &h00000004
const SQL_DCS_DROP_CHARACTER_SET = &h00000001
const SQL_DA_DROP_ASSERTION = &h00000001
const SQL_DT_DROP_TABLE = &h00000001
const SQL_DT_RESTRICT = &h00000002
const SQL_DT_CASCADE = &h00000004
const SQL_DTR_DROP_TRANSLATION = &h00000001
const SQL_DV_DROP_VIEW = &h00000001
const SQL_DV_RESTRICT = &h00000002
const SQL_DV_CASCADE = &h00000004
const SQL_IS_INSERT_LITERALS = &h00000001
const SQL_IS_INSERT_SEARCHED = &h00000002
const SQL_IS_SELECT_INTO = &h00000004
const SQL_OIC_CORE = 1u
const SQL_OIC_LEVEL1 = 2u
const SQL_OIC_LEVEL2 = 3u
const SQL_SFKD_CASCADE = &h00000001
const SQL_SFKD_NO_ACTION = &h00000002
const SQL_SFKD_SET_DEFAULT = &h00000004
const SQL_SFKD_SET_NULL = &h00000008
const SQL_SFKU_CASCADE = &h00000001
const SQL_SFKU_NO_ACTION = &h00000002
const SQL_SFKU_SET_DEFAULT = &h00000004
const SQL_SFKU_SET_NULL = &h00000008
const SQL_SG_USAGE_ON_DOMAIN = &h00000001
const SQL_SG_USAGE_ON_CHARACTER_SET = &h00000002
const SQL_SG_USAGE_ON_COLLATION = &h00000004
const SQL_SG_USAGE_ON_TRANSLATION = &h00000008
const SQL_SG_WITH_GRANT_OPTION = &h00000010
const SQL_SG_DELETE_TABLE = &h00000020
const SQL_SG_INSERT_TABLE = &h00000040
const SQL_SG_INSERT_COLUMN = &h00000080
const SQL_SG_REFERENCES_TABLE = &h00000100
const SQL_SG_REFERENCES_COLUMN = &h00000200
const SQL_SG_SELECT_TABLE = &h00000400
const SQL_SG_UPDATE_TABLE = &h00000800
const SQL_SG_UPDATE_COLUMN = &h00001000
const SQL_SP_EXISTS = &h00000001
const SQL_SP_ISNOTNULL = &h00000002
const SQL_SP_ISNULL = &h00000004
const SQL_SP_MATCH_FULL = &h00000008
const SQL_SP_MATCH_PARTIAL = &h00000010
const SQL_SP_MATCH_UNIQUE_FULL = &h00000020
const SQL_SP_MATCH_UNIQUE_PARTIAL = &h00000040
const SQL_SP_OVERLAPS = &h00000080
const SQL_SP_UNIQUE = &h00000100
const SQL_SP_LIKE = &h00000200
const SQL_SP_IN = &h00000400
const SQL_SP_BETWEEN = &h00000800
const SQL_SP_COMPARISON = &h00001000
const SQL_SP_QUANTIFIED_COMPARISON = &h00002000
const SQL_SRJO_CORRESPONDING_CLAUSE = &h00000001
const SQL_SRJO_CROSS_JOIN = &h00000002
const SQL_SRJO_EXCEPT_JOIN = &h00000004
const SQL_SRJO_FULL_OUTER_JOIN = &h00000008
const SQL_SRJO_INNER_JOIN = &h00000010
const SQL_SRJO_INTERSECT_JOIN = &h00000020
const SQL_SRJO_LEFT_OUTER_JOIN = &h00000040
const SQL_SRJO_NATURAL_JOIN = &h00000080
const SQL_SRJO_RIGHT_OUTER_JOIN = &h00000100
const SQL_SRJO_UNION_JOIN = &h00000200
const SQL_SR_USAGE_ON_DOMAIN = &h00000001
const SQL_SR_USAGE_ON_CHARACTER_SET = &h00000002
const SQL_SR_USAGE_ON_COLLATION = &h00000004
const SQL_SR_USAGE_ON_TRANSLATION = &h00000008
const SQL_SR_GRANT_OPTION_FOR = &h00000010
const SQL_SR_CASCADE = &h00000020
const SQL_SR_RESTRICT = &h00000040
const SQL_SR_DELETE_TABLE = &h00000080
const SQL_SR_INSERT_TABLE = &h00000100
const SQL_SR_INSERT_COLUMN = &h00000200
const SQL_SR_REFERENCES_TABLE = &h00000400
const SQL_SR_REFERENCES_COLUMN = &h00000800
const SQL_SR_SELECT_TABLE = &h00001000
const SQL_SR_UPDATE_TABLE = &h00002000
const SQL_SR_UPDATE_COLUMN = &h00004000
const SQL_SRVC_VALUE_EXPRESSION = &h00000001
const SQL_SRVC_NULL = &h00000002
const SQL_SRVC_DEFAULT = &h00000004
const SQL_SRVC_ROW_SUBQUERY = &h00000008
const SQL_SVE_CASE = &h00000001
const SQL_SVE_CAST = &h00000002
const SQL_SVE_COALESCE = &h00000004
const SQL_SVE_NULLIF = &h00000008
const SQL_SCC_XOPEN_CLI_VERSION1 = &h00000001
const SQL_SCC_ISO92_CLI = &h00000002
const SQL_US_UNION = SQL_U_UNION
const SQL_US_UNION_ALL = SQL_U_UNION_ALL
const SQL_DTC_ENLIST_EXPENSIVE = &h00000001
const SQL_DTC_UNENLIST_EXPENSIVE = &h00000002
const SQL_FETCH_FIRST_USER = 31
const SQL_FETCH_FIRST_SYSTEM = 32
const SQL_ENTIRE_ROWSET = 0
const SQL_POSITION = 0
const SQL_REFRESH = 1
const SQL_UPDATE = 2
const SQL_DELETE = 3
const SQL_ADD = 4
const SQL_SETPOS_MAX_OPTION_VALUE = SQL_ADD
const SQL_UPDATE_BY_BOOKMARK = 5
const SQL_DELETE_BY_BOOKMARK = 6
const SQL_FETCH_BY_BOOKMARK = 7
const SQL_LOCK_NO_CHANGE = 0
const SQL_LOCK_EXCLUSIVE = 1
const SQL_LOCK_UNLOCK = 2
const SQL_SETPOS_MAX_LOCK_VALUE = SQL_LOCK_UNLOCK
#define SQL_POSITION_TO(hstmt, irow) SQLSetPos(hstmt, irow, SQL_POSITION, SQL_LOCK_NO_CHANGE)
#define SQL_LOCK_RECORD(hstmt, irow, fLock) SQLSetPos(hstmt, irow, SQL_POSITION, fLock)
#define SQL_REFRESH_RECORD(hstmt, irow, fLock) SQLSetPos(hstmt, irow, SQL_REFRESH, fLock)
#define SQL_UPDATE_RECORD(hstmt, irow) SQLSetPos(hstmt, irow, SQL_UPDATE, SQL_LOCK_NO_CHANGE)
#define SQL_DELETE_RECORD(hstmt, irow) SQLSetPos(hstmt, irow, SQL_DELETE, SQL_LOCK_NO_CHANGE)
#define SQL_ADD_RECORD(hstmt, irow) SQLSetPos(hstmt, irow, SQL_ADD, SQL_LOCK_NO_CHANGE)
const SQL_BEST_ROWID = 1
const SQL_ROWVER = 2
const SQL_PC_NOT_PSEUDO = 1
const SQL_QUICK = 0
const SQL_ENSURE = 1
const SQL_TABLE_STAT = 0
#define SQL_ALL_CATALOGS "%"
#define SQL_ALL_SCHEMAS "%"
#define SQL_ALL_TABLE_TYPES "%"
const SQL_DRIVER_NOPROMPT = 0
const SQL_DRIVER_COMPLETE = 1
const SQL_DRIVER_PROMPT = 2
const SQL_DRIVER_COMPLETE_REQUIRED = 3
#ifndef UNICODE
declare function SQLDriverConnect(byval hdbc as SQLHDBC, byval hwnd as SQLHWND, byval szConnStrIn as zstring ptr, byval cbConnStrIn as SQLSMALLINT, byval szConnStrOut as zstring ptr, byval cbConnStrOutMax as SQLSMALLINT, byval pcbConnStrOut as SQLSMALLINT ptr, byval fDriverCompletion as SQLUSMALLINT) as SQLRETURN
#endif
const SQL_FETCH_BOOKMARK = 8
const SQL_ROW_SUCCESS = 0
const SQL_ROW_DELETED = 1
const SQL_ROW_UPDATED = 2
const SQL_ROW_NOROW = 3
const SQL_ROW_ADDED = 4
const SQL_ROW_ERROR = 5
const SQL_ROW_SUCCESS_WITH_INFO = 6
const SQL_ROW_PROCEED = 0
const SQL_ROW_IGNORE = 1
const SQL_PARAM_SUCCESS = 0
const SQL_PARAM_SUCCESS_WITH_INFO = 6
const SQL_PARAM_ERROR = 5
const SQL_PARAM_UNUSED = 7
const SQL_PARAM_DIAG_UNAVAILABLE = 1
const SQL_PARAM_PROCEED = 0
const SQL_PARAM_IGNORE = 1
const SQL_CASCADE = 0
const SQL_RESTRICT = 1
const SQL_SET_NULL = 2
const SQL_NO_ACTION = 3
const SQL_SET_DEFAULT = 4
const SQL_INITIALLY_DEFERRED = 5
const SQL_INITIALLY_IMMEDIATE = 6
const SQL_NOT_DEFERRABLE = 7
const SQL_PARAM_TYPE_UNKNOWN = 0
const SQL_PARAM_INPUT = 1
const SQL_PARAM_INPUT_OUTPUT = 2
const SQL_PARAM_TYPE_DEFAULT = SQL_PARAM_INPUT_OUTPUT
const SQL_RESULT_COL = 3
const SQL_PARAM_OUTPUT = 4
const SQL_RETURN_VALUE = 5
const SQL_PT_UNKNOWN = 0
const SQL_PT_PROCEDURE = 1
const SQL_PT_FUNCTION = 2
#define SQL_ODBC_KEYWORDS "ABSOLUTE,ACTION,ADA,ADD,ALL,ALLOCATE,ALTER,AND,ANY,ARE,AS," "ASC,ASSERTION,AT,AUTHORIZATION,AVG," "BEGIN,BETWEEN,BIT,BIT_LENGTH,BOTH,BY,CASCADE,CASCADED,CASE,CAST,CATALOG," "CHAR,CHAR_LENGTH,CHARACTER,CHARACTER_LENGTH,CHECK,CLOSE,COALESCE," "COLLATE,COLLATION,COLUMN,COMMIT,CONNECT,CONNECTION,CONSTRAINT," "CONSTRAINTS,CONTINUE,CONVERT,CORRESPONDING,COUNT,CREATE,CROSS,CURRENT," "CURRENT_DATE,CURRENT_TIME,CURRENT_TIMESTAMP,CURRENT_USER,CURSOR," "DATE,DAY,DEALLOCATE,DEC,DECIMAL,DECLARE,DEFAULT,DEFERRABLE," "DEFERRED,DELETE,DESC,DESCRIBE,DESCRIPTOR,DIAGNOSTICS,DISCONNECT," "DISTINCT,DOMAIN,DOUBLE,DROP," "ELSE,END,END-EXEC,ESCAPE,EXCEPT,EXCEPTION,EXEC,EXECUTE," "EXISTS,EXTERNAL,EXTRACT," "FALSE,FETCH,FIRST,FLOAT,FOR,FOREIGN,FORTRAN,FOUND,FROM,FULL," "GET,GLOBAL,GO,GOTO,GRANT,GROUP,HAVING,HOUR," "IDENTITY,IMMEDIATE,IN,INCLUDE,INDEX,INDICATOR,INITIALLY,INNER," "INPUT,INSENSITIVE,INSERT,INT,INTEGER,INTERSECT,INTERVAL,INTO,IS,ISOLATION," "JOIN,KEY,LANGUAGE,LAST,LEADING,LEFT,LEVEL,LIKE,LOCAL,LOWER," "MATCH,MAX,MIN,MINUTE,MODULE,MONTH," "NAMES,NATIONAL,NATURAL,NCHAR,NEXT,NO,NONE,NOT,NULL,NULLIF,NUMERIC," "OCTET_LENGTH,OF,ON,ONLY,OPEN,OPTION,OR,ORDER,OUTER,OUTPUT,OVERLAPS," "PAD,PARTIAL,PASCAL,PLI,POSITION,PRECISION,PREPARE,PRESERVE," "PRIMARY,PRIOR,PRIVILEGES,PROCEDURE,PUBLIC," "READ,REAL,REFERENCES,RELATIVE,RESTRICT,REVOKE,RIGHT,ROLLBACK,ROWS" "SCHEMA,SCROLL,SECOND,SECTION,SELECT,SESSION,SESSION_USER,SET,SIZE," "SMALLINT,SOME,SPACE,SQL,SQLCA,SQLCODE,SQLERROR,SQLSTATE,SQLWARNING," "SUBSTRING,SUM,SYSTEM_USER," "TABLE,TEMPORARY,THEN,TIME,TIMESTAMP,TIMEZONE_HOUR,TIMEZONE_MINUTE," "TO,TRAILING,TRANSACTION,TRANSLATE,TRANSLATION,TRIM,TRUE," "UNION,UNIQUE,UNKNOWN,UPDATE,UPPER,USAGE,USER,USING," "VALUE,VALUES,VARCHAR,VARYING,VIEW,WHEN,WHENEVER,WHERE,WITH,WORK,WRITE," "YEAR,ZONE"

#ifndef UNICODE
declare function SQLBrowseConnect(byval hdbc as SQLHDBC, byval szConnStrIn as zstring ptr, byval cbConnStrIn as SQLSMALLINT, byval szConnStrOut as zstring ptr, byval cbConnStrOutMax as SQLSMALLINT, byval pcbConnStrOut as SQLSMALLINT ptr) as SQLRETURN
#endif
declare function SQLBulkOperations(byval StatementHandle as SQLHSTMT, byval Operation as SQLSMALLINT) as SQLRETURN

#ifndef UNICODE
#ifdef __FB_64BIT__
	declare function SQLColAttributes(byval hstmt as SQLHSTMT, byval icol as SQLUSMALLINT, byval fDescType as SQLUSMALLINT, byval rgbDesc as SQLPOINTER, byval cbDescMax as SQLSMALLINT, byval pcbDesc as SQLSMALLINT ptr, byval pfDesc as SQLLEN ptr) as SQLRETURN
#else
	declare function SQLColAttributes(byval hstmt as SQLHSTMT, byval icol as SQLUSMALLINT, byval fDescType as SQLUSMALLINT, byval rgbDesc as SQLPOINTER, byval cbDescMax as SQLSMALLINT, byval pcbDesc as SQLSMALLINT ptr, byval pfDesc as SQLINTEGER ptr) as SQLRETURN
#endif
declare function SQLColumnPrivileges(byval hstmt as SQLHSTMT, byval szCatalogName as zstring ptr, byval cbCatalogName as SQLSMALLINT, byval szSchemaName as zstring ptr, byval cbSchemaName as SQLSMALLINT, byval szTableName as zstring ptr, byval cbTableName as SQLSMALLINT, byval szColumnName as zstring ptr, byval cbColumnName as SQLSMALLINT) as SQLRETURN
#endif

#ifdef __FB_64BIT__
	declare function SQLDescribeParam(byval hstmt as SQLHSTMT, byval ipar as SQLUSMALLINT, byval pfSqlType as SQLSMALLINT ptr, byval pcbParamDef as SQLULEN ptr, byval pibScale as SQLSMALLINT ptr, byval pfNullable as SQLSMALLINT ptr) as SQLRETURN
	declare function SQLExtendedFetch(byval hstmt as SQLHSTMT, byval fFetchType as SQLUSMALLINT, byval irow as SQLLEN, byval pcrow as SQLULEN ptr, byval rgfRowStatus as SQLUSMALLINT ptr) as SQLRETURN
#else
	declare function SQLDescribeParam(byval hstmt as SQLHSTMT, byval ipar as SQLUSMALLINT, byval pfSqlType as SQLSMALLINT ptr, byval pcbParamDef as SQLUINTEGER ptr, byval pibScale as SQLSMALLINT ptr, byval pfNullable as SQLSMALLINT ptr) as SQLRETURN
	declare function SQLExtendedFetch(byval hstmt as SQLHSTMT, byval fFetchType as SQLUSMALLINT, byval irow as SQLINTEGER, byval pcrow as SQLUINTEGER ptr, byval rgfRowStatus as SQLUSMALLINT ptr) as SQLRETURN
#endif

#ifndef UNICODE
declare function SQLForeignKeys(byval hstmt as SQLHSTMT, byval szPkCatalogName as zstring ptr, byval cbPkCatalogName as SQLSMALLINT, byval szPkSchemaName as zstring ptr, byval cbPkSchemaName as SQLSMALLINT, byval szPkTableName as zstring ptr, byval cbPkTableName as SQLSMALLINT, byval szFkCatalogName as zstring ptr, byval cbFkCatalogName as SQLSMALLINT, byval szFkSchemaName as zstring ptr, byval cbFkSchemaName as SQLSMALLINT, byval szFkTableName as zstring ptr, byval cbFkTableName as SQLSMALLINT) as SQLRETURN
#endif
declare function SQLMoreResults(byval hstmt as SQLHSTMT) as SQLRETURN
#ifndef UNICODE
declare function SQLNativeSql(byval hdbc as SQLHDBC, byval szSqlStrIn as zstring ptr, byval cbSqlStrIn as SQLINTEGER, byval szSqlStr as zstring ptr, byval cbSqlStrMax as SQLINTEGER, byval pcbSqlStr as SQLINTEGER ptr) as SQLRETURN
#endif
declare function SQLNumParams(byval hstmt as SQLHSTMT, byval pcpar as SQLSMALLINT ptr) as SQLRETURN

#ifdef __FB_64BIT__
	declare function SQLParamOptions(byval hstmt as SQLHSTMT, byval crow as SQLULEN, byval pirow as SQLULEN ptr) as SQLRETURN
#else
	declare function SQLParamOptions(byval hstmt as SQLHSTMT, byval crow as SQLUINTEGER, byval pirow as SQLUINTEGER ptr) as SQLRETURN
#endif

#ifndef UNICODE
declare function SQLPrimaryKeys(byval hstmt as SQLHSTMT, byval szCatalogName as zstring ptr, byval cbCatalogName as SQLSMALLINT, byval szSchemaName as zstring ptr, byval cbSchemaName as SQLSMALLINT, byval szTableName as zstring ptr, byval cbTableName as SQLSMALLINT) as SQLRETURN
declare function SQLProcedureColumns(byval hstmt as SQLHSTMT, byval szCatalogName as zstring ptr, byval cbCatalogName as SQLSMALLINT, byval szSchemaName as zstring ptr, byval cbSchemaName as SQLSMALLINT, byval szProcName as zstring ptr, byval cbProcName as SQLSMALLINT, byval szColumnName as zstring ptr, byval cbColumnName as SQLSMALLINT) as SQLRETURN
declare function SQLProcedures(byval hstmt as SQLHSTMT, byval szCatalogName as zstring ptr, byval cbCatalogName as SQLSMALLINT, byval szSchemaName as zstring ptr, byval cbSchemaName as SQLSMALLINT, byval szProcName as zstring ptr, byval cbProcName as SQLSMALLINT) as SQLRETURN
#endif

#ifdef __FB_64BIT__
	declare function SQLSetPos(byval hstmt as SQLHSTMT, byval irow as SQLSETPOSIROW, byval fOption as SQLUSMALLINT, byval fLock as SQLUSMALLINT) as SQLRETURN
#else
	declare function SQLSetPos(byval hstmt as SQLHSTMT, byval irow as SQLUSMALLINT, byval fOption as SQLUSMALLINT, byval fLock as SQLUSMALLINT) as SQLRETURN
#endif

#ifndef UNICODE
declare function SQLTablePrivileges(byval hstmt as SQLHSTMT, byval szCatalogName as zstring ptr, byval cbCatalogName as SQLSMALLINT, byval szSchemaName as zstring ptr, byval cbSchemaName as SQLSMALLINT, byval szTableName as zstring ptr, byval cbTableName as SQLSMALLINT) as SQLRETURN
declare function SQLDrivers(byval henv as SQLHENV, byval fDirection as SQLUSMALLINT, byval szDriverDesc as zstring ptr, byval cbDriverDescMax as SQLSMALLINT, byval pcbDriverDesc as SQLSMALLINT ptr, byval szDriverAttributes as zstring ptr, byval cbDrvrAttrMax as SQLSMALLINT, byval pcbDrvrAttr as SQLSMALLINT ptr) as SQLRETURN
#endif

#ifdef __FB_64BIT__
	declare function SQLBindParameter(byval hstmt as SQLHSTMT, byval ipar as SQLUSMALLINT, byval fParamType as SQLSMALLINT, byval fCType as SQLSMALLINT, byval fSqlType as SQLSMALLINT, byval cbColDef as SQLULEN, byval ibScale as SQLSMALLINT, byval rgbValue as SQLPOINTER, byval cbValueMax as SQLLEN, byval pcbValue as SQLLEN ptr) as SQLRETURN
#else
	declare function SQLBindParameter(byval hstmt as SQLHSTMT, byval ipar as SQLUSMALLINT, byval fParamType as SQLSMALLINT, byval fCType as SQLSMALLINT, byval fSqlType as SQLSMALLINT, byval cbColDef as SQLUINTEGER, byval ibScale as SQLSMALLINT, byval rgbValue as SQLPOINTER, byval cbValueMax as SQLINTEGER, byval pcbValue as SQLINTEGER ptr) as SQLRETURN
#endif

declare function SQLAllocHandleStd(byval fHandleType as SQLSMALLINT, byval hInput as SQLHANDLE, byval phOutput as SQLHANDLE ptr) as SQLRETURN
const SQL_DATABASE_NAME = 16
const SQL_FD_FETCH_PREV = SQL_FD_FETCH_PRIOR
const SQL_FETCH_PREV = SQL_FETCH_PRIOR
const SQL_CONCUR_TIMESTAMP = SQL_CONCUR_ROWVER
const SQL_SCCO_OPT_TIMESTAMP = SQL_SCCO_OPT_ROWVER
const SQL_CC_DELETE = SQL_CB_DELETE
const SQL_CR_DELETE = SQL_CB_DELETE
const SQL_CC_CLOSE = SQL_CB_CLOSE
const SQL_CR_CLOSE = SQL_CB_CLOSE
const SQL_CC_PRESERVE = SQL_CB_PRESERVE
const SQL_CR_PRESERVE = SQL_CB_PRESERVE
const SQL_SCROLL_FORWARD_ONLY = 0
const SQL_SCROLL_KEYSET_DRIVEN = -1
const SQL_SCROLL_DYNAMIC = -2
const SQL_SCROLL_STATIC = -3

#ifdef __FB_64BIT__
	declare function SQLSetScrollOptions(byval hstmt as SQLHSTMT, byval fConcurrency as SQLUSMALLINT, byval crowKeyset as SQLLEN, byval crowRowset as SQLUSMALLINT) as SQLRETURN
#else
	declare function SQLSetScrollOptions(byval hstmt as SQLHSTMT, byval fConcurrency as SQLUSMALLINT, byval crowKeyset as SQLINTEGER, byval crowRowset as SQLUSMALLINT) as SQLRETURN
#endif

const TRACE_VERSION = 1000
declare function TraceOpenLogFile(byval as LPWSTR, byval as LPWSTR, byval as DWORD) as RETCODE
declare function TraceCloseLogFile() as RETCODE
declare sub TraceReturn(byval as RETCODE, byval as RETCODE)
declare function TraceVersion() as DWORD
const TRACE_ON = &h00000001
const TRACE_VS_EVENT_ON = &h00000002
declare function TraceVSControl(byval as DWORD) as RETCODE
declare function ODBCSetTryWaitValue(byval dwValue as DWORD) as WINBOOL
declare function ODBCGetTryWaitValue() as DWORD

const ODBC_VS_FLAG_UNICODE_ARG = &h00000001
const ODBC_VS_FLAG_UNICODE_COR = &h00000002
const ODBC_VS_FLAG_RETCODE = &h00000004
const ODBC_VS_FLAG_STOP = &h00000008

type tagODBC_VS_ARGS
	pguidEvent as const GUID ptr
	dwFlags as DWORD

	union
		wszArg as wstring ptr
		szArg as zstring ptr
	end union

	union
		wszCorrelation as wstring ptr
		szCorrelation as zstring ptr
	end union

	RetCode as RETCODE
end type

type ODBC_VS_ARGS as tagODBC_VS_ARGS
type PODBC_VS_ARGS as tagODBC_VS_ARGS ptr
declare sub FireVSDebugEvent(byval as PODBC_VS_ARGS)

end extern

#include once "sqlucode.bi"
