/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.epubcheck.ocf;

import com.adobe.epubcheck.ocf.OCFResource;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;

public interface OCFResources
extends Iterable<OCFResource> {
    public void close() throws IOException;

    public static String getSHAHash(InputStream inputStream) {
        try {
            int nread;
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            byte[] dataBytes = new byte[1024];
            while ((nread = inputStream.read(dataBytes)) != -1) {
                md.update(dataBytes, 0, nread);
            }
            byte[] bytes = md.digest();
            StringBuilder hexString = new StringBuilder();
            for (byte aByte : bytes) {
                hexString.append(Integer.toHexString(0xFF & aByte));
            }
            return hexString.toString();
        }
        catch (Exception e) {
            return "";
        }
    }
}

