/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.core.plugin;

import io.cucumber.core.plugin.Format;
import io.cucumber.core.plugin.Formats;
import io.cucumber.plugin.ColorAware;
import io.cucumber.plugin.ConcurrentEventListener;
import io.cucumber.plugin.event.EventPublisher;
import io.cucumber.plugin.event.PickleStepTestStep;
import io.cucumber.plugin.event.Result;
import io.cucumber.plugin.event.Status;
import io.cucumber.plugin.event.TestCase;
import io.cucumber.plugin.event.TestCaseFinished;
import io.cucumber.plugin.event.TestRunFinished;
import io.cucumber.plugin.event.TestRunStarted;
import io.cucumber.plugin.event.TestStepFinished;
import java.io.PrintStream;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.TimeUnit;

class Stats
implements ConcurrentEventListener,
ColorAware {
    private static final long ONE_SECOND = TimeUnit.SECONDS.toNanos(1L);
    private static final long ONE_MINUTE = 60L * ONE_SECOND;
    private final SubCounts scenarioSubCounts = new SubCounts();
    private final SubCounts stepSubCounts = new SubCounts();
    private final Locale locale;
    private final List<TestCase> failedScenarios = new ArrayList<TestCase>();
    private final List<TestCase> ambiguousScenarios = new ArrayList<TestCase>();
    private final List<TestCase> pendingScenarios = new ArrayList<TestCase>();
    private final List<TestCase> undefinedScenarios = new ArrayList<TestCase>();
    private final List<Throwable> errors = new ArrayList<Throwable>();
    private Instant startTime = Instant.EPOCH;
    private Duration totalDuration = Duration.ZERO;
    private Formats formats = Formats.ansi();

    Stats(Locale locale) {
        this.locale = locale;
    }

    public void setMonochrome(boolean monochrome) {
        this.formats = monochrome ? Formats.monochrome() : Formats.ansi();
    }

    public void setEventPublisher(EventPublisher publisher) {
        publisher.registerHandlerFor(TestRunStarted.class, this::setStartTime);
        publisher.registerHandlerFor(TestStepFinished.class, this::addStepResult);
        publisher.registerHandlerFor(TestCaseFinished.class, this::addScenario);
        publisher.registerHandlerFor(TestRunFinished.class, this::setFinishTime);
    }

    private void setStartTime(TestRunStarted event) {
        this.setStartTime(event.getInstant());
    }

    private void addStepResult(TestStepFinished event) {
        Result result = event.getResult();
        if (result.getError() != null) {
            this.addError(result.getError());
        }
        if (event.getTestStep() instanceof PickleStepTestStep) {
            this.addStep(result.getStatus());
        }
    }

    private void addScenario(TestCaseFinished event) {
        TestCase testCase = event.getTestCase();
        this.addScenario(event.getResult().getStatus(), testCase);
    }

    private void setFinishTime(TestRunFinished event) {
        this.setFinishTime(event.getInstant());
    }

    void setStartTime(Instant startTime) {
        this.startTime = startTime;
    }

    private void addError(Throwable error) {
        this.errors.add(error);
    }

    void addStep(Status resultStatus) {
        this.addResultToSubCount(this.stepSubCounts, resultStatus);
    }

    void addScenario(Status resultStatus, TestCase testCase) {
        this.addResultToSubCount(this.scenarioSubCounts, resultStatus);
        switch (resultStatus) {
            case FAILED: {
                this.failedScenarios.add(testCase);
                break;
            }
            case AMBIGUOUS: {
                this.ambiguousScenarios.add(testCase);
                break;
            }
            case PENDING: {
                this.pendingScenarios.add(testCase);
                break;
            }
            case UNDEFINED: {
                this.undefinedScenarios.add(testCase);
                break;
            }
        }
    }

    void setFinishTime(Instant finishTime) {
        this.totalDuration = Duration.between(this.startTime, finishTime);
    }

    private void addResultToSubCount(SubCounts subCounts, Status resultStatus) {
        switch (resultStatus) {
            case FAILED: {
                ++subCounts.failed;
                break;
            }
            case AMBIGUOUS: {
                ++subCounts.ambiguous;
                break;
            }
            case PENDING: {
                ++subCounts.pending;
                break;
            }
            case UNDEFINED: {
                ++subCounts.undefined;
                break;
            }
            case SKIPPED: {
                ++subCounts.skipped;
                break;
            }
            default: {
                ++subCounts.passed;
            }
        }
    }

    public List<Throwable> getErrors() {
        return this.errors;
    }

    void printStats(PrintStream out) {
        this.printNonZeroResultScenarios(out);
        if (this.stepSubCounts.getTotal() == 0) {
            out.println("0 Scenarios");
            out.println("0 Steps");
        } else {
            this.printScenarioCounts(out);
            this.printStepCounts(out);
        }
        this.printDuration(out);
    }

    private void printStepCounts(PrintStream out) {
        out.print(this.stepSubCounts.getTotal());
        out.print(" Steps (");
        this.printSubCounts(out, this.stepSubCounts);
        out.println(")");
    }

    private void printScenarioCounts(PrintStream out) {
        out.print(this.scenarioSubCounts.getTotal());
        out.print(" Scenarios (");
        this.printSubCounts(out, this.scenarioSubCounts);
        out.println(")");
    }

    private void printSubCounts(PrintStream out, SubCounts subCounts) {
        boolean addComma = false;
        addComma = this.printSubCount(out, subCounts.failed, Status.FAILED, addComma);
        addComma = this.printSubCount(out, subCounts.ambiguous, Status.AMBIGUOUS, addComma);
        addComma = this.printSubCount(out, subCounts.skipped, Status.SKIPPED, addComma);
        addComma = this.printSubCount(out, subCounts.pending, Status.PENDING, addComma);
        addComma = this.printSubCount(out, subCounts.undefined, Status.UNDEFINED, addComma);
        addComma = this.printSubCount(out, subCounts.passed, Status.PASSED, addComma);
    }

    private boolean printSubCount(PrintStream out, int count, Status type, boolean addComma) {
        if (count != 0) {
            if (addComma) {
                out.print(", ");
            }
            Format format = this.formats.get(type.name().toLowerCase(Locale.ROOT));
            out.print(format.text(count + " " + type.name().toLowerCase(Locale.ROOT)));
            addComma = true;
        }
        return addComma;
    }

    private void printDuration(PrintStream out) {
        out.print(String.format("%dm", this.totalDuration.toNanos() / ONE_MINUTE));
        DecimalFormat format = new DecimalFormat("0.000", new DecimalFormatSymbols(this.locale));
        out.println(format.format((double)(this.totalDuration.toNanos() % ONE_MINUTE) / (double)ONE_SECOND) + "s");
    }

    private void printNonZeroResultScenarios(PrintStream out) {
        this.printScenarios(out, this.failedScenarios, Status.FAILED);
        this.printScenarios(out, this.ambiguousScenarios, Status.AMBIGUOUS);
        this.printScenarios(out, this.pendingScenarios, Status.PENDING);
        this.printScenarios(out, this.undefinedScenarios, Status.UNDEFINED);
    }

    private void printScenarios(PrintStream out, List<TestCase> scenarios, Status type) {
        Format format = this.formats.get(type.name().toLowerCase(Locale.ROOT));
        if (!scenarios.isEmpty()) {
            out.println(format.text(this.firstLetterCapitalizedName(type) + " scenarios:"));
        }
        for (TestCase scenario : scenarios) {
            String location = scenario.getUri() + ":" + scenario.getLocation().getLine();
            out.println(location + " # " + scenario.getName());
        }
        if (!scenarios.isEmpty()) {
            out.println();
        }
    }

    private String firstLetterCapitalizedName(Status status) {
        String name = status.name();
        return name.substring(0, 1) + name.substring(1).toLowerCase(Locale.ROOT);
    }

    static class SubCounts {
        public int passed = 0;
        public int failed = 0;
        public int ambiguous = 0;
        public int skipped = 0;
        public int pending = 0;
        public int undefined = 0;

        SubCounts() {
        }

        int getTotal() {
            return this.passed + this.failed + this.ambiguous + this.skipped + this.pending + this.undefined;
        }
    }
}

