/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import java.text.Normalizer;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.Whitespace;

public class NormalizeUnicode
extends SystemFunction {
    @Override
    public StringValue call(XPathContext context, Sequence[] arguments) throws XPathException {
        StringValue sv = (StringValue)arguments[0].head();
        if (sv == null) {
            return StringValue.EMPTY_STRING;
        }
        String nf = arguments.length == 1 ? "NFC" : Whitespace.trim(arguments[1].head().getStringValue());
        return new StringValue(NormalizeUnicode.normalize(sv.getStringValue(), nf, context));
    }

    public static String normalize(String sv, String form, XPathContext c) throws XPathException {
        Normalizer.Form fb;
        if (form.equalsIgnoreCase("NFC")) {
            fb = Normalizer.Form.NFC;
        } else if (form.equalsIgnoreCase("NFD")) {
            fb = Normalizer.Form.NFD;
        } else if (form.equalsIgnoreCase("NFKC")) {
            fb = Normalizer.Form.NFKC;
        } else if (form.equalsIgnoreCase("NFKD")) {
            fb = Normalizer.Form.NFKD;
        } else {
            if (form.isEmpty()) {
                return sv;
            }
            String msg = "Normalization form " + form + " is not supported";
            XPathException err = new XPathException(msg);
            err.setErrorCode("FOCH0003");
            err.setXPathContext(c);
            throw err;
        }
        return Normalizer.normalize(sv, fb);
    }
}

