/*
 * Decompiled with CFR 0.152.
 */
package org.picocontainer.classname;

import java.io.Serializable;
import java.net.URL;
import java.security.Permission;
import java.security.Permissions;
import java.util.ArrayList;
import java.util.List;

public class ClassPathElement
implements Serializable {
    private final URL url;
    private Permissions permissionCollection;
    private final List<Permission> permissions = new ArrayList<Permission>();

    public ClassPathElement(URL url) {
        this.url = url;
    }

    public Permission grantPermission(Permission permission) {
        if (permission == null) {
            throw new NullPointerException();
        }
        this.permissions.add(permission);
        return permission;
    }

    public URL getUrl() {
        return this.url;
    }

    public Permissions getPermissionCollection() {
        if (this.permissionCollection == null) {
            this.permissionCollection = new Permissions();
            for (Permission permission : this.permissions) {
                this.permissionCollection.add(permission);
            }
        }
        return this.permissionCollection;
    }

    public String toString() {
        return "[" + System.identityHashCode(this) + " " + this.url + " " + this.permissions.size() + "]";
    }
}

