import { type AttributeStatement, type EdgeRhs, type EdgeStatement, type Graph, type Identifier, type NodeId, type SourceFile, type Statement, type StatementOf, type SubGraphStatement, SyntaxKind, type SyntaxNode, type Token } from "./types.js";
export declare function checkSourceFile(file: SourceFile): void;
export declare function findNodeAtOffset(root: SyntaxNode, offset: number, inclusiveEnd?: boolean): SyntaxNode | undefined;
export declare function getAllowedEdgeOperation(graph: Graph): SyntaxKind.DirectedEdgeOp | SyntaxKind.UndirectedEdgeOp;
export declare function findAllEdges(node: SyntaxNode): EdgeRhs[];
export declare function findOptionalSemicolons(node: SyntaxNode): Token<SyntaxKind.SemicolonToken>[];
export declare function findAllStatements<T extends Statement["kind"]>(node: SyntaxNode, kind?: T): StatementOf<T>[];
export declare function isAttrStatement(node: SyntaxNode): node is AttributeStatement;
export declare function isEdgeStatement(node: SyntaxNode): node is EdgeStatement;
export declare function isSubGraphStatement(node: SyntaxNode): node is SubGraphStatement;
export declare function isNodeId(node: SyntaxNode): node is NodeId;
export declare function edgeStatementHasAttributes(es: EdgeStatement): boolean;
export declare function getIdentifierText(n: Identifier): string;
export declare function nodeContainsErrors(node: SyntaxNode): boolean;
