/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.progress.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.e4.ui.progress.internal.AnimationItem;
import org.eclipse.e4.ui.progress.internal.AnimationManager;
import org.eclipse.e4.ui.progress.internal.IAnimationProcessor;
import org.eclipse.e4.ui.progress.internal.ProgressAnimationItem;
import org.eclipse.e4.ui.progress.internal.legacy.PlatformUI;

class ProgressAnimationProcessor
implements IAnimationProcessor {
    AnimationManager manager;
    List<AnimationItem> items = Collections.synchronizedList(new ArrayList());

    ProgressAnimationProcessor(AnimationManager animationManager) {
        this.manager = animationManager;
    }

    public void startAnimationLoop(IProgressMonitor monitor) {
        ProgressAnimationItem[] animationItems;
        if (this.items.isEmpty()) {
            return;
        }
        if (!PlatformUI.isWorkbenchRunning()) {
            return;
        }
        while (this.manager.isAnimated() && !monitor.isCanceled()) {
        }
        ProgressAnimationItem[] progressAnimationItemArray = animationItems = this.getAnimationItems();
        int n = animationItems.length;
        int n2 = 0;
        while (n2 < n) {
            ProgressAnimationItem animationItem = progressAnimationItemArray[n2];
            animationItem.animationDone();
            ++n2;
        }
    }

    @Override
    public void addItem(AnimationItem item) {
        Assert.isTrue((boolean)(item instanceof ProgressAnimationItem));
        this.items.add(item);
    }

    @Override
    public void removeItem(AnimationItem item) {
        Assert.isTrue((boolean)(item instanceof ProgressAnimationItem));
        this.items.remove(item);
    }

    @Override
    public boolean hasItems() {
        return this.items.size() > 0;
    }

    public void itemsInactiveRedraw() {
    }

    @Override
    public void animationStarted() {
        ProgressAnimationItem[] animationItems;
        ProgressAnimationItem[] progressAnimationItemArray = animationItems = this.getAnimationItems();
        int n = animationItems.length;
        int n2 = 0;
        while (n2 < n) {
            ProgressAnimationItem animationItem = progressAnimationItemArray[n2];
            ((AnimationItem)animationItem).animationStart();
            ++n2;
        }
    }

    @Override
    public int getPreferredWidth() {
        return 30;
    }

    private ProgressAnimationItem[] getAnimationItems() {
        ProgressAnimationItem[] animationItems = new ProgressAnimationItem[this.items.size()];
        this.items.toArray(animationItems);
        return animationItems;
    }

    @Override
    public void animationFinished() {
        ProgressAnimationItem[] animationItems;
        ProgressAnimationItem[] progressAnimationItemArray = animationItems = this.getAnimationItems();
        int n = animationItems.length;
        int n2 = 0;
        while (n2 < n) {
            ProgressAnimationItem animationItem = progressAnimationItemArray[n2];
            ((AnimationItem)animationItem).animationDone();
            ++n2;
        }
    }

    @Override
    public boolean isProcessorJob(Job job) {
        return false;
    }
}

