/*
 * Decompiled with CFR 0.152.
 */
package org.cts.op.transformation.grids;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.BitSet;
import org.cts.cs.GeographicExtent;
import org.cts.op.transformation.grids.GeographicGrid;

public class BleggGeographicGrid
extends GeographicGrid {
    private static DecimalFormat formatter = new DecimalFormat();
    private int groupSize;

    public int getGroupSize() {
        return this.groupSize;
    }

    public void setGroupSize(int groupSize) {
        this.groupSize = groupSize;
    }

    public BleggGeographicGrid(InputStream is) throws Exception {
        DataInputStream dis = new DataInputStream(is);
        this.dim = 1;
        int pos = 0;
        byte[] bytes = new byte[5];
        dis.read(bytes);
        pos += 5;
        String signature = new String(bytes);
        if (!signature.equals("BLEGG")) {
            throw new Exception("The file is not a Bit Level Encoded Geographic Grid");
        }
        this.groupSize = dis.readInt();
        pos += 4;
        this.rowNumber = dis.readInt();
        pos += 4;
        this.colNumber = dis.readInt();
        pos += 4;
        this.scale = dis.readInt();
        pos += 4;
        this.x0 = dis.readDouble();
        pos += 8;
        this.y0 = dis.readDouble();
        pos += 8;
        double gridWidth = dis.readDouble();
        pos += 8;
        double gridHeight = dis.readDouble();
        pos += 8;
        this.xL = this.x0 + gridWidth;
        this.yL = this.y0 - gridHeight;
        this.dx = gridWidth / (double)(this.colNumber - 1);
        this.dy = -gridHeight / (double)(this.rowNumber - 1);
        this.extent = new GeographicExtent("GG", this.yL, this.y0, this.x0, this.xL, 360.0);
        int[] intVal = new int[(this.rowNumber * this.colNumber + this.groupSize - 3) / this.groupSize * this.groupSize + 2];
        intVal[0] = dis.readInt();
        pos += 4;
        intVal[1] = dis.readInt();
        pos += 4;
        int groupNumber = 0;
        while (dis.available() > 0) {
            byte n = dis.readByte();
            ++pos;
            byte[] bb = new byte[n * this.groupSize / 8];
            dis.readFully(bb);
            pos += bb.length;
            NBitArray bitArray = new NBitArray(n, this.groupSize);
            bitArray.setBytes(bb);
            for (int i = 0; i < this.groupSize; ++i) {
                int serialNumber = 2 + groupNumber * this.groupSize + i;
                intVal[serialNumber] = intVal[serialNumber - 1] + intVal[serialNumber - 1] - intVal[serialNumber - 2] + bitArray.getValue(i);
            }
            ++groupNumber;
        }
        this.values = new double[this.rowNumber][this.colNumber][];
        this.values[0][0][0] = (float)intVal[0] / (float)this.scale;
        this.values[0][1][0] = (float)intVal[1] / (float)this.scale;
        for (int i = 2; i < this.rowNumber * this.colNumber; ++i) {
            int[] lc = this.getPos(i, this.rowNumber, this.colNumber);
            this.values[lc[0]][lc[1]][0] = (float)intVal[i] / (float)this.scale;
        }
    }

    public static void compress(double[][][] values, int scale, int groupSize, OutputStream os) throws Exception {
        BleggGeographicGrid.compress(values, scale, groupSize, 0.0, 0.0, values.length, values[0].length, os);
    }

    public static void compress(double[][][] values, int scale, int groupSize, double x0, double y0, double gridWidth, double gridHeight, OutputStream os) throws Exception {
        int nbl = values.length;
        int nbc = values[0].length;
        DataOutputStream dos = new DataOutputStream(os);
        dos.writeBytes("BLEGG");
        dos.writeInt(groupSize);
        dos.writeInt(nbl);
        dos.writeInt(nbc);
        dos.writeInt(scale);
        dos.writeDouble(x0);
        dos.writeDouble(y0);
        dos.writeDouble(gridWidth == 0.0 ? (double)nbc : gridWidth);
        dos.writeDouble(gridHeight == 0.0 ? -((double)nbc) : gridHeight);
        int length = (nbl * nbc + groupSize - 3) / groupSize * groupSize + 2;
        int[] val = new int[length];
        for (int i = 0; i < nbl; ++i) {
            for (int j = 0; j < nbc; ++j) {
                if (i % 2 == 0) {
                    val[i * nbc + j] = (int)Math.rint(values[i][j][0] * (double)scale);
                    continue;
                }
                val[(i + 1) * nbc - j - 1] = (int)Math.rint(values[i][j][0] * (double)scale);
            }
        }
        formatter.applyPattern("+00;-00");
        int[] diff = new int[length];
        for (int i = 1; i < nbl * nbc; ++i) {
            diff[i] = val[i] - val[i - 1];
        }
        dos.writeInt(val[0]);
        dos.writeInt(val[1]);
        int[] slope = new int[length];
        for (int i = 2; i < nbl * nbc; ++i) {
            slope[i] = diff[i] - diff[i - 1];
        }
        byte[] bytes = new byte[]{};
        try {
            for (int i = 0; i < (length - 2) / groupSize; ++i) {
                int[] block = new int[groupSize];
                System.arraycopy(slope, 2 + i * groupSize, block, 0, groupSize);
                int[] blockClone = new int[groupSize];
                System.arraycopy(block, 0, blockClone, 0, groupSize);
                Arrays.sort(blockClone);
                int maxAbs = Math.max(Math.abs(blockClone[0]), Math.abs(blockClone[blockClone.length - 1]));
                int n = (int)Math.max(0.0, Math.log(maxAbs) / Math.log(2.0) + 2.0);
                NBitArray group = new NBitArray(n, groupSize);
                for (int j = 0; j < groupSize; ++j) {
                    group.setValue(block[j], j);
                }
                dos.writeByte(n);
                dos.write(group.getBytes());
            }
            dos.close();
        }
        catch (Exception e) {
            dos.close();
            throw e;
        }
    }

    public static void write(GeographicGrid gg, OutputStream os) throws Exception {
        BleggGeographicGrid.compress(gg.getValues(), gg.getScale(), 16, gg.getX0(), gg.getY0(), gg.getGridWidth(), gg.getGridHeight(), os);
    }

    private int[] getPos(int serialNumber, int nbl, int nbc) {
        if (serialNumber >= nbl * nbc) {
            return null;
        }
        int line = serialNumber / nbc;
        int column = line % 2 == 0 ? serialNumber - line * nbc : nbc - 1 - (serialNumber - line * nbc);
        return new int[]{line, column};
    }

    static class NBitArray {
        BitSet bitSet;
        int nbBits;
        int groupSize;

        public NBitArray(int nbBits, int groupSize) throws Exception {
            if (groupSize * nbBits % 8 != 0) {
                throw new Exception("La taille d'un bloc doit \ufffdtre un multiple de 8");
            }
            this.nbBits = nbBits;
            this.groupSize = groupSize;
            this.bitSet = new BitSet(groupSize * nbBits);
        }

        public int getValue(int n) {
            return this.getValue(n, this.nbBits);
        }

        public int getValue(int n, int size) {
            if (size == 0) {
                return 0;
            }
            int ret = 0;
            int powerOf2 = 1;
            for (int i = 0; i < size - 1; ++i) {
                if (this.bitSet.get(n * size + i)) {
                    ret += powerOf2;
                }
                powerOf2 *= 2;
            }
            if (this.bitSet.get((n + 1) * size - 1)) {
                ret = -ret;
            }
            return ret;
        }

        public void setValue(int value, int pos) {
            this.setValue(value, pos, this.nbBits);
        }

        public void setValue(int value, int n, int size) {
            int powerOf2 = 1;
            int abs = Math.abs(value);
            for (int i = 0; i < size - 1; ++i) {
                if ((abs & powerOf2) == powerOf2) {
                    this.bitSet.set(n * size + i);
                }
                powerOf2 *= 2;
            }
            if (value < 0) {
                this.bitSet.set((n + 1) * size - 1);
            }
        }

        public byte[] getBytes() {
            byte[] bytes = new byte[this.groupSize * this.nbBits / 8];
            for (int i = 0; i < this.bitSet.length(); ++i) {
                if (!this.bitSet.get(i)) continue;
                if (i % 8 == 0) {
                    bytes[i / 8] = (byte)(bytes[i / 8] | 1);
                    continue;
                }
                if (i % 8 == 1) {
                    bytes[i / 8] = (byte)(bytes[i / 8] | 2);
                    continue;
                }
                if (i % 8 == 2) {
                    bytes[i / 8] = (byte)(bytes[i / 8] | 4);
                    continue;
                }
                if (i % 8 == 3) {
                    bytes[i / 8] = (byte)(bytes[i / 8] | 8);
                    continue;
                }
                if (i % 8 == 4) {
                    bytes[i / 8] = (byte)(bytes[i / 8] | 0x10);
                    continue;
                }
                if (i % 8 == 5) {
                    bytes[i / 8] = (byte)(bytes[i / 8] | 0x20);
                    continue;
                }
                if (i % 8 == 6) {
                    bytes[i / 8] = (byte)(bytes[i / 8] | 0x40);
                    continue;
                }
                if (i % 8 != 7) continue;
                bytes[i / 8] = (byte)(bytes[i / 8] | 0xFFFFFF80);
            }
            return bytes;
        }

        public void setBytes(byte[] bytes) {
            for (int i = 0; i < bytes.length; ++i) {
                if ((bytes[i] & 1) == 1) {
                    this.bitSet.set(i * 8 + 0);
                }
                if ((bytes[i] & 2) == 2) {
                    this.bitSet.set(i * 8 + 1);
                }
                if ((bytes[i] & 4) == 4) {
                    this.bitSet.set(i * 8 + 2);
                }
                if ((bytes[i] & 8) == 8) {
                    this.bitSet.set(i * 8 + 3);
                }
                if ((bytes[i] & 0x10) == 16) {
                    this.bitSet.set(i * 8 + 4);
                }
                if ((bytes[i] & 0x20) == 32) {
                    this.bitSet.set(i * 8 + 5);
                }
                if ((bytes[i] & 0x40) == 64) {
                    this.bitSet.set(i * 8 + 6);
                }
                if ((bytes[i] & 0xFFFFFF80) != -128) continue;
                this.bitSet.set(i * 8 + 7);
            }
        }

        public String toString() {
            return "Champ de " + this.groupSize + " x " + this.nbBits + " bits :\n" + this.bitSet.toString();
        }
    }
}

