/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.resources.undo.snapshot;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URI;
import java.util.Map;
import org.eclipse.core.internal.resources.undo.snapshot.ContainerSnapshot;
import org.eclipse.core.internal.resources.undo.snapshot.FileSnapshot;
import org.eclipse.core.internal.resources.undo.snapshot.FolderSnapshot;
import org.eclipse.core.internal.resources.undo.snapshot.IFileContentSnapshot;
import org.eclipse.core.internal.resources.undo.snapshot.MarkerSnapshot;
import org.eclipse.core.internal.resources.undo.snapshot.ProjectSnapshot;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.undo.snapshot.IContainerSnapshot;
import org.eclipse.core.resources.undo.snapshot.IMarkerSnapshot;
import org.eclipse.core.resources.undo.snapshot.IResourceSnapshot;
import org.eclipse.core.runtime.CoreException;

public class ResourceSnapshotFactory {
    public static <T extends IResource> IResourceSnapshot<T> fromResource(T resource) {
        if (resource.getType() == 4) {
            return new ProjectSnapshot((IProject)resource);
        }
        if (resource.getType() == 2) {
            return new FolderSnapshot((IFolder)resource, resource.isVirtual());
        }
        if (resource.getType() == 1) {
            return new FileSnapshot((IFile)resource);
        }
        throw new IllegalArgumentException();
    }

    public static IContainerSnapshot<IProject> fromProjectDescription(IProjectDescription projectDescription) {
        return new ProjectSnapshot(projectDescription);
    }

    public static IContainerSnapshot<? extends IContainer> fromContainer(IContainer container) {
        return ContainerSnapshot.fromContainer(container);
    }

    public static IContainerSnapshot<? extends IContainer> fromVirtualFolderContainer(IContainer container) {
        return ContainerSnapshot.fromContainer(container, true);
    }

    public static IResourceSnapshot<IFile> fromFileDetails(IFile file, URI linkLocation, InputStream contents) {
        return new FileSnapshot(file, linkLocation, ResourceSnapshotFactory.createFileContentDescription(file, contents));
    }

    public static IMarkerSnapshot fromMarker(IMarker marker) throws CoreException {
        return new MarkerSnapshot(marker);
    }

    public static IMarkerSnapshot fromMarkerDetails(String type, Map<String, Object> attributes, IResource resource) {
        return new MarkerSnapshot(type, attributes, resource);
    }

    private static IFileContentSnapshot createFileContentDescription(final IFile file, final InputStream contents) {
        return new IFileContentSnapshot(){

            @Override
            public InputStream getContents() {
                if (contents != null) {
                    return contents;
                }
                return new ByteArrayInputStream(new byte[0]);
            }

            @Override
            public String getCharset() {
                try {
                    return file.getCharset(false);
                }
                catch (CoreException e) {
                    return null;
                }
            }

            @Override
            public boolean exists() {
                return true;
            }
        };
    }
}

