/*
 * Decompiled with CFR 0.152.
 */
package proguard.gui.splash;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import proguard.gui.splash.Sprite;
import proguard.gui.splash.VariableInt;

public class BufferedSprite
implements Sprite {
    private final int bufferX;
    private final int bufferY;
    private final Image bufferImage;
    private final Color backgroundColor;
    private final Sprite sprite;
    private final VariableInt x;
    private final VariableInt y;
    private long cachedTime = -1L;

    public BufferedSprite(int bufferX, int bufferY, int width, int height, Sprite sprite, VariableInt x, VariableInt y) {
        this(bufferX, bufferY, new BufferedImage(width, height, 6), null, sprite, x, y);
    }

    public BufferedSprite(int bufferX, int bufferY, Image bufferImage, Color backgroundColor, Sprite sprite, VariableInt x, VariableInt y) {
        this.bufferX = bufferX;
        this.bufferY = bufferY;
        this.bufferImage = bufferImage;
        this.backgroundColor = backgroundColor;
        this.sprite = sprite;
        this.x = x;
        this.y = y;
    }

    @Override
    public void paint(Graphics graphics, long time) {
        if (time != this.cachedTime) {
            Graphics bufferGraphics = this.bufferImage.getGraphics();
            if (this.backgroundColor != null) {
                Graphics2D bufferGraphics2D = (Graphics2D)bufferGraphics;
                bufferGraphics2D.setComposite(AlphaComposite.Clear);
                bufferGraphics.fillRect(0, 0, this.bufferImage.getWidth(null), this.bufferImage.getHeight(null));
                bufferGraphics2D.setComposite(AlphaComposite.Src);
            } else {
                bufferGraphics.setColor(this.backgroundColor);
                bufferGraphics.fillRect(0, 0, this.bufferImage.getWidth(null), this.bufferImage.getHeight(null));
            }
            bufferGraphics.translate(-this.bufferX, -this.bufferY);
            bufferGraphics.setColor(graphics.getColor());
            bufferGraphics.setFont(graphics.getFont());
            this.sprite.paint(bufferGraphics, time);
            bufferGraphics.dispose();
            this.cachedTime = time;
        }
        graphics.drawImage(this.bufferImage, this.bufferX + this.x.getInt(time), this.bufferY + this.y.getInt(time), null);
    }
}

