/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.v4.gui;

import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.antlr.runtime.RecognitionException;
import org.antlr.v4.Tool;
import org.antlr.v4.gui.Trees;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonToken;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.LexerInterpreter;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.atn.DecisionInfo;
import org.antlr.v4.runtime.atn.ParseInfo;
import org.antlr.v4.runtime.tree.Tree;
import org.antlr.v4.tool.ANTLRToolListener;
import org.antlr.v4.tool.DefaultToolListener;
import org.antlr.v4.tool.Grammar;
import org.antlr.v4.tool.GrammarParserInterpreter;
import org.antlr.v4.tool.LexerGrammar;
import org.antlr.v4.tool.Rule;

public class Interpreter {
    public static final String[] profilerColumnNames = new String[]{"Rule", "Invocations", "Time (ms)", "Total k", "Max k", "Ambiguities", "DFA cache miss"};
    protected String grammarFileName;
    protected String parserGrammarFileName;
    protected String lexerGrammarFileName;
    protected String startRuleName;
    protected boolean printTree = false;
    protected boolean gui = false;
    protected boolean trace = false;
    protected String encoding = null;
    protected boolean showTokens = false;
    protected String profileFileName = null;
    protected String inputFileName;

    public Interpreter(String[] args) throws Exception {
        if (args.length < 2) {
            System.err.println("java org.antlr.v4.gui.Intrepreter [X.g4|XParser.g4 XLexer.g4] startRuleName\n  [-tokens] [-tree] [-gui] [-encoding encodingname]\n  [-trace] [-profile filename.csv] [input-filename(s)]");
            System.err.println("Omitting input-filename makes rig read from stdin.");
            return;
        }
        int i = 0;
        this.grammarFileName = args[i];
        if (args[++i].endsWith(".g4")) {
            this.parserGrammarFileName = this.grammarFileName;
            this.lexerGrammarFileName = args[i];
            ++i;
            this.grammarFileName = null;
            if (this.parserGrammarFileName.toLowerCase().endsWith("lexer.g4")) {
                String save = this.parserGrammarFileName;
                this.parserGrammarFileName = this.lexerGrammarFileName;
                this.lexerGrammarFileName = save;
            }
        }
        this.startRuleName = args[i];
        ++i;
        while (i < args.length) {
            String arg = args[i];
            ++i;
            if (arg.charAt(0) != '-') {
                this.inputFileName = arg;
                continue;
            }
            if (arg.equals("-tree")) {
                this.printTree = true;
                continue;
            }
            if (arg.equals("-gui")) {
                this.gui = true;
                continue;
            }
            if (arg.equals("-tokens")) {
                this.showTokens = true;
                continue;
            }
            if (arg.equals("-trace")) {
                this.trace = true;
                continue;
            }
            if (arg.equals("-profile")) {
                if (i >= args.length) {
                    System.err.println("missing CSV filename on -profile (ignoring -profile)");
                    return;
                }
                if (args[i].startsWith("-")) {
                    System.err.println("missing CSV filename on -profile (ignoring -profile)");
                    return;
                }
                this.profileFileName = args[i];
                if (!this.profileFileName.endsWith(".csv")) {
                    System.err.println("warning: missing '.csv' suffix on -profile filename: " + this.profileFileName);
                }
                ++i;
                continue;
            }
            if (!arg.equals("-encoding")) continue;
            if (i >= args.length) {
                System.err.println("missing encoding on -encoding");
                return;
            }
            this.encoding = args[i];
            ++i;
        }
    }

    protected ParseInfo interp() throws RecognitionException, IOException {
        IgnoreTokenVocabGrammar g;
        if (this.grammarFileName == null && this.parserGrammarFileName == null && this.lexerGrammarFileName == null) {
            return null;
        }
        LexerGrammar lg = null;
        DefaultToolListener listener = new DefaultToolListener(new Tool());
        if (this.grammarFileName != null) {
            String grammarContent = Files.readString(Path.of(this.grammarFileName, new String[0]));
            g = new IgnoreTokenVocabGrammar(this.grammarFileName, grammarContent, null, listener);
        } else {
            String lexerGrammarContent = Files.readString(Path.of(this.lexerGrammarFileName, new String[0]));
            lg = new LexerGrammar(lexerGrammarContent, listener);
            String parserGrammarContent = Files.readString(Path.of(this.parserGrammarFileName, new String[0]));
            g = new IgnoreTokenVocabGrammar(this.parserGrammarFileName, parserGrammarContent, lg, listener);
        }
        Charset charset = this.encoding == null ? Charset.defaultCharset() : Charset.forName(this.encoding);
        CharStream charStream = null;
        if (this.inputFileName == null) {
            charStream = CharStreams.fromStream(System.in, charset);
        } else {
            try {
                charStream = CharStreams.fromPath(Paths.get(this.inputFileName, new String[0]), charset);
            }
            catch (NoSuchFileException nsfe) {
                System.err.println("Can't find input file " + this.inputFileName);
                System.exit(1);
            }
        }
        LexerInterpreter lexEngine = lg != null ? lg.createLexerInterpreter(charStream) : g.createLexerInterpreter(charStream);
        CommonTokenStream tokens = new CommonTokenStream(lexEngine);
        tokens.fill();
        if (this.showTokens) {
            for (Token tok : tokens.getTokens()) {
                if (tok instanceof CommonToken) {
                    System.out.println(((CommonToken)tok).toString(lexEngine));
                    continue;
                }
                System.out.println(tok.toString());
            }
        }
        GrammarParserInterpreter parser = g.createGrammarParserInterpreter(tokens);
        if (this.profileFileName != null) {
            parser.setProfile(true);
        }
        parser.setTrace(this.trace);
        Rule r = (Rule)g.rules.get(this.startRuleName);
        if (r == null) {
            System.err.println("No such start rule: " + this.startRuleName);
            return null;
        }
        ParserRuleContext t = parser.parse(r.index);
        ParseInfo parseInfo = parser.getParseInfo();
        if (this.printTree) {
            System.out.println(t.toStringTree(parser));
        }
        if (this.gui) {
            Trees.inspect((Tree)t, parser);
        }
        if (this.profileFileName != null) {
            this.dumpProfilerCSV(parser, parseInfo);
        }
        return parseInfo;
    }

    private void dumpProfilerCSV(GrammarParserInterpreter parser, ParseInfo parseInfo) {
        String[] ruleNamesByDecision = new String[parser.getATN().decisionToState.size()];
        for (int i = 0; i < ruleNamesByDecision.length; ++i) {
            ruleNamesByDecision[i] = parser.getRuleNames()[parser.getATN().getDecisionState((int)i).ruleIndex];
        }
        DecisionInfo[] decisionInfo = parseInfo.getDecisionInfo();
        String[][] table = new String[decisionInfo.length][profilerColumnNames.length];
        for (int decision = 0; decision < decisionInfo.length; ++decision) {
            for (int col = 0; col < profilerColumnNames.length; ++col) {
                Object colVal = Interpreter.getValue(decisionInfo[decision], ruleNamesByDecision, decision, col);
                table[decision][col] = colVal.toString();
            }
        }
        try {
            FileWriter fileWriter = new FileWriter(this.profileFileName);
            PrintWriter pw = new PrintWriter(fileWriter);
            for (int i = 0; i < profilerColumnNames.length; ++i) {
                if (i > 0) {
                    pw.print(",");
                }
                pw.print(profilerColumnNames[i]);
            }
            pw.println();
            for (String[] row : table) {
                for (int i = 0; i < profilerColumnNames.length; ++i) {
                    if (i > 0) {
                        pw.print(",");
                    }
                    pw.print(row[i]);
                }
                pw.println();
            }
            pw.close();
        }
        catch (IOException ioe) {
            System.err.println("Error writing profile info to " + this.profileFileName + ": " + ioe.getMessage());
        }
    }

    public static Object getValue(DecisionInfo decisionInfo, String[] ruleNamesByDecision, int decision, int col) {
        switch (col) {
            case 0: {
                return String.format("%s:%d", ruleNamesByDecision[decision], decision);
            }
            case 1: {
                return decisionInfo.invocations;
            }
            case 2: {
                return (double)decisionInfo.timeInPrediction / 1000000.0;
            }
            case 3: {
                return decisionInfo.LL_TotalLook + decisionInfo.SLL_TotalLook;
            }
            case 4: {
                return Math.max(decisionInfo.LL_MaxLook, decisionInfo.SLL_MaxLook);
            }
            case 5: {
                return decisionInfo.ambiguities.size();
            }
            case 6: {
                return decisionInfo.SLL_ATNTransitions + decisionInfo.LL_ATNTransitions;
            }
        }
        return "n/a";
    }

    public static void main(String[] args) throws Exception {
        Interpreter I = new Interpreter(args);
        I.interp();
    }

    protected static class IgnoreTokenVocabGrammar
    extends Grammar {
        public IgnoreTokenVocabGrammar(String fileName, String grammarText, Grammar tokenVocabSource, ANTLRToolListener listener) throws RecognitionException {
            super(fileName, grammarText, tokenVocabSource, listener);
        }

        @Override
        public void importTokensFromTokensFile() {
        }
    }
}

