/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.sdbcx.comp.hsqldb;

import com.sun.star.sdbcx.comp.hsqldb.NativeInputStreamHelper;
import com.sun.star.sdbcx.comp.hsqldb.NativeLibraries;
import com.sun.star.sdbcx.comp.hsqldb.NativeOutputStreamHelper;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.NoSuchElementException;
import org.hsqldb.lib.FileAccess;
import org.hsqldb.lib.FileSystemRuntimeException;

public class StorageFileAccess
implements FileAccess {
    String ds_name;
    String key;

    public StorageFileAccess(Object object) throws Exception {
        this.key = (String)object;
    }

    @Override
    public void createParentDirs(String string) {
    }

    @Override
    public boolean isStreamElement(String string) {
        return StorageFileAccess.isStreamElement(this.key, string);
    }

    @Override
    public InputStream openInputStreamElement(String string) throws IOException {
        return new NativeInputStreamHelper(this.key, string);
    }

    @Override
    public OutputStream openOutputStreamElement(String string) throws IOException {
        return new NativeOutputStreamHelper(this.key, string);
    }

    @Override
    public void removeElement(String string) throws NoSuchElementException {
        try {
            if (StorageFileAccess.isStreamElement(this.key, string)) {
                StorageFileAccess.removeElement(this.key, string);
            }
        }
        catch (IOException iOException) {
            throw new FileSystemRuntimeException(iOException);
        }
    }

    @Override
    public void renameElement(String string, String string2) throws NoSuchElementException {
        try {
            if (StorageFileAccess.isStreamElement(this.key, string)) {
                StorageFileAccess.removeElement(this.key, string2);
                StorageFileAccess.renameElement(this.key, string, string2);
            }
        }
        catch (IOException iOException) {
            throw new FileSystemRuntimeException(iOException);
        }
    }

    @Override
    public FileAccess.FileSync getFileSync(OutputStream outputStream) throws IOException {
        return new FileSync((NativeOutputStreamHelper)outputStream);
    }

    static native boolean isStreamElement(String var0, String var1);

    static native void removeElement(String var0, String var1) throws NoSuchElementException, IOException;

    static native void renameElement(String var0, String var1, String var2) throws NoSuchElementException, IOException;

    static {
        NativeLibraries.load();
    }

    private static class FileSync
    implements FileAccess.FileSync {
        private final NativeOutputStreamHelper os;

        private FileSync(NativeOutputStreamHelper nativeOutputStreamHelper) {
            this.os = nativeOutputStreamHelper;
        }

        @Override
        public void sync() throws IOException {
            this.os.sync();
        }
    }
}

