#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 tree-diff
version:              0.3.0.1
visibility:           public
id:                   tree-diff-0.3.0.1-KnOvAO1VURA8l651I8WV4p
key:                  tree-diff-0.3.0.1-KnOvAO1VURA8l651I8WV4p
license:              GPL-2.0-or-later
copyright:            (c) 2017-2021 Oleg Grenrus
maintainer:           Oleg.Grenrus <oleg.grenrus@iki.fi>
author:               Oleg Grenrus <oleg.grenrus@iki.fi>
homepage:             https://github.com/phadej/tree-diff
synopsis:             Diffing of (expression) trees.
description:
    Common diff algorithm works on list structures:

    @
    diff :: Eq a => [a] -> [a] -> [Edit a]
    @

    This package works on trees.

    @
    treeDiff :: Eq a => Tree a -> Tree a -> Edit (EditTree a)
    @

    This package also provides a way to diff arbitrary ADTs,
    using @Generics@-derivable helpers.

    This package differs from <http://hackage.haskell.org/package/gdiff gdiff>,
    in a two ways: @tree-diff@ doesn'\''t have patch function,
    and the "edit-script" is a tree itself, which is useful for pretty-printing.

    @
    >>> prettyEditExpr $ ediff (Foo 42 [True, False] "old") (Foo 42 [False, False, True] "new")
    Foo
    \  {fooBool = [-True, +False, False, +True],
    \   fooInt = 42,
    \   fooString = -"old" +"new"}
    @

category:             Data, Testing
abi:                  12778bb9ffba58c22099b050791b10d2
exposed:              True
exposed-modules:
    Data.TreeDiff Data.TreeDiff.Class Data.TreeDiff.Expr
    Data.TreeDiff.Golden Data.TreeDiff.List Data.TreeDiff.OMap
    Data.TreeDiff.Parser Data.TreeDiff.Pretty Data.TreeDiff.QuickCheck
    Data.TreeDiff.Tree

import-dirs:          /usr/lib/ghc-9.6.6/site-local/tree-diff-0.3.0.1
library-dirs:         /usr/lib/ghc-9.6.6/site-local/tree-diff-0.3.0.1
library-dirs-static:  /usr/lib/ghc-9.6.6/site-local/tree-diff-0.3.0.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-tree-diff
hs-libraries:         HStree-diff-0.3.0.1-KnOvAO1VURA8l651I8WV4p
depends:
    QuickCheck-2.15.0.1-3qjshr9DgdW3qKiQXq7Lfs
    aeson-2.1.2.1-KAplhvfLEdp6k37mi9zTZA
    ansi-terminal-1.0.2-5RUb9SpCZmqDNBPT2BV2fb
    ansi-wl-pprint-1.0.2-E3W7aTaQkQkIbJebItThok base-4.18.2.1
    base-compat-0.14.1-4heBy5B59ewBpEOwRrJlc4 bytestring-0.11.5.3
    containers-0.6.7 deepseq-1.4.8.1
    hashable-1.4.7.0-9Up8LPJnqTG92zCMBiHaIh parsec-3.1.16.1
    parsers-0.12.12-DfYdVEQmGRRB46RG1X00Px pretty-1.1.3.6
    primitive-0.9.1.0-AmjYrOULh0Y82MuHW1HjrT
    scientific-0.3.8.0-4yI3uLcaGfNJ0xFa1ruDPP
    semialign-1.3.1-4LTMz5ZykDmAE6l9lRjhw9
    strict-0.5.1-9Nqiw3FnuHx1kCrnHZcxzj
    tagged-0.8.9-2fCpivRH6QIGdlOWfdc5ig text-2.0.2
    these-1.2.1-8taFCVNAG5Z2bkRtrXUj5y time-1.12.2
    unordered-containers-0.2.20.1-CjV5euINhym8dGoasHPURS
    uuid-types-1.0.6-EfgndHK16Dpo4qWhhuLlA
    vector-0.13.2.0-3Co1wNPhccp6XnsJEn8cXR

haddock-interfaces:   /usr/share/doc/haskell-tree-diff/html/tree-diff.haddock
haddock-html:         /usr/share/doc/haskell-tree-diff/html
' | '/usr/bin/ghc-pkg-9.6.6' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

