#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 z-haskell-ci-z-haskell-ci-internal
version:              0.16.6
package-name:         haskell-ci
lib-name:             haskell-ci-internal
id:
    haskell-ci-0.16.6-HnWP0Mr1bMX2hxhPFMt6WA-haskell-ci-internal

key:
    haskell-ci-0.16.6-HnWP0Mr1bMX2hxhPFMt6WA-haskell-ci-internal

license:              GPL-3.0-or-later
maintainer:           hvr@gnu.org
author:               Herbert Valerio Riedel, Oleg Grenrus
homepage:             https://haskell-ci.rtfd.org/
synopsis:             Cabal package script generator for Travis-CI
description:
    Script generator (@haskell-ci@) for
    [GitHub Actions](https://docs.github.com/en/actions) and
    [Travis-CI](https://travis-ci.org/)
    for continuous-integration testing of Haskell Cabal packages.

    Included features (not limited to):

    * Multiple GHC support
    * Dependency caching
    * cabal.project support (see [Nix-style local builds documentation](https://cabal.readthedocs.io/en/latest/nix-local-build-overview.html))
    * Runs tests and builds benchmarks
    * Generates Haddocks
    * GHCJS support
    * building with specific constraints

    === Quick Start Guide

    Add a @tested-with@ line to your @.cabal@ file (e.g. @tested-with: GHC == 8.0.2 || == 8.2.2@) and then run @haskell-ci yourpackage.cabal -o .travis.yml@ to generate the Travis-CI job script.

    See @haskell-ci --help@ for more information.

category:             Development
abi:                  a57103e37fad41b6997c00c7097e127f
exposed-modules:
    HaskellCI HaskellCI.Auxiliary HaskellCI.Bash
    HaskellCI.Bash.Template HaskellCI.Cabal HaskellCI.Cli
    HaskellCI.Compiler HaskellCI.Config HaskellCI.Config.Components
    HaskellCI.Config.ConstraintSet HaskellCI.Config.CopyFields
    HaskellCI.Config.Docspec HaskellCI.Config.Doctest
    HaskellCI.Config.Dump HaskellCI.Config.Empty HaskellCI.Config.Folds
    HaskellCI.Config.HLint HaskellCI.Config.Installed
    HaskellCI.Config.Jobs HaskellCI.Config.PackageScope
    HaskellCI.Config.Ubuntu HaskellCI.Config.Validity
    HaskellCI.Diagnostics HaskellCI.Error HaskellCI.Ghcup
    HaskellCI.GitConfig HaskellCI.GitHub HaskellCI.GitHub.Yaml
    HaskellCI.HeadHackage HaskellCI.Jobs HaskellCI.List
    HaskellCI.MonadErr HaskellCI.Newtypes HaskellCI.OptionsGrammar
    HaskellCI.OptparseGrammar HaskellCI.Package HaskellCI.ParsecUtils
    HaskellCI.Prelude HaskellCI.Sh HaskellCI.ShVersionRange
    HaskellCI.TestedWith HaskellCI.Tools HaskellCI.Travis
    HaskellCI.Travis.Yaml HaskellCI.VersionInfo HaskellCI.YamlSyntax

import-dirs:          /usr/lib/ghc-9.6.6/site-local/haskell-ci-0.16.6
library-dirs:         /usr/lib/ghc-9.6.6/site-local/haskell-ci-0.16.6
library-dirs-static:  /usr/lib/ghc-9.6.6/site-local/haskell-ci-0.16.6
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-ci
hs-libraries:
    HShaskell-ci-0.16.6-HnWP0Mr1bMX2hxhPFMt6WA-haskell-ci-internal

depends:
    Cabal-syntax-3.10.3.0 HsYAML-0.2.1.5-K21DbzDiwKC95qvBPkyKX8
    ShellCheck-0.11.0-DWTyAXtNIP9LjUUgqe5VSs
    aeson-2.1.2.1-KAplhvfLEdp6k37mi9zTZA
    attoparsec-0.14.4-ARFIPKVHAQdH6rZ1P31wQY base-4.18.2.1
    base-compat-0.14.1-4heBy5B59ewBpEOwRrJlc4
    base16-bytestring-1.0.2.0-6dMnLpvCfjZITVAVfsWwso binary-0.8.9.1
    bytestring-0.11.5.3
    cabal-install-parsers-0.6.1.1-H1oVGnOqYXnAOpLN64DheG
    containers-0.6.7
    cryptohash-sha256-0.11.102.1-ApSk5LfMHTl1SNuSBD4pe1 deepseq-1.4.8.1
    directory-1.3.8.5 exceptions-0.10.7 filepath-1.4.300.1
    generic-lens-lite-0.1.1-6FrqAuYwkr79qeSIo4PrbF
    indexed-traversable-0.1.4-8j5HZpShpE5BqFup9Ojenr
    indexed-traversable-instances-0.1.2-CdsfrOmarYpEBlxxW3u7tg
    ini-0.4.2-KeD1EuARkj4JZfcCMWDnlr
    lattices-2.2.1-JgbYxqNrzlu89xUQciT1eO mtl-2.3.1
    network-uri-2.6.4.2-3zCbFVr23iA8AOO7Y4yAP5
    optparse-applicative-0.18.1.0-5nnJ4FeW1ct8RzxtI8AAka
    parsec-3.1.16.1 pretty-1.1.3.6 process-1.6.19.0
    temporary-1.3-CdOGj1QmJdlAICjb9ViQf9 text-2.0.2
    transformers-0.6.1.0
    unordered-containers-0.2.20.1-CjV5euINhym8dGoasHPURS
    zinza-0.2.1-3mTg4fAJpd11y7fwDbeZor

haddock-interfaces:   /usr/share/doc/haskell-ci/html/haskell-ci.haddock
haddock-html:         /usr/share/doc/haskell-ci/html
' | '/usr/bin/ghc-pkg-9.6.6' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

